
//=============================================================================
/**
 * @file   CameraSpace.cpp
 * @brief  ԐNX
 * @author ikeda_teppei
 * @date   2012.05.29
 */
//=============================================================================

#include "CameraSpace.h"
#include "CameraUtility.h"

namespace field
{
  //-----------------------------------------------------------------------------
  // }gNX33𐶐
  //-----------------------------------------------------------------------------
  void CSpace::CreateMTX33ByFrontUpDirection(gfl::math::MTX33* pMat, const gfl::math::VEC3& inFrontDir, const gfl::math::VEC3& inUpDir)
  {
    gfl::math::VEC3 inAxisX; gfl::math::VEC3Cross(&inAxisX, &inUpDir,    &inFrontDir); gfl::math::VEC3Normalize(&inAxisX, &inAxisX);
    gfl::math::VEC3 inAxisY; gfl::math::VEC3Cross(&inAxisY, &inFrontDir, &inAxisX);
    CreateMTX33(pMat, inAxisX, inAxisY, inFrontDir);
  }

  //---------------------------------------------------------------------------------------------------------------------
  // [E҂E΂  }gNX

  //-----------------------------------------------------------------------------
  // [E҂擾
  //-----------------------------------------------------------------------------
  void CSpace::GetDirectionByYawPitch(gfl::math::VEC3* pDir, const float fYaw, const float fPitch)
  {
    gfl::math::MTX33 inMat;
    GetYawPitchBankRotMatrix(&inMat, gfl::math::VEC3(fYaw, fPitch, 0.0f));
    gfl::math::MTX33GetAxisZ(pDir, inMat);
  }

  //-----------------------------------------------------------------------------
  // [E҂E΂񂭉]s}gNX擾
  //-----------------------------------------------------------------------------
  void CSpace::GetYawPitchBankRotMatrixExtend(gfl::math::MTX33* pDestMat, const ESolveAxisOrder eSolveAxisOrder, const gfl::math::VEC3& inYPB, bool bIsIdentityMat, const gfl::math::MTX33& inSrcMat)
  {
    int anSolveAxisIndex[3] = { ASSIGN_INDEX_YAW, ASSIGN_INDEX_PITCH, ASSIGN_INDEX_BANK };
    switch( eSolveAxisOrder )
    {
    case SOLVE_AXIS_ORDER_YPB:
      break;

    default:
      GFL_ASSERT_ALWAYS;
      break;
    }

    (*pDestMat) = inSrcMat;
    for( int i = 0; i < 3; i++ )
    {
      const int nSolveAxisIndex = anSolveAxisIndex[i];
      const float fRotRadi = inYPB[nSolveAxisIndex];
      if( fRotRadi != 0.0f )
      {
        gfl::math::MTX33 inRotMat;
        if     ( nSolveAxisIndex == ASSIGN_INDEX_YAW   ) gfl::math::MTX33RotYRad(&inRotMat, fRotRadi);
        else if( nSolveAxisIndex == ASSIGN_INDEX_PITCH ) gfl::math::MTX33RotXRad(&inRotMat, fRotRadi);
        else                                             gfl::math::MTX33RotZRad(&inRotMat, fRotRadi);
        
        if( bIsIdentityMat ) { (*pDestMat) = inRotMat; bIsIdentityMat = false; }
        else                 { gfl::math::MTX33 inTempMat(*pDestMat); gfl::math::MTX33MultLimit(pDestMat, &inTempMat, &inRotMat); }
      }
    }
  }

  //---------------------------------------------------------------------------------------------------------------------
  // }gNX  [E҂E΂

#define UP_DIR_EPSILON (0.99999f)

  //-----------------------------------------------------------------------------
  // ӂ̂[E҂擾ł邩`FbN
  //-----------------------------------------------------------------------------
  bool CSpace::IsYawPitchGetDirection(const gfl::math::VEC3& inDir) { return (gfl::math::FAbs(inDir.y) < UP_DIR_EPSILON); }

  //-----------------------------------------------------------------------------
  // [E҂擾
  //-----------------------------------------------------------------------------
  bool CSpace::GetYawPitchByDirection(float* pfYaw, float* pfPitch, const gfl::math::VEC3& inDir)
  {
    const bool bIsGetDir = IsYawPitchGetDirection(inDir);
    if( bIsGetDir ) (*pfYaw) = gfl::math::Atan2Rad(inDir.x, inDir.z);
    else            (*pfYaw) = 0.0f;
    (*pfPitch) = gfl::math::AsinRad(-inDir.y);
    return bIsGetDir;
  }

  //-----------------------------------------------------------------------------
  // }gNX[E҂E΂񂭂擾
  //-----------------------------------------------------------------------------
  void CSpace::GetYawPitchBankByMatrix(gfl::math::VEC3* pYPB, const gfl::math::MTX33& inMat)
  {
    if( gfl::math::FAbs(inMat.m[1][2]) >= UP_DIR_EPSILON )
	{
		(*pYPB)[ASSIGN_INDEX_BANK]  = gfl::math::Atan2Rad(-inMat.m[0][1], inMat.m[0][0]);
		(*pYPB)[ASSIGN_INDEX_PITCH] = gfl::math::AsinRad (-inMat.m[1][2]);
        (*pYPB)[ASSIGN_INDEX_YAW]   = 0.0f;
	}
	else
	{
		(*pYPB)[ASSIGN_INDEX_BANK]  = gfl::math::Atan2Rad( inMat.m[1][0], inMat.m[1][1]);
		(*pYPB)[ASSIGN_INDEX_PITCH] = gfl::math::AsinRad (-inMat.m[1][2]);
		(*pYPB)[ASSIGN_INDEX_YAW]   = gfl::math::Atan2Rad( inMat.m[0][2], inMat.m[2][2]);
	}
  }

  //-----------------------------------------------------------------------------
  // }gNX[E҂E΂񂭂擾̊g
  //-----------------------------------------------------------------------------
  void CSpace::GetYawPitchBankByMatrixExtend(gfl::math::VEC3* pYPB, const ESolveAxisOrder eSolveAxisOrder, const gfl::math::MTX33& inMat)
  {
    switch( eSolveAxisOrder )
    {
    case SOLVE_AXIS_ORDER_YPB:
      GetYawPitchBankByMatrix(pYPB, inMat);
      break;

    default:
      GFL_ASSERT_ALWAYS;
      break;
    }
  }

} // namespace field

/*  EOF  */





