#if !defined( __APP_ZUKAN_PANELIST_H__ )
#define __APP_ZUKAN_PANELIST_H__
//============================================================================================
/**
 * @file		app_zukan_list_PaneList.h
 * @brief		yCXg
 * @author	Toru=Nagihashi
 * @date		12.05.25
 * 
 * @note  app_tool_panelist
 */
//============================================================================================
#pragma	once

#include <gflib.h>
#include <app/tool/app_tool_ScrollValue.h>


GFL_NAMESPACE_BEGIN( app )
GFL_NAMESPACE_BEGIN( zukan )
GFL_NAMESPACE_BEGIN( list )

class PaneList {
public:
	// yCf[^
	typedef struct {
		gfl::grp::g2d::LytPaneIndex	pict;			// sN`yC(e)
		gfl::grp::g2d::LytPaneIndex	bound;		// oEfBOyC
	}PANE_DATA;

	// R[obNNX
	class CallBack {
	public:
		// J[\ړ̃R[obN֐
		virtual void CallBack_CursorMove( const PANE_DATA * cur_pane, u32 pane_index, u32 pos ) = 0;
		// J[\\ɂR[obN֐
		virtual void CallBack_CursorOff( const PANE_DATA * pane, u32 pane_index, u32 pos ) = 0;
		// Xg̍ڂ`悷R[obN֐
		virtual void CallBack_ListWrite( const PANE_DATA * pane, u32 pane_index, u32 pos ) = 0;
		// ւpR[obN֐
		virtual void CallBack_ItemChange( u32 pos1, u32 pos2 ) = 0;
	};
	static const u32 CALLBACK_PANE_NONE = 0xffffffff;		// R[obNֈnyC݂Ȃ


	typedef struct {
		gfl::heap::HeapBase * heap;				// q[v

		gfl::grp::g2d::LytWk * pLytWk;		// CAEg[N
		const PANE_DATA * paneList;				// yCf[^
		s32	paneListMax;									// yCf[^iPaneRow:PaneColj
    s32 paneRow;            //yC
    s32 paneCol;            //yCs

		s32	valMax;					// ڐ
    
    s32 listRow;        //\͈
    s32 listCol;        //\͈(paneCol == listCol̂͂)
		s32	listPosMax;			// J[\͈ 
		s32	listPos;				// J[\ʒu ( 0 ` listPosMax-1 ͈̔ )
		f32	listScroll;			// XN[ʒu ( 0 ` valMax-listPosMax-1 ͈̔ )

		f32	defPX;					// yC̃ftHgXW ( listPos = 0 ̈ʒũyCW )
		f32	defPY;					// yC̃ftHgYW ( listPos = 0 ̈ʒũyCW )
		f32	defSX;					// yCXTCY
		f32	defSY;					// yCYTCY

		s32	writeOffsetY;		// ̕\E

		u32 skipMode;				// y[WXLbv[h
		bool loopFlag;			// [vtO true = [v
		bool catchFlag;			// Lb`tO true = L

		u32	moveSE;					// J[\ړSE

		CallBack * cbFunc;	// R[obN֐
	}SETUP_PARAM;

	// y[WXLbv[h
	enum {
		PAGE_SKIP_NONE = 0,			// y[W薳
		PAGE_SKIP_LR_KEY,				// EL[Ńy[W
		PAGE_SKIP_LR_BUTTON,		// LR{^Ńy[W
	};

	// 
	enum {
		RET_NONE = 0,						// Ȃ

		RET_LIST_UP,						// փXN[
		RET_LIST_DOWN,					// փXN[
		RET_LIST_PAGE_UP,				// փy[W
		RET_LIST_PAGE_DOWN,			// փy[W

		RET_LIST_TOUCH,					// ^b`
		RET_LIST_AUTO_SCRILL,		// I[gXN[

		RET_LIST_SELECT,				// ڑI

		RET_LIST_CATCH,					// ڃLb`
	};

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		RXgN^
	 *
	 * @param		setup		ZbgAbvf[^
	 */
	//--------------------------------------------------------------------------------------------
	PaneList( const SETUP_PARAM * setup );

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		fXgN^
	 */
	//--------------------------------------------------------------------------------------------
	~PaneList(void);

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		J[\f[^擾
	 *
	 * @param		pos			J[\ʒui[ꏊ
	 * @param		scroll	XN[li[ꏊ
	 *
	 * @return	none
	 */
	//--------------------------------------------------------------------------------------------
	void GetCursorData( u32 * pos, f32 * scroll ) const;

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		ڈʒu擾 ( J[\ʒu{XN[l )
	 *
	 * @param		none
	 *
	 * @return	ڈʒu
	 */
	//--------------------------------------------------------------------------------------------
	u32 GetItemPos(void) const;

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		Abvf[g
	 *
	 * @param		none
	 *
	 * @return	
	 */
	//--------------------------------------------------------------------------------------------
	u32 Update(void);

	u32 GetPosPaneIndex( u32 pos );

private:
	u32 UpdateInput(void);
	u32 UpdateKeyScroll(void);
	u32 UpdateDrag(void);
	u32 UpdateAutoScroll(void);

	f32 ReviseFloat( f32 p );
	void MakeTouchArea(void);
	bool CheckTouchArea( f32 x, f32 y );

	void CreateScrollValue( u32 level, s32 mv );
	void DeleteScrollValue(void);

	void InitKeyScroll( int mv );

	gfl::ui::VectorDevice * GetKey(void);
	gfl::ui::VectorDevice * GetStick(void);
	gfl::ui::Button * GetButton(void);
	gfl::ui::TouchPanel * GetTouchPanel(void);

	void CB_CursorMove( u32 pos );
	void CB_CursorOff( u32 pos );
	void CB_ItemChange( u32 pos1, u32 pos2 );
	s32 GetPaneListPos( u32 index );


	gfl::math::VEC3 GetPanePos( gfl::grp::g2d::LytPaneIndex index ) const;
	void SetPanePos( gfl::grp::g2d::LytPaneIndex index, gfl::math::VEC3 & pos );
	void SetPaneVisible( gfl::grp::g2d::LytPaneIndex index, bool flg );
	bool GetPaneVisible( gfl::grp::g2d::LytPaneIndex index );

	void InitListPut(void);
	void ScrollListPut( f32 mv_y, int mv );
	void ScrollListPutKey( int mv );
	void ReviseInitScrollList(void);
	u32 MakePabeListRowTable( s32 * tbl, u32 def_index, f32 * def_y );
	void CursorMove( int val, bool is_se = true );
	u32 PageUp(void);
	u32 PageDown(void);

	u32 GetTouchPane(void);
	u32 GetDragPane(void);
	bool CheckDragContinue(void);
	bool CheckCatchItem(void);
	f32 GetBaseListPos(void);
	u32 GetTouchListPos( f32 y );
	void SetTouchPos( bool init );

	u32 GetDefaultPositionPane(void);

	f32 GetUpdateDragScroll(void);

	void InitKeyScrollChange( int mv );
	void SetItemChangePanePriority( u32 index, bool flg );

	void PlayCursorMoveSE(void);
  
  void Debug_ListInfo(void);
  
	u32 GetItemPosNow(void) const;

private:
	SETUP_PARAM	param;
	f32	touchAreaLX;
	f32	touchAreaRX;
	f32	touchAreaUY;
	f32	touchAreaDY;

	f32 listScrollMax;
	f32	tmpScroll;				// O֖߂߂ɎgpXN[l

	u8	trgCount;
	u8	trgSpeed;
	s8	scrollVec;
	s8	scrollCount;

	u32	updateSeq;
	bool	dragScrollFlag;

	app::tool::ScrollValue * pScrollValue;
	u16	nowTPX;
	u16	nowTPY;
	u16	oldTPX;
	u16	oldTPY;
	u16	startTPX;
	u16	startTPY;

	u32 curRow;  //curPane
	u32	baseRow;  //basePane
	f32	baseListPos;
	bool	reviseFlag;
	f32	reviseParam;
	f32	revisePY;
	u32	reviseRow;  //reviseIndex

	f32	autoScrollValue;
	u32	autoScrollStopPos;
	u32	catchCount;

};

GFL_NAMESPACE_END( list )
GFL_NAMESPACE_END( zukan )
GFL_NAMESPACE_END( app )
  
#endif // __APP_ZUKAN_PANELIST_H__
