//============================================================================================
/**
 * @file		app_tool_panelist.cpp
 * @brief		yCXg
 * @author	Hiroyuki Nakamura
 * @date		11.10.28
 */
//============================================================================================
#include "app/tool/app_tool_panelist.h"

#include "field/subscreen/pss/fieldmenu_pss_types.h"

GFL_NAMESPACE_BEGIN( app )
GFL_NAMESPACE_BEGIN( zukan )
GFL_NAMESPACE_BEGIN( list )

enum {
	PANELIST_SEQ_INPUT = 0,
	PANELIST_SEQ_KEY_SCROLL,
	PANELIST_SEQ_DRAG,
	PANELIST_SEQ_AUTO_SCROLL,
};

static const u32 DEFAULT_PANE_NONE = 0xffffffff;				// ƂȂyCȂ
static const u32 TOUCH_PANE_NONE = DEFAULT_PANE_NONE;		// ^b`WɃyCȂ

static const u32 AUTO_SCROLL_END = 0xffffffff;					// I[gXN[ʏ~

static const u32 SCROLL_FRAME_CHG_COUNT = 6;						// L[XN[t[؂ւJEg

//static const u32 ScrollFrame[] = { 5, 4, 2, 1 };
static const u32 ScrollFrame[] = { 8, 6, 3, 1 };		// L[XN[t[e[u


//--------------------------------------------------------------------------------------------
/**
 * @brief		RXgN^
 *
 * @param		setup		ZbgAbvf[^
 */
//--------------------------------------------------------------------------------------------
PaneList::PaneList( const SETUP_PARAM * setup ) :
	trgCount( 0 ),
	trgSpeed( 0 ),
	updateSeq( PANELIST_SEQ_INPUT ),
	pScrollValue( NULL )
{
  GFL_ASSERT( param.paneCol == param.listCol );
  GFL_ASSERT( static_cast<u32>(param.listScroll) % param.paneCol == 0 );

	param = *setup;

	if( param.valMax / param.listCol <= param.listRow ){
		listScrollMax = 0.0f;
		param.listPosMax = param.listRow;
	}else{
    //@todo
		listScrollMax = static_cast<f32>( param.valMax - param.listPosMax );
	}

	tmpScroll = param.listScroll;

	InitListPut();
	MakeTouchArea();
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		fXgN^
 */
//--------------------------------------------------------------------------------------------
PaneList::~PaneList(void)
{
	CB_CursorOff( param.listPos );
	DeleteScrollValue();
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		J[\f[^擾
 *
 * @param		pos			J[\ʒui[ꏊ
 * @param		scroll	XN[li[ꏊ
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void PaneList::GetCursorData( u32 * pos, f32 * scroll ) const
{
	if( pos != NULL ){
		*pos = param.listPos;
	}
	if( scroll != NULL ){
		*scroll = tmpScroll;
	}
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		ڈʒu擾 ( J[\ʒu{XN[l )
 *
 * @param		none
 *
 * @return	ڈʒu
 */
//--------------------------------------------------------------------------------------------
u32 PaneList::GetItemPos(void) const
{
	u32	pos;
	f32	scroll;
	GetCursorData( &pos, &scroll );
	return ( pos + static_cast<u32>(scroll) );
}
u32 PaneList::GetItemPosNow(void) const
{
	return ( param.listPos + static_cast<u32>(param.listScroll) );
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		Abvf[g
 *
 * @param		none
 *
 * @return	
 */
//--------------------------------------------------------------------------------------------
u32 PaneList::Update(void)
{
	u32	ret;
  
#if PM_DEBUG
  static u32 preUpdateSeq = 0;
  
  if( preUpdateSeq   != updateSeq )
  {
    GFL_PRINT( "SEQ CHANGE now%d pre%d\n", preUpdateSeq, updateSeq );
    preUpdateSeq  = updateSeq;
  }
#endif //PM_DEBUG

	switch( updateSeq ){
	case PANELIST_SEQ_INPUT:
		ret = UpdateInput();
		tmpScroll = param.listScroll;
		break;

	case PANELIST_SEQ_KEY_SCROLL:
		ret = UpdateKeyScroll();
		tmpScroll = param.listScroll;
		break;

	case PANELIST_SEQ_DRAG:
		ret = UpdateDrag();
		tmpScroll = GetUpdateDragScroll();
		break;

	case PANELIST_SEQ_AUTO_SCROLL:
		ret = UpdateAutoScroll();
		if( pScrollValue != NULL ){
			tmpScroll = pScrollValue->GetCurrentValue();
		}else{
			tmpScroll = param.listScroll;
		}
		break;
	}

	return ret;
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		Abvf[gF͑҂
 *
 * @param		none
 *
 * @return	
 */
//--------------------------------------------------------------------------------------------
u32 PaneList::UpdateInput(void)
{
	gfl::ui::VectorDevice * key = GetKey();

	// [v
	if( param.loopFlag == true ){
		if( key->IsTrigger( gfl::ui::DIR_UP ) ){
			if( param.listScroll == 0 && param.listPos == 0 ){
				CB_CursorOff( param.listPos );
				CB_ItemChange(
					static_cast<u32>(param.listScroll)+param.listPos,
					static_cast<u32>(listScrollMax)+param.listPosMax-1 );
				param.listPos = param.listPosMax - 1;
				param.listScroll = listScrollMax; //check
				InitListPut();
				PlayCursorMoveSE();
				return RET_LIST_UP;
			}
		}
		if( key->IsTrigger( gfl::ui::DIR_DOWN ) ){
			if( param.listScroll == listScrollMax && param.listPos == (param.listPosMax-1) ){
				CB_CursorOff( param.listPos );
				CB_ItemChange( static_cast<u32>(param.listScroll)+param.listPos, 0 );
				param.listPos = 0;
				param.listScroll = 0; //check
				InitListPut();
				PlayCursorMoveSE();
				return RET_LIST_DOWN;
			}
		}
	}

	// L[ł̏㉺
  if( key->IsRepeat( gfl::ui::DIR_UP ) ){
    int val = param.valMax - GetItemPosNow();  //cړ\
    val = val < param.paneCol ? val : param.paneCol;
    if( param.listScroll != 0.0f 
          && (param.listPos) / param.paneCol <= 0 ){
      InitKeyScroll( -1 );
      updateSeq = PANELIST_SEQ_KEY_SCROLL;
      return RET_LIST_UP;
    }
    if( param.listPos / param.paneCol > 0 ){
      CursorMove( -val );
      return RET_LIST_UP;
    }
    return RET_NONE;
  }
  if( key->IsRepeat( gfl::ui::DIR_DOWN ) ){
    int val = param.valMax - GetItemPosNow();  //cړ\
    val = val < param.paneCol ? val : param.paneCol;
    if( param.listScroll < listScrollMax 
          && (param.listPos + val) / param.paneCol >= param.listRow ){
      InitKeyScroll( 1 );
      updateSeq = PANELIST_SEQ_KEY_SCROLL;
      return RET_LIST_DOWN;
    }
    if( param.listPos / param.paneCol < param.listRow ){
      CursorMove( val );
      return RET_LIST_DOWN;
    }
    return RET_NONE;
  }

  //EL[͍sȂƂȂ
  if( param.paneCol > 1 )
  {
    if( key->IsRepeat( gfl::ui::DIR_LEFT ) ){
      int val = param.valMax - GetItemPosNow();  //cړ\
      val = val < param.paneCol ? val : param.paneCol;
      if( param.listScroll != 0.0f 
          && param.listPos <= 0 ){
        InitKeyScroll( -1 );
      
        param.listPos -= ( static_cast<f32>(param.paneCol) * scrollVec );

        updateSeq = PANELIST_SEQ_KEY_SCROLL;
        return RET_LIST_UP;
      }
      if( param.listPos > 0 ){
        CursorMove( -1 );
        return RET_LIST_UP;
      }
      return RET_NONE;
    }
    if( key->IsRepeat( gfl::ui::DIR_RIGHT ) ){
      int val = param.valMax - GetItemPosNow();  //cړ\
      val = val < param.paneCol ? val : param.paneCol;
      if( param.listScroll < listScrollMax 
          && param.listPos >= param.listPosMax ){
        InitKeyScroll( 1 );
      
        param.listPos -= ( static_cast<f32>(param.paneCol) * scrollVec );

        updateSeq = PANELIST_SEQ_KEY_SCROLL;
        return RET_LIST_DOWN;
      }
      if( param.listPos / param.paneCol < param.listRow ){
        CursorMove( 1 );
        return RET_LIST_DOWN;
      }
      return RET_NONE;
    }
  }

	// y[WFLRL[
	if( param.skipMode == PAGE_SKIP_LR_KEY ){
		if( key->IsRepeat( gfl::ui::DIR_LEFT ) ){
			return PageUp();
		}
		if( key->IsRepeat( gfl::ui::DIR_RIGHT ) ){
			return PageDown();
		}
	}
	// y[WFLR{^
	if( param.skipMode == PAGE_SKIP_LR_BUTTON ){
		gfl::ui::Button * button = GetButton();
		if( button->IsRepeat( gfl::ui::BUTTON_L ) ){
			return PageUp();
		}
		if( button->IsRepeat( gfl::ui::BUTTON_R ) ){
			return PageDown();
		}
	}

	// ^b`
	gfl::ui::TouchPanel * tp = GetTouchPanel();

	if( tp->IsTouchTrigger() == true ){
		u32 basePane = GetTouchPane();

		if( basePane != TOUCH_PANE_NONE ){
			CB_CursorOff( param.listPos );
			param.listPos = GetPaneListPos( basePane );
//			CB_CursorMove( param.listPos );
			baseListPos = GetBaseListPos();
			curRow = basePane / param.paneCol;
			SetTouchPos( true );
			reviseFlag = false;
			dragScrollFlag = false;
			startTPX = nowTPX;
			startTPY = nowTPY;
			catchCount = 0;
			updateSeq = PANELIST_SEQ_DRAG;
			return RET_LIST_TOUCH;
		}
	}

	return RET_NONE;
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		Abvf[gFL[XN[
 *
 * @param		none
 *
 * @return	
 */
//--------------------------------------------------------------------------------------------
u32 PaneList::UpdateKeyScroll(void)
{

	u32	ret;
	if( scrollVec < 0 ){
		ret = RET_LIST_UP;
	}else{
		ret = RET_LIST_DOWN;
	}

	if( scrollCount == ScrollFrame[trgSpeed] ){
		ReviseInitScrollList();
		param.listScroll += ( static_cast<f32>(param.paneCol) * scrollVec );
		CB_CursorMove( param.listPos );

		gfl::ui::VectorDevice * key = GetKey();

		if( scrollVec == -1 ){
			if( !key->IsHold(gfl::ui::DIR_UP) || param.listScroll == 0.0f ){
				updateSeq = PANELIST_SEQ_INPUT;
				return RET_NONE;
			}
		}else if( scrollVec == 1 ){
			if( !key->IsHold(gfl::ui::DIR_DOWN) || param.listScroll >= listScrollMax ){
				updateSeq = PANELIST_SEQ_INPUT;
				return RET_NONE;
			}
		}

		if( trgCount == SCROLL_FRAME_CHG_COUNT ){
			trgCount = 0;
			if( trgSpeed < (GFL_NELEMS(ScrollFrame)-1) ){
				trgSpeed++;
			}
		}else{
			trgCount++;
		}
    baseRow = GetDefaultPositionPane() / param.paneCol;
		baseListPos = param.listScroll;
		scrollCount = 0;
		return ret;
	}

	if( scrollCount == 0 ){
		CB_CursorOff( param.listPos );
	}
	ScrollListPutKey( scrollVec );
	scrollCount++;

	return ret;
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		Abvf[gFhbO
 *
 * @param		none
 *
 * @return	
 */
//--------------------------------------------------------------------------------------------
u32 PaneList::UpdateDrag(void)
{
	gfl::ui::TouchPanel * tp = GetTouchPanel();

	if( reviseFlag == false ){
		if( CheckDragContinue() == true ){
			SetTouchPos( false );
			f32	mv = static_cast<f32>( oldTPY - nowTPY );

			if( gfl::math::FAbs(startTPY-nowTPY) >= 3.0f ){
				dragScrollFlag = true;
			}

			// +
			if( mv > 0.0f ){
				gfl::math::VEC3 pos = GetPanePos( param.paneList[baseRow*param.paneCol+0].pict );
				// WEl␳
				if( ( pos.y + mv ) > param.defPY ){
          GFL_PRINT( "[+]WE\n" );
					mv = param.defPY - pos.y;
				}
				// XN[lE␳
				f32	ds = baseListPos - static_cast<f32>(param.listPos);
				f32	lp = static_cast<f32>(param.listPos)*param.defSY - ( param.defPY - ( pos.y + mv ) );
				if( ( ds*param.defSY+lp) > (listScrollMax*param.defSY) ){
          GFL_PRINT( "[+]XN[E\n" );
					mv = listScrollMax*param.defSY - ds*param.defSY - static_cast<f32>(param.listPos)*param.defSY + param.defPY - pos.y;
				}
				if( mv != 0.0f ){
					ScrollListPut( mv, 1 );
				}
				catchCount = 0;
			// -
			}else if( mv < 0.0f ){
				gfl::math::VEC3 pos = GetPanePos( param.paneList[baseRow*param.paneCol+0].pict );
				// WEl␳
				f32	dpy = param.defPY - param.defSY * static_cast<f32>( param.listPosMax-1 );
				if( ( pos.y + mv ) < dpy ){
          GFL_PRINT( "[-]WE\n" );
					mv = dpy - pos.y;
				}
				// XN[lE␳
				if( ( baseListPos*param.defSY-(param.defPY-(pos.y+mv)) ) < 0.0f ){
          GFL_PRINT( "[-]XN[E\n" );
					mv = -baseListPos*param.defSY + param.defPY - pos.y;
				}
				if( mv != 0.0f ){
					ScrollListPut( mv, -1 );
				}
				catchCount = 0;
			}else{
				if( param.catchFlag == true ){
					if( catchCount != 40 ){
						catchCount++;
					}
				}
			}

#if 1
			u32 tmp = GetDragPane();
			if( tmp != TOUCH_PANE_NONE ){
				curRow = tmp / param.paneCol;
			}
#else
		/*	ؗpɎc܂B
				^b`͈͓ɃyC͂Ȃ̂ɁAȂȂB
				GetHitPane肢ƓĂȂH	*/
//			u32	tmp = GetTouchPane();
			u32 tmp = GetDragPane();
			if( tmp != TOUCH_PANE_NONE ){
			  curRow = tmp / param.paneCol;
			}else{
				u16	x, y;
				tp->GetXY( &x, &y );
				GFL_PRINT( "none: %d, %d ( %d, %d )\n", x, y, (s16)x-160, 120-(s16)y );
				for( u32 i=0; i<param.paneListMax; i++ ){
					gfl::math::VEC3	pos = GetPanePos( param.paneList[i].bound );
					GFL_PRINT( " [%d] (%f, %f), u[%f] d[%f] l[%f] r[%f]\n", i, pos.x, pos.y, pos.y+14.0f, pos.y-15.0f, pos.x-75.0f, pos.x+74.0f );
				}
				GFL_ASSERT( tmp != TOUCH_PANE_NONE );
			}
#endif

		}else{
			// I[gXN[`FbN
			u32	as_dot = gfl::math::Abs( nowTPY - oldTPY );
			if( as_dot >= 3 && as_dot < 33 && tp->IsTouch() == false ){
				s32	mv;
				// -
				if( nowTPY > oldTPY ){
					mv = -1;
				// +
				}else if( nowTPY < oldTPY ){
					mv = 1;
				}
				gfl::math::VEC3 pos = GetPanePos( param.paneList[baseRow*param.paneCol+0].pict );
				f32	ry = param.defPY - static_cast<f32>(static_cast<s32>((param.defPY-pos.y)/param.defSY)) * param.defSY;
				if( pos.y != ry ){
					if( mv > 0 ){
						ScrollListPut( gfl::math::FAbs(ry-pos.y), 1 );
					}else{
						ScrollListPut( -gfl::math::FAbs(ry-pos.y), -1 );
					}
					ReviseInitScrollList();
					pos = GetPanePos( param.paneList[baseRow*param.paneCol+0].pict );
				}
        //@todo
				param.listScroll += ( static_cast<f32>(param.listPos) - (param.defPY-pos.y) / param.defSY ); //check
				s32	lp = GetPaneListPos( curRow * param.paneCol );
				if( lp < 0 ){
					param.listPos = 0;
				}else if( lp >= param.listPosMax ){
					param.listPos = param.listPosMax - 1;
				}else{
					param.listPos = lp;
				}
				baseRow = curRow;
				baseListPos = static_cast<f32>( static_cast<u32>(param.listScroll) ) + static_cast<f32>(param.listPos);
				CreateScrollValue( (as_dot-3)/5, mv );
				autoScrollValue = 0;
				autoScrollStopPos = AUTO_SCROLL_END;
				updateSeq = PANELIST_SEQ_AUTO_SCROLL;
				return RET_LIST_TOUCH;
			}

			// I
			gfl::math::VEC3 pos = GetPanePos( param.paneList[baseRow*param.paneCol].pict );
			reviseRow = baseRow;
			revisePY = param.defPY - static_cast<f32>(static_cast<s32>((param.defPY-pos.y)/param.defSY)) * param.defSY;
			f32	abs = gfl::math::FAbs( revisePY - pos.y );

			if( abs == 0.0f ){
        //@todo
				param.listScroll += ( static_cast<f32>(param.listPos) - (param.defPY-pos.y) / param.defSY ); //check
				param.listPos = GetPaneListPos( curRow * param.paneCol );
				ReviseInitScrollList();
				CB_CursorMove( param.listPos );
				updateSeq = PANELIST_SEQ_INPUT;
				if( dragScrollFlag == false && tp->IsTouch() == false ){
					return RET_LIST_SELECT;
				}else{
					if( CheckCatchItem() == true && tp->IsTouch() == true ){
						return RET_LIST_CATCH;
					}
					return RET_NONE;
				}
			}else if( abs < (param.defSY/2.0f) ){
				reviseParam = param.defSY / 8;
			}else{
				reviseParam = -param.defSY / 8;
				revisePY -= param.defSY;
			}
			reviseFlag  = true;
		}
	}else{
		gfl::math::VEC3 pos = GetPanePos( param.paneList[reviseRow*param.paneCol+0].pict );
		bool	end = false;
		if( ( reviseParam < 0.0f && (pos.y+reviseParam) <= revisePY ) ||
				( reviseParam > 0.0f && (pos.y+reviseParam) >= revisePY ) ){
			reviseParam = revisePY - pos.y;
			end = true;
		}
		if( reviseParam > 0.0f ){
			ScrollListPut( reviseParam, 1 );
		}else if( reviseParam < 0.0f ){
			ScrollListPut( reviseParam, -1 );
		}

		if( end == true ){
			pos = GetPanePos( param.paneList[reviseRow*param.paneCol+0].pict );
      //@todo
			param.listScroll += ( static_cast<f32>(param.listPos) - (param.defPY-pos.y) / param.defSY ); //check
			param.listPos = GetPaneListPos( curRow * param.paneCol );
			ReviseInitScrollList();
			CB_CursorMove( param.listPos );
			updateSeq = PANELIST_SEQ_INPUT;
			if( dragScrollFlag == false && tp->IsTouch() == false ){
				return RET_LIST_SELECT;
			}else{
				if( CheckCatchItem() == true && tp->IsTouch() == true ){
					return RET_LIST_CATCH;
				}
				return RET_NONE;
			}
		}
	}

	return RET_LIST_TOUCH;
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		Abvf[gFI[gXN[
 *
 * @param		none
 *
 * @return	
 */
//--------------------------------------------------------------------------------------------
u32 PaneList::UpdateAutoScroll(void)
{
	gfl::ui::TouchPanel * tp = GetTouchPanel();

	f32	val = pScrollValue->GetCurrentValue();

	pScrollValue->UpdateScroll();

	// ~`FbN
	if( tp->IsTouchTrigger() == true ){
		u16	x, y;
		tp->GetXY( &x, &y );

		f32	tpx = static_cast<f32>( x-160 );
		f32	tpy = static_cast<f32>( 120-y );

		if( CheckTouchArea( tpx, tpy ) == true ){
			pScrollValue->StopRequest( 1.0f );
			autoScrollStopPos = GetTouchListPos( tpy );
		}
	}

	f32	scroll = pScrollValue->GetCurrentValue();
	val = ( scroll - val ) * param.defSY;

	autoScrollValue += val;

#if 0 //@todo basepane listScroll
	if( val > 0.0f ){
		if( autoScrollValue >= param.defSY ){
			autoScrollValue -= param.defSY;
			if( basePane == (param.paneListMax-1) ){
				basePane = 0;
			}else{
				basePane += 1;
			}
			baseListPos += 1.0f;
		}
		ScrollListPut( val, 1 );
		param.listScroll = scroll;
//		return RET_LIST_DOWN;
		return RET_LIST_AUTO_SCRILL;
	}else if( val < 0.0f ){
		if( autoScrollValue <= param.defSY ){
			autoScrollValue += param.defSY;
			if( basePane == 0 ){
				basePane = param.paneListMax - 1;
			}else{
				basePane -= 1;
			}
			baseListPos -= 1.0f;
		}
		ScrollListPut( val, -1 );
		param.listScroll = scroll;
//		return RET_LIST_UP;
		return RET_LIST_AUTO_SCRILL;
	}

	if( pScrollValue->IsScroll() == false ){
		param.listScroll = pScrollValue->GetCurrentValue();
		DeleteScrollValue();
		ReviseInitScrollList();

		u32	tp_pane = GetTouchPane();
		// hbO
		if( tp_pane != TOUCH_PANE_NONE ){
			basePane = tp_pane;
			param.listPos = GetPaneListPos( tp_pane );
			baseListPos = GetBaseListPos();
			curPane = basePane;
			SetTouchPos( true );
			reviseFlag = false;
      GFL_PRINT( "scroll = %f, pos = %d\n", param.listScroll, param.listPos );
			dragScrollFlag = true;
			updateSeq = PANELIST_SEQ_DRAG;
			catchCount = 0;
			return RET_LIST_TOUCH;
		}else{
			if( autoScrollStopPos != AUTO_SCROLL_END ){
				param.listPos = autoScrollStopPos;
			}
			CB_CursorMove( param.listPos );
      GFL_PRINT( "scroll = %f, pos = %d\n", param.listScroll, param.listPos );
			updateSeq = PANELIST_SEQ_INPUT;
			return RET_NONE;
		}
	}
#endif

/*
	if( val > 0.0f ){
		return RET_LIST_DOWN;
	}else if( val < 0.0f ){
		return RET_LIST_UP;
	}
*/

	return RET_LIST_AUTO_SCRILL;
}


//--------------------------------------------------------------------------------------------
/**
 * @brief		R[obNFJ[\ړ
 *
 * @param		pos		J[\ʒu
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void PaneList::CB_CursorMove( u32 pos )
{
	u32	pane;

	if( param.valMax == 0 ){
		pane = CALLBACK_PANE_NONE;
	}else{
		pane = GetPosPaneIndex( pos );
	}

	param.cbFunc->CallBack_CursorMove(
		param.paneList, pane, GetItemPosNow() );
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		R[obNFJ[\\
 *
 * @param		pos		J[\ʒu
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void PaneList::CB_CursorOff( u32 pos )
{
	u32	pane;

	if( param.valMax == 0 ){
		pane = CALLBACK_PANE_NONE;
	}else{
		pane = GetPosPaneIndex( pos );
	}

	param.cbFunc->CallBack_CursorOff(
		param.paneList, pane, GetItemPosNow() );
}

void PaneList::CB_ItemChange( u32 pos1, u32 pos2 )
{
}


//--------------------------------------------------------------------------------------------
/**
 * @brief		\L[擾
 *
 * @param		none
 *
 * @return	\L[
 */
//--------------------------------------------------------------------------------------------
gfl::ui::VectorDevice * PaneList::GetKey(void)
{
	gamesystem::GameManager * pgm = GFL_SINGLETON_INSTANCE( gamesystem::GameManager );
	gfl::ui::DeviceManager * dvm = pgm->GetUiDeviceManager();
	return dvm->GetCrossKey( gfl::ui::CTR_DeviceManager::CROSSKEY_STANDARD );
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		AiOpbh擾
 *
 * @param		none
 *
 * @return	AiOpbh
 */
//--------------------------------------------------------------------------------------------
gfl::ui::VectorDevice * PaneList::GetStick(void)
{
	gamesystem::GameManager * pgm = GFL_SINGLETON_INSTANCE( gamesystem::GameManager );
	gfl::ui::DeviceManager * dvm = pgm->GetUiDeviceManager();
	return dvm->GetStick( gfl::ui::CTR_DeviceManager::STICK_STANDARD );
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		{^擾
 *
 * @param		none
 *
 * @return	{^
 */
//--------------------------------------------------------------------------------------------
gfl::ui::Button * PaneList::GetButton(void)
{
	gamesystem::GameManager * pgm = GFL_SINGLETON_INSTANCE( gamesystem::GameManager );
	gfl::ui::DeviceManager * dvm = pgm->GetUiDeviceManager();
	return dvm->GetButton( gfl::ui::CTR_DeviceManager::BUTTON_STANDARD );
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		^b`pl擾
 *
 * @param		none
 *
 * @return	^b`pl
 */
//--------------------------------------------------------------------------------------------
gfl::ui::TouchPanel * PaneList::GetTouchPanel(void)
{
	gamesystem::GameManager * pgm = GFL_SINGLETON_INSTANCE( gamesystem::GameManager );
	gfl::ui::DeviceManager * dvm = pgm->GetUiDeviceManager();
	return dvm->GetTouchPanel( gfl::ui::CTR_DeviceManager::TOUCHPANEL_STANDARD );
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		yCW擾
 *
 * @param		index		yC̃CfbNX
 *
 * @return	W
 */
//--------------------------------------------------------------------------------------------
gfl::math::VEC3 PaneList::GetPanePos( gfl::grp::g2d::LytPaneIndex index ) const
{
  gfl::grp::g2d::LytPane * basePane = param.pLytWk->GetPane( index );
	gfl::grp::g2d::LytPane * rootPane = param.pLytWk->GetLayoutCore()->GetRootPane();
	gfl::math::VEC3	pos = basePane->GetTranslate();

	while( 1 ){
	  gfl::grp::g2d::LytPane * parentPane = basePane->GetParent();
		// eȂ or e[gyC
		if( parentPane == NULL || parentPane == rootPane ){
      
			break;
		}
		pos += parentPane->GetTranslate();
		basePane = parentPane;
	}

	return pos;
/*
  gfl::grp::g2d::LytPane * basePane;
  gfl::grp::g2d::LytPane * parentPane;

	basePane   = param.pLytWk->GetPane( index );
	parentPane = basePane->GetParent();
	// eꍇi[gyC͐eƂ݂ȂȂj
	if( !( parentPane == NULL || parentPane == param.pLytWk->GetLayoutCore()->GetRootPane() ) ){
		return ( basePane->GetTranslate() + parentPane->GetTranslate() );
	}
	return basePane->GetTranslate();
*/
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		yCWݒ
 *
 * @param		index		yC̃CfbNX
 * @param		pos			yC̍W
 *
 * @return	nonw
 */
//--------------------------------------------------------------------------------------------
void PaneList::SetPanePos( gfl::grp::g2d::LytPaneIndex index, gfl::math::VEC3 & pos )
{
	gfl::grp::g2d::LytPane * pane = param.pLytWk->GetPane( index );
	if( pane ){
		pane->SetTranslate( pos );
	}
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		yC\؂ւ
 *
 * @param		index		yC̃CfbNX
 * @param		flg			true = \, false = \
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void PaneList::SetPaneVisible( gfl::grp::g2d::LytPaneIndex index, bool flg )
{
	gfl::grp::g2d::LytPane * pane = param.pLytWk->GetPane( index );
	if( pane ){
		pane->SetVisible( flg );
	}
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		yC\Ԏ擾
 *
 * @param		index		yC̃CfbNX
 *
 * @retval	"true = \"
 * @retval	"false = ȊO"
 */
//--------------------------------------------------------------------------------------------
bool PaneList::GetPaneVisible( gfl::grp::g2d::LytPaneIndex index )
{
	gfl::grp::g2d::LytPane * pane = param.pLytWk->GetPane( index );
	if( pane ){
		return pane->IsVisible();
	}
	return false;
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		^b`͈̓GA쐬
 *
 * @param		none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void PaneList::MakeTouchArea(void)
{
	gfl::math::VEC3	pos = PaneList::GetPanePos( param.paneList[0].pict );
	touchAreaLX = pos.x - param.defSX/2.0f;
	touchAreaRX = touchAreaLX + param.defSX * static_cast<f32>(param.listRow);
	touchAreaUY = param.defPY + param.defSY/2.0f;
	touchAreaDY = touchAreaUY - param.defSY * static_cast<f32>(param.listCol);

  GFL_PRINT( "area: (u, d, l, r) = (%f, %f, %f, %f)\n", touchAreaUY, touchAreaDY, touchAreaLX, touchAreaRX );
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		^b`͈̓GA`FbN
 *
 * @param		x		XW
 * @param		y		YW
 *
 * @retval	"true = ͈͓"
 * @retval	"false = ͈͊O"
 */
//--------------------------------------------------------------------------------------------
bool PaneList::CheckTouchArea( f32 x, f32 y )
{
	if( x >= touchAreaLX && x < touchAreaRX &&
			y > touchAreaDY && y <= touchAreaUY ){
		return true;
	}
	return false;
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		^b`WZbg
 *
 * @param		init	 = true
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void PaneList::SetTouchPos( bool init )
{
	gfl::ui::TouchPanel * tp = GetTouchPanel();
	u16	x, y;

	tp->GetXY( &x, &y );

	if( init == true ){
		oldTPX = x;
		oldTPY = y;
		nowTPX = x;
		nowTPY = y;
	}else{
		oldTPX = nowTPX;
		oldTPY = nowTPY;
		nowTPX = x;
		nowTPY = y;
	}
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		ScrollValue쐬
 *
 * @param		level		xx
 * @param		mv			ړ
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void PaneList::CreateScrollValue( u32 level, s32 mv )
{
	app::tool::ScrollValue::Settings	dat;

	dat.init_value = param.listScroll;	// l[value]
	dat.min_value  = 0.0f;							// ŏl[value]
	dat.max_value  = listScrollMax;			// ől[value]

	const f32 decel[PSS_AUTO_SCROLL_DECEL_MAX] = {
		// ő呬x	0.01 mv = 50
		//					0.02 mv = 25
		//					0.03 mv = 16
		//					0.04 mv = 12
		//					0.05 mv = 10
		//					0.06 mv = 8
		//					0.07 mv = 7
		//					0.08 mv = 6
//		0.01f, 0.014f, 0.025f, 0.04f, 0.06f, 0.08f,
		0.01f, 0.02f, 0.03f, 0.04f, 0.06f, 0.08f,
	};
	dat.default_decel = decel[level];				// x[value/frame*frame]

//	dat.default_decel = 0.08f;
/*
	dat.overrun_enable  = true;					    // El˔jǂ
	dat.overrun_frame = 20;							    // El˔j̋XN[̃t[
*/
	dat.overrun_enable  = false;					  // El˔jǂ
	dat.overrun_frame = 0;							    // El˔j̋XN[̃t[

	pScrollValue = GFL_NEW( param.heap ) app::tool::ScrollValue( dat );

	if( mv < 0 ){
		pScrollValue->StartScroll( -0.8f, 1.0f );
	}else{
		pScrollValue->StartScroll( 0.8f, 1.0f );
	}
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		ScrollValue폜
 *
 * @param		none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void PaneList::DeleteScrollValue(void)
{
	if( pScrollValue != NULL ){
		GFL_DELETE	pScrollValue;
		pScrollValue = NULL;
	}
}


//--------------------------------------------------------------------------------------------
/**
 * @brief		ftHgʒu(J[\0̈ʒu)̃yC̃CfbNX擾
 *
 * @param		none
 *
 * @return	yC̃CfbNX
 */
//--------------------------------------------------------------------------------------------
u32 PaneList::GetDefaultPositionPane(void)
{
	return GetPosPaneIndex( 0 );
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		XgʒũyC擾
 *
 * @param		pos		Xgʒu
 *
 * @return	yC̃CfbNX
 */
//--------------------------------------------------------------------------------------------
u32 PaneList::GetPosPaneIndex( u32 pos )
{
  u32 r = pos / param.listCol;
  u32 c = pos % param.listCol;

	f32	y = param.defPY - param.defSY * static_cast<f32>( r );
  f32 x = param.defPX + param.defSX * static_cast<f32>( c );

	for( u32 i=0; i<param.paneListMax; ++i ){
		gfl::math::VEC3	p1 = GetPanePos( param.paneList[i].pict );
		if( p1.y == y && p1.x == x ){
			return i;
		}
	}
	GFL_ASSERT_MSG( 0, "r%d c%d x%f y%f\n", r,c, x, y );
	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		yC烊Xgʒu擾
 *
 * @param		index		yC̃CfbNX
 *
 * @return	Xgʒu
 */
//--------------------------------------------------------------------------------------------
s32 PaneList::GetPaneListPos( u32 index )
{
	gfl::math::VEC3	pos = GetPanePos( param.paneList[index].pict );
	return static_cast<u32>( (param.defPY-pos.y)/param.defSY );
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		^b`̃yC擾
 *
 * @param		none
 *
 * @return	yC̃CfbNX
 */
//--------------------------------------------------------------------------------------------
u32 PaneList::GetTouchPane(void)
{
	gfl::ui::TouchPanel * tp = GetTouchPanel();

	if( tp->IsTouch() == true ){
		u16	x, y;
		tp->GetXY( &x, &y );

		for( u32 i=0; i<param.paneListMax; i++ ){
			if( GetPaneVisible( param.paneList[i].pict ) == false ){
				continue;
			}
			gfl::math::VEC3	pos = GetPanePos( param.paneList[i].pict );
			if( CheckTouchArea( pos.x, pos.y ) == false ){
				continue;
			}
			if( param.pLytWk->GetHitPane( x, y, param.paneList[i].bound ) == true ){
				return i;
			}
		}
	}
	return TOUCH_PANE_NONE;
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		hbÕyC擾
 *
 * @param		none
 *
 * @return	yC̃CfbNX
 *
 *	GetTouchPane()gAGetHitPane܂Ȃ̂ŁAƎ`FbN܂
 */
//--------------------------------------------------------------------------------------------
u32 PaneList::GetDragPane(void)
{
	gfl::ui::TouchPanel * tp = GetTouchPanel();

	u16	tpx, tpy;
	tp->GetXY( &tpx, &tpy );

	f32	x = static_cast<f32>( tpx ) - 160.0f;
	f32	y = 120.0f - static_cast<f32>( tpy );

	f32	half_sx = param.defSX / 2;
	f32	half_sy = param.defSY / 2;

	for( u32 i=0; i<param.paneListMax; i++ ){
		if( GetPaneVisible( param.paneList[i].pict ) == false ){
			continue;
		}
		gfl::math::VEC3	pos = GetPanePos( param.paneList[i].bound );
		if( CheckTouchArea( pos.x, pos.y ) == false ){
			continue;
		}
		if( x >= (pos.x-half_sx) && x < (pos.x+half_sx) &&
				y >= (pos.y-half_sy) && y < (pos.y+half_sy) ){
			return i;
		}
	}
	return TOUCH_PANE_NONE;
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		^b`W̃J[\ʒu擾
 *
 * @param		y		YW
 *
 * @return	J[\ʒu
 */
//--------------------------------------------------------------------------------------------
u32 PaneList::GetTouchListPos( f32 y )
{
	f32	uy = param.defPY + param.defSY / 2.0f;
	f32	dy = param.defPY - param.defSY / 2.0f;
	for( u32 i=0; i<param.listPosMax; i++ ){
		if( y <= uy && y > dy ){
			return i;
		}
		uy = dy;
		dy -= param.defSY;
	}
	GFL_ASSERT( 0 );
	return 0;
}


//--------------------------------------------------------------------------------------------
/**
 * @brief		Xgzu
 *
 * @param		none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void PaneList::InitListPut(void)
{
	gfl::math::VEC3	pos = GetPanePos( param.paneList[0].pict );
	s32	lp;

	lp = static_cast<u32>( param.listScroll ) + param.writeOffsetY * param.paneCol;
	pos.y = param.defPY - param.defSY * param.writeOffsetY;
  
  for( u32 r=0; r<param.paneRow; ++r )
  {
    pos.x = param.defPX;
    for( u32 c=0; c<param.paneCol; ++c )
    {
      u32 i = r*param.paneCol+c;
      SetPanePos( param.paneList[i].pict, pos );
      if( lp >= 0 && lp < param.valMax ){
        SetPaneVisible( param.paneList[i].pict, true );
        param.cbFunc->CallBack_ListWrite( param.paneList, i, lp );
      }else{
        SetPaneVisible( param.paneList[i].pict, false );
      }
      pos.x += param.defSX;
      lp++;
    }
    pos.y -= param.defSY;
  }
  
	CB_CursorMove( param.listPos );
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		XgXN[
 *
 * @param		mv_y		ړl
 * @param		mv			ړ
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void PaneList::ScrollListPut( f32 mv_y, int mv )
{
	s32	tbl[param.paneListMax];
	f32	ry;
	bool	se = false;

	MakePabeListRowTable( tbl, baseRow, &ry );

	f32	def_y   = param.defPY - param.defSY * param.writeOffsetY;
	f32	half_sy = param.defSY / 2.0f;
	f32	uy = def_y + half_sy;
	f32	dy = def_y - param.defSY * ( param.paneRow + param.writeOffsetY ) - half_sy;
  
  gfl::math::VEC3	drag_pos = GetPanePos( param.paneList[ baseRow*param.paneCol+0 ].pict );
  drag_pos.y += mv_y;
  for( u32 c=0; c<param.paneCol; ++c)
  {
    u32 i = baseRow*param.paneCol+c;
    gfl::math::VEC3	p1 = GetPanePos( param.paneList[ i ].pict );
    p1.y  = drag_pos.y;
	  SetPanePos( param.paneList[i].pict, p1 );
  }

  for( u32 r=0; r<param.paneRow; ++r){
    for(u32 c=0; c<param.paneCol; ++c ) {
      u32 i = r*param.paneCol+c;
      if( tbl[i] /param.paneCol != baseRow ){
        gfl::math::VEC3	pos = GetPanePos( param.paneList[ tbl[i] ].pict );
        pos.y = drag_pos.y + ry;
        if( mv < 0 ){
          if( pos.y <= dy ){
            pos.y += ( param.defSY * static_cast<f32>(param.paneRow) );
            f32	sy = ReviseFloat( drag_pos.y - pos.y );
            s32	list_pos = baseListPos + static_cast<s32>( sy / param.defSY ) * param.paneCol + c;
            if( list_pos < 0 ){
              SetPaneVisible( param.paneList[ tbl[i] ].pict, false );
            }else{
              SetPaneVisible( param.paneList[ tbl[i] ].pict, true );
              param.cbFunc->CallBack_ListWrite( param.paneList, tbl[i], list_pos );
              // GFL_PRINT( "ds = %f, dpy = %f, py = %f, list_pos = %d(%f), sy = %f\n", baseListPos, drag_pos.y, pos.y, list_pos, baseListPos + sy / param.defSY, sy );
            }
					se = true;
          }
        }else{
          if( pos.y > uy ){
            pos.y -= ( param.defSY * static_cast<f32>(param.paneRow) );
            f32	sy = ReviseFloat( drag_pos.y - pos.y );
            s32	list_pos = baseListPos + static_cast<s32>( sy / param.defSY ) *param.paneCol + c;
            if( list_pos >= param.valMax ){
              SetPaneVisible( param.paneList[ tbl[i] ].pict, false );
            }else{
              SetPaneVisible( param.paneList[ tbl[i] ].pict, true );
              param.cbFunc->CallBack_ListWrite( param.paneList, tbl[i], list_pos );
            }
            // GFL_PRINT( "ds = %f, dpy = %f, py = %f, list_pos = %d(%f), sy = %f\n", baseListPos, drag_pos.y, pos.y, list_pos, baseListPos + sy / param.defSY, sy );
            se = true;
          }
        }
        SetPanePos( param.paneList[ tbl[i] ].pict, pos );
      }
    }
    ry -= param.defSY;
  }

	if( se == true ){
		PlayCursorMoveSE();
	}
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		L[ł̃XgXN[
 *
 * @param		mv			ړ
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void PaneList::ScrollListPutKey( int mv )
{
	ScrollListPut( param.defSY / ScrollFrame[trgSpeed] * mv, mv );
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		_␳
 *
 * @param		p		␳l
 *
 * @return	␳l
 *
 * @li	0.9999ȏJグA0.0001j
 */
//--------------------------------------------------------------------------------------------
f32 PaneList::ReviseFloat( f32 p )
{
	f32	pa = static_cast<f32>( static_cast<s32>(p) );
	f32	pb = p - pa;
	if( pb >= 0.9999f ){
		if( pa > 0.0f ){
			return ( pa + 1.0f );
		}else{
			return ( pa - 1.0f );
		}
	}else if( pb < 0.0001f ){
		return pa;
	}
	return p;
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		XN[̃Xgʒu␳
 *
 * @param		none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void PaneList::ReviseInitScrollList(void)
{
	s32	tbl[param.paneListMax];
	u32 def_row;
	f32	def_y;

	def_row = MakePabeListRowTable( tbl, DEFAULT_PANE_NONE, &def_y );

  for( u32 r=0; r<param.paneRow;++r){
    for(u32 c=0; c<param.paneCol;++c){
      u32 i = r*param.paneCol+c;
      gfl::math::VEC3	pos = GetPanePos( param.paneList[ tbl[i] ].pict );
      if( tbl[i] / param.paneCol == def_row ){
        pos.y = param.defPY;
      }else{
        pos.y = param.defPY + def_y;
      }
      SetPanePos( param.paneList[ tbl[i] ].pict, pos );
      
      // GFL_PRINT( "[%d] %f %f def%f r%ddr%d\n", tbl[i], pos.x, pos.y, def_y, r, def_row );
    }
    def_y -= param.defSY;
	}
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		XgyCYW̃e[u쐬
 *
 * @param		tbl					̂݃e[u쐬ꏊ
 * @param		def_index		ƂȂyC̃CfbNX
 * @param		def_y				zuJnYW쐬ꏊ
 *
 * @return	ƂȂyC̃CfbNX
 *
 * @li	"def_index = DEFAULT_PANE_NONE"̏ꍇAJ[\0̈ʒuƂ
 */
//--------------------------------------------------------------------------------------------
u32 PaneList::MakePabeListRowTable( s32 * tbl, u32 def_index, f32 * def_y )
{
	// e[u
  u32 cnt = 0;
	for( u32 i=0; i<param.paneListMax; i++ ){
		tbl[i] = i;
	}

	// YW̑傫ɕёւ
	for( u32 i=0; i<param.paneListMax-1; i+=param.paneCol ){
		gfl::math::VEC3	p1 = GetPanePos( param.paneList[ tbl[i] ].pict );
		for( u32 j=i+param.paneCol; j<param.paneListMax; j+=param.paneCol ){
			gfl::math::VEC3	p2 = GetPanePos( param.paneList[ tbl[j] ].pict );
			if( p1.y < p2.y ){
        s32 tmp[ param.paneCol ];
        for( u32 c = 0; c< param.paneCol; ++c) {
          tmp[c]    = tbl[i+c];
          tbl[i+c]  = tbl[j+c];
          tbl[j+c]  = tmp[c];
        }
				p1 = p2;
			}
		}
	}

	// ʒuݒ
	// yCȂ̏ꍇ́AJ[\ÖʒuƂ
	if( def_index == DEFAULT_PANE_NONE ){
		gfl::math::VEC3	p1 = GetPanePos( param.paneList[0].pict );
		def_index = 0;
		for( u32 i=1; i<param.paneListMax; i++ ){
			gfl::math::VEC3	p2 = GetPanePos( param.paneList[i].pict );
			if( gfl::math::FAbs(p1.y-param.defPY) > gfl::math::FAbs(p2.y-param.defPY) ){
				def_index = i / param.paneCol;
				p1 = p2;
			}
		}
	}
	*def_y = 0.0f;
	for( u32 r=0; r<param.paneRow; ++r ){
    for( u32 c=0; c<param.paneCol; ++c ){
      u32 i = r*param.paneCol+c;
      if( tbl[i] / param.paneCol == def_index ){
        goto LOOP_EXIT;
      }
    }
    *def_y += param.defSY;
	}
LOOP_EXIT:

	return def_index;
}


//--------------------------------------------------------------------------------------------
/**
 * @brief		L[XN[ݒ
 *
 * @param		mv		ړ
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void PaneList::InitKeyScroll( int mv )
{
  scrollVec = mv;
  scrollCount = 0;
  trgCount = 0;
  trgSpeed = 0;
  
  baseRow = GetDefaultPositionPane() / param.paneCol;
  baseListPos = param.listScroll;
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		J[\ړ
 *
 * @param		val		ړl
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void PaneList::CursorMove( int val, bool is_se )
{
	// ʏ
  CB_CursorOff( param.listPos );
  param.listPos += val;
  CB_CursorMove( param.listPos );
  
  if( val != 0 )
  {
	  PlayCursorMoveSE();
  }
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		y[WF
 *
 * @param		none
 *
 * @return	
 */
//--------------------------------------------------------------------------------------------
u32 PaneList::PageUp(void)
{
	if( param.listScroll != 0 ){
		CB_CursorOff( param.listPos );
		f32	tmp = param.listScroll;
		if( param.listScroll < param.listPosMax ){
			param.listScroll = 0;
		}else{
			param.listScroll -= param.listPosMax;
		}
		CB_ItemChange(
			static_cast<u32>(tmp)+param.listPos,
			static_cast<u32>(param.listScroll)+param.listPos );
		InitListPut();
		PlayCursorMoveSE();
		return RET_LIST_PAGE_UP;
	}else if( param.listPos != 0 ){
		CB_CursorOff( param.listPos );
		CB_ItemChange(
			static_cast<u32>(param.listScroll)+param.listPos, static_cast<u32>(param.listScroll) );
		param.listPos = 0;
		InitListPut();
		PlayCursorMoveSE();
		return RET_LIST_PAGE_UP;
	}
	return RET_NONE;
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		y[WF
 *
 * @param		none
 *
 * @return	
 */
//--------------------------------------------------------------------------------------------
u32 PaneList::PageDown(void)
{
	if( param.listScroll != listScrollMax ){
		CB_CursorOff( param.listPos );
		f32	tmp = param.listScroll;
		if( param.listScroll > (listScrollMax-(param.listPosMax-1)) ){
			param.listScroll = listScrollMax;
		}else{
			param.listScroll += param.listPosMax;
		}
		CB_ItemChange(
			static_cast<u32>(tmp)+param.listPos,
			static_cast<u32>(param.listScroll)+param.listPos );
		InitListPut();
		PlayCursorMoveSE();
		return RET_LIST_PAGE_DOWN;
	}else if( param.listPos != (param.listPosMax-1) ){
		CB_CursorOff( param.listPos );
		u32	tmp = param.listPos;
		param.listPos = param.listPosMax - 1;
		CB_ItemChange(
			static_cast<u32>(param.listScroll)+tmp, static_cast<u32>(param.listScroll)+param.listPos );
		InitListPut();
		PlayCursorMoveSE();
		return RET_LIST_PAGE_DOWN;
	}
	return RET_NONE;
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		hbOp`FbN
 *
 * @param		none
 *
 * @retval	"true = hbO"
 * @retval	"false = ȊO"
 */
//--------------------------------------------------------------------------------------------
bool PaneList::CheckDragContinue(void)
{
	if( CheckCatchItem() == true ){
		return false;
	}

	gfl::ui::TouchPanel * tp = GetTouchPanel();

	if( tp->IsTouch() == true ){
		u16	x, y;
		tp->GetXY( &x, &y );

		f32	tpx = static_cast<f32>( x-160 );
		f32	tpy = static_cast<f32>( 120-y );

		return CheckTouchArea( tpx, tpy );
	}

	return false;
}

bool PaneList::CheckCatchItem(void)
{
	if( param.catchFlag == true && catchCount == 40 ){
		return true;
	}
	return false;
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		yC̃Xgʒu擾
 *
 * @param		none
 *
 * @return	Xgʒu
 */
//--------------------------------------------------------------------------------------------
f32 PaneList::GetBaseListPos(void)
{
  //@todo
	gfl::math::VEC3	pos = GetPanePos( param.paneList[baseRow*param.paneCol+0].pict );
	return ( param.listScroll-(pos.y-param.defPY)/param.defSY );
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		hbÕXN[l
 *
 * @param		none
 *
 * @return	XN[l
 */
//--------------------------------------------------------------------------------------------
f32 PaneList::GetUpdateDragScroll(void)
{
	// I[gXN[ɑJڂƂ
	if( updateSeq == PANELIST_SEQ_AUTO_SCROLL ){
		return pScrollValue->GetCurrentValue();
	// ͑҂ɑJڂƂ
	}else if( updateSeq == PANELIST_SEQ_INPUT ){
		return param.listScroll;
	}
	// LȊO
	gfl::math::VEC3 pos = GetPanePos( param.paneList[baseRow*param.paneCol+0].pict );
	return ( param.listScroll + ( static_cast<f32>(param.listPos) - (param.defPY-pos.y) / param.defSY ) );
}




void PaneList::InitKeyScrollChange( int mv )
{
	scrollVec = mv;
	scrollCount = 0;
	trgCount = 0;
	trgSpeed = 0;

	baseListPos = param.listScroll;

  baseRow = GetPosPaneIndex( param.listPos ) / param.paneCol;

  for( u32 c=0; c<param.paneCol; ++c )
  {
    u32 i = baseRow*param.paneCol + c;
	  SetItemChangePanePriority( i, true );
  }
}

void PaneList::SetItemChangePanePriority( u32 index, bool flg )
{
	gfl::math::VEC3	pos = GetPanePos( param.paneList[index].pict );
	if( flg == true ){
		pos.z = 0.1f;
	}else{
		pos.z = 0.0f;
	}
	SetPanePos( param.paneList[index].pict, pos );
}


void PaneList::PlayCursorMoveSE(void)
{
  if( param.moveSE != 0 )
  {
	  xy_snd::PlaySE( param.moveSE );
  }
}

void PaneList::Debug_ListInfo(void)
{
#if PM_DEBUG
  for( u32 r=0; r<param.paneRow;++r){
    for(u32 c=0; c<param.paneCol;++c){
      u32 i = r*param.paneCol+c;
      gfl::math::VEC3	pos = GetPanePos( param.paneList[ i ].pict );
      GFL_PRINT( "[%d] %f %f def%f r%ddr%d\n", i, pos.x, pos.y );
    }
  }
#endif
}

GFL_NAMESPACE_END( list )
GFL_NAMESPACE_END( zukan )
GFL_NAMESPACE_END( app )
