//============================================================================================
/**
 * @file    Scene.h
 * @brief   v[VrfIScene
 * @author  ito_isao
 * @date    12.05.25
 */
//============================================================================================

#ifndef __APP_PROMOTION_SCENE_H__
#define __APP_PROMOTION_SCENE_H__

#include <gflib.h>
#include "app/util/app_util_heap.h"

GFL_NAMESPACE_BEGIN(app)
GFL_NAMESPACE_BEGIN(promotion)

template<class T>
class IScene
{
public:
  virtual ~IScene(){}
  
  virtual void Enter() = 0;
  virtual bool Update() = 0;
  virtual void Exit() = 0;
  
  void SetOwner(T* owner){m_owner = owner;}
protected:
  T* m_owner;
};

//------------------------------------------------------------------------------
// eƂȂNX
//------------------------------------------------------------------------------
class Main : public IScene<Main>
{
public:
  Main();
  ~Main();
  
  virtual void Enter();
  virtual bool Update();
  virtual void Exit();
  
  void Draw();
  
  void SetNext(IScene<Main>* next){m_next = next;}
  
  bool IsFinished(){return m_finish;}
  void SetFinished(){m_finish = true;}
    
private:
  IScene<Main>* m_current;
  IScene<Main>* m_next;
  bool m_finish;
  
  app::util::Heap m_heap;
};
//------------------------------------------------------------------------------
// ߂ăvbNɓẮAtF[hC
//------------------------------------------------------------------------------
class InitScene : public IScene<Main>
{
public:
  virtual void Enter();
  virtual bool Update();
  virtual void Exit();
};

GFL_NAMESPACE_END(promotion)
GFL_NAMESPACE_END(app)

#endif //__APP_PROMOTION_SCENE_H__
