
#include "Proc.h"
#include "Scene.h"

GFL_NAMESPACE_BEGIN(app)
GFL_NAMESPACE_BEGIN(promotion)

//------------------------------------------------------------------------------
const int Proc::PROMOTION_SYS_HEAP_SIZE = 0x1000;

//------------------------------------------------------------------------------
Proc::Proc(PARAM* param) : 
m_heap(NULL),
m_scene(NULL)
{
}

Proc::~Proc()
{
}

//------------------------------------------------------------------------------
gfl::proc::Result Proc::InitFunc(gfl::proc::Manager* pProcManager)
{
  GFL_UNUSED(pProcManager);
  this->CreateHeap();
  
  // ŃV[쐬
  m_scene = GFL_NEW(m_heap) Main();
  return gfl::proc::RES_FINISH;
}
gfl::proc::Result Proc::EndFunc(gfl::proc::Manager* pProcManager)
{
  GFL_UNUSED(pProcManager);
  
  // V[̌Еt
  GFL_DELETE(m_scene);
  
  this->DeleteHeap();
  return gfl::proc::RES_FINISH;
}

//------------------------------------------------------------------------------
gfl::proc::Result Proc::UpdateFunc(gfl::proc::Manager* pProcManager)
{
  GFL_UNUSED(pProcManager);
  if(m_scene->Update())
  {
    return gfl::proc::RES_CONTINUE;
  }
  return gfl::proc::RES_FINISH;
}
//------------------------------------------------------------------------------
void Proc::DrawFunc(gfl::proc::Manager* pProcManager)
{
  GFL_UNUSED(pProcManager);
  m_scene->Draw();
}

//------------------------------------------------------------------------------
void Proc::CreateHeap()
{
  m_heap = GFL_CREATE_HEAP(gfl::heap::Manager::GetHeapByHeapId(HEAPID_APP),HEAPID_PROMOTION_SYS, PROMOTION_SYS_HEAP_SIZE, gfl::heap::HEAP_TYPE_EXP, false);
}
void Proc::DeleteHeap()
{
  gfl::heap::Manager::DeleteHeap(m_heap);
}


GFL_NAMESPACE_END(promotion)
GFL_NAMESPACE_END(app)

