//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *  GAME FREAK inc.
 *
 *  @file   TrModelManager.cpp
 *  @brief  ogpg[i[f}l[W
 *  @author Koji Kawada
 *  @date   2012.05.18
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]


#include <gflib.h>


// trainer
#include "trainer/btl_tr_gra_id.h"
#include "trainer/TrModel.h"
#include "trainer/TrModelManager.h"


namespace trainer {


//###########################
//###########################
//
// Jo
//
//###########################
//###########################
//-----------------------------------------------------------------------------
/**
 *   @brief  RXgN^
 */
//-----------------------------------------------------------------------------
TrModelManager::TrModelManager(
  gfl::heap::HeapBase* heap_memory,
  gfl::fs::FileReadManager* file_read_manager
)
  : m_file_read_manager(file_read_manager),
    m_element_head(NULL),
    m_element_tail(NULL)
{
  // [V߂t@Ct@C[h}l[Wɓo^Ă
  m_file_read_manager->AppendManageFile( 
    heap_memory,
    ARCID_TRMODEL,
    false
  );
}

//-----------------------------------------------------------------------------
/**
 *   @brief  fXgN^
 */
//-----------------------------------------------------------------------------
TrModelManager::~TrModelManager()
{
  GFL_ASSERT_MSG(IsAbleToDestroy(), "TrModelManager͂܂Ȃ̂Ŕjł܂B\n");

  while(1)
  {
    Element* elem = m_element_head;
    if( elem )
    {
      GFL_ASSERT_MSG(0, "TrModel܂cĂƂTrModelManager̃fXgN^Ă΂܂B\n");
      destroyModelForce(elem->model);
    }
    else
    {
      break;
    }
  }

  // [V߂t@Ct@C[h}l[WOĂ
  m_file_read_manager->RemoveManageFile(ARCID_TRMODEL);
}

//-----------------------------------------------------------------------------
/**
 *   @brief  OvZ
 */
//-----------------------------------------------------------------------------
void TrModelManager::CalculateBefore(void)
{
  Element* elem = m_element_head;
  while(elem)
  {
    elem->model->calculateBefore(this);
    elem = elem->next;
  }
}

//-----------------------------------------------------------------------------
/**
 *   @brief  vZ
 */
//-----------------------------------------------------------------------------
void TrModelManager::CalculateAfter(void)
{
  Element* elem = m_element_head;
  while(elem)
  {
    elem->model->calculateAfter(this);
    elem = elem->next;
  }
}

//-----------------------------------------------------------------------------
/**
 *   @brief  jł邩
 */
//-----------------------------------------------------------------------------
b32 TrModelManager::IsAbleToDestroy(void)
{
  b32 ret = true;
  Element* elem = m_element_head;
  while(elem)
  {
    ret = IsAbleToDestroyModel(elem->model);
    if( !ret ) break;
    elem = elem->next;
  }
  return ret;
}


////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////
//
// TrModel/j֘A
//
////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////

//-----------------------------------------------------------------------------
/**
 *   @brief  TrModel̔񓯊NGXg
 */
//-----------------------------------------------------------------------------
TrModel* TrModelManager::RequestCreateModel(
    gfl::heap::NwAllocator* heap_allocator,
    gfl::heap::NwAllocator* device_allocator,
    const TrModel::Description& description
)
{
  Element* elem = GFL_NEW(heap_allocator->GetHeapBase()) Element;
  
  // Ōɒǉ 
  if( m_element_tail )
  {
    m_element_tail->next = elem;
    elem->prev = m_element_tail;
  }
  else
  {
    elem->prev = NULL;
  }
  m_element_tail = elem;
  elem->next = NULL;
  
  if( !m_element_head ) m_element_head = elem;

  elem->model = GFL_NEW(heap_allocator->GetHeapBase()) TrModel(
    this,
    heap_allocator,
    device_allocator,
    description
  );

  return elem->model;
}

//-----------------------------------------------------------------------------
/**
 *   @brief  TrModelς݂mF
 */
//-----------------------------------------------------------------------------
b32 TrModelManager::IsModelCreated(TrModel* model)
{
  return model->isCreated();
}

//-----------------------------------------------------------------------------
/**
 *   @brief  TrModeljł邩
 */
//-----------------------------------------------------------------------------
b32 TrModelManager::IsAbleToDestroyModel(TrModel* model)
{
  return model->isCreated();  // łĂΔjł
}

//-----------------------------------------------------------------------------
/**
 *   @brief  TrModel̔j
 */
//-----------------------------------------------------------------------------
b32 TrModelManager::DestroyModel(TrModel* model)
{
  b32 ret = IsAbleToDestroyModel(model);
  if( ret )
  {
    destroyModelForce(model);
  }
  return ret;
}


//###########################
//###########################
//
// Jo
//
//###########################
//###########################
// vf𓾂
TrModelManager::Element* TrModelManager::getElement(TrModel* model) const
{
  Element* elem = m_element_head;
  while(elem)
  {
    if( elem->model == model ) break;
    elem = elem->next;
  }
  return elem;
}

// ITrModelj
void TrModelManager::destroyModelForce(TrModel* model)
{
  Element* elem = getElement(model);
  if( elem )
  {
    if( elem->prev ) elem->prev->next = elem->next;
    else             m_element_head   = elem->next;
    if( elem->next ) elem->next->prev = elem->prev;
    else             m_element_tail   = elem->prev;
    GFL_DELETE elem;
  }
  else
  {
    GFL_ASSERT_MSG(0, "model=%pTrModelManagerŊǗĂ܂B\n", model);
  }

  GFL_DELETE model;
}


// @brief  g[i[fɍœKȃV[
void CreateTrModelEnv(
    gfl::heap::NwAllocator*      heap_allocator,
    gfl::heap::NwAllocator*      device_allocator,
    TrModelEnvMember*            member,
    gfl::grp::g3d::Scene*        scene,
    s32                          scene_calculate_group_index
)
{
  {
    gfl::grp::g3d::Light::Description desc;
    gfl::grp::g3d::Light::InitializeDescriptionForFragmentLight(
        &desc,
        gfl::grp::g3d::Light::KIND_DIRECTIONAL
    );
    member->light = GFL_NEW( heap_allocator->GetHeapBase() ) gfl::grp::g3d::Light;
    member->light->Create( device_allocator, &desc );
 
    member->light->SetTranslate(gfl::math::VEC3(0.0f, 0.0f, 0.0f)         );
    member->light->SetDirection(gfl::math::VEC3(-1.0f, -1.0f, -1.0f)      );
    member->light->SetAmbient  (gfl::grp::ColorF32(0.2f, 0.2f, 0.2f, 1.0f));
    member->light->SetDiffuse  (gfl::grp::ColorF32(1.0f, 1.0f, 1.0f, 1.0f));
    member->light->SetSpecular0(gfl::grp::ColorF32(1.0f, 1.0f, 1.0f, 1.0f));
    member->light->SetSpecular1(gfl::grp::ColorF32(1.0f, 1.0f, 1.0f, 1.0f));
  }
  {
    member->light_set = GFL_NEW( heap_allocator->GetHeapBase() ) gfl::grp::g3d::LightSet;
    member->light_set->Create( device_allocator );
    member->light_set->AddLight( member->light );
  }
  if(scene)
  {
    enum
    {
      TR_MODEL_LIGHT_SET_INDEX = 2
    };
    scene->AddNodeToCalc( member->light, scene_calculate_group_index );
    scene->SetLightSet( TR_MODEL_LIGHT_SET_INDEX, member->light_set );
  }
}
void DestroyTrModelEnv(
    TrModelEnvMember*            member,
    gfl::grp::g3d::Scene*        scene
)
{
  if( member->light )
  {
    if( scene )
    {
      scene->RemoveNodeFromCalc( member->light );
    }
    GFL_DELETE member->light;
    member->light = NULL;
  }
  if( member->light_set )
  {
    GFL_DELETE member->light_set;
    member->light_set = NULL;
  }
}


} // namespace trainer

