//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *	GAME FREAK inc.
 *
 *	@file		TrModel.cpp
 *	@brief  ogpg[i[f
 *	@author	Koji Kawada
 *	@date		2012.05.18
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]


#include <gflib.h>


// kujira
#include "system/PokemonShaderModel.h"
#include "system/dress_up/DressUpInclude.h"
#include "../../src/system/motion/BaseMotionCharacter.h"

// arc
#include "arc/arc_def.h"            // ARCID_
#include "arc/trmodel.gaix"

// trainer
#include "trainer/btl_tr_gra_id.h"
#include "trainer/TrModel.h"
#include "trainer/TrModelManager.h"


namespace trainer {


//-----------------------------------------------------------------------------
#include "trmodel_file_def.cdat"
// @todo arct@C0oCgt@CāAarcdatid̃CfbNX̃ItZbgŃt@CɃANZXł悤ɂقB
//static const s16 TRMODEL_FILE_MODEL_BTL_TABLE[BTL_TR_GRA_ID_MAX] = 
//static const s16 TRMODEL_FILE_MOTION_BTL_TABLE[BTL_TR_GRA_ID_MAX] = 
//static const s16 TRMODEL_FILE_MOTION_OTHER_TABLE[BTL_TR_GRA_ID_MAX] = 
//-----------------------------------------------------------------------------


//###########################
//###########################
//
// Jo
//
//###########################
//###########################
//-----------------------------------------------------------------------------
/**
 *   @brief  fV[ɓo^
 */
//-----------------------------------------------------------------------------
b32 TrModel::AddModelToScene(
  gfl::grp::g3d::Scene* scene,
  s32 scene_calculate_group_index,
  s32 scene_draw_group_index
)
{
  b32 ret = false;
  if( isCreated() )
  {
    switch(m_model_type)
    {
    case MODEL_TYPE_BTL:
      {
        xy_system::PokemonShaderModel* model = GetModel();
        ret = scene->AddNodeToCalcAndDraw(model, scene_calculate_group_index, scene_draw_group_index);
        break;
      }
    case MODEL_TYPE_BTL_DRESS:
      {
        xy_system::dress_up::DressUpIModel* model = GetDressUpModel();
        model->AddToScene(scene, scene_calculate_group_index, scene_draw_group_index);
        ret = true;
        break;
      }
    }
  }
  return ret;
}

//-----------------------------------------------------------------------------
/**
 *   @brief  fV[O
 */
//-----------------------------------------------------------------------------
void TrModel::RemoveModelFromScene(
  gfl::grp::g3d::Scene* scene
)
{
  if( isCreated() )
  {
    switch(m_model_type)
    {
    case MODEL_TYPE_BTL:
      {
        xy_system::PokemonShaderModel* model = GetModel();
        scene->RemoveNodeFromCalcAndAllDraw(model);
        break;
      }
    case MODEL_TYPE_BTL_DRESS:
      {
        xy_system::dress_up::DressUpIModel* model = GetDressUpModel();
        model->RemoveFromScene(scene);
        break;
      }
    }
  }
}

//-----------------------------------------------------------------------------
/**
 *   @brief  ʒuݒ肷
 *
 *   @param[in]  translate  ʒuW
 */
//-----------------------------------------------------------------------------
void TrModel::SetTranslate(const gfl::math::VEC3& translate)
{
  if( isCreated() )
  {
    if( m_motion )
    {
      m_motion->GetRootPosition()->SetX(translate.x);
      m_motion->GetRootPosition()->SetY(translate.y);
      m_motion->GetRootPosition()->SetZ(translate.z);
    }
    else
    {
      switch(m_model_type)
      {
      case MODEL_TYPE_BTL:
        {
          xy_system::PokemonShaderModel* model = GetModel();
          model->SetTranslate(translate);
          break;
        }
      case MODEL_TYPE_BTL_DRESS:
        {
          xy_system::dress_up::DressUpIModel* model = GetDressUpModel();
          model->SetTranslate(translate);
          break;
        }
      }
    }
  }
}

//-----------------------------------------------------------------------------
/**
 *   @brief  [VԍύX
 */
//-----------------------------------------------------------------------------
void TrModel::ChangeMotion(s32 motion_no)
{
  if( isCreated() )
  {
    m_motion->Change( gfl::motion::MotionBase::MOTION_BEGIN + motion_no );
  }
}

//-----------------------------------------------------------------------------
/**
 *   @brief  ʏ탂f(gfl::grp::g3d::Model̔hNXłxy_system::PokemonShaderModel)擾
 */
//-----------------------------------------------------------------------------
xy_system::PokemonShaderModel* TrModel::GetModel(void) const
{
  if( isCreated() )
  {
    return getModelForce();
  }
  return NULL;
}

//-----------------------------------------------------------------------------
/**
 *   @brief  ւf擾
 */
//-----------------------------------------------------------------------------
xy_system::dress_up::DressUpIModel* TrModel::GetDressUpModel(void) const
{
  if( isCreated() )
  {
    if( m_model_type == MODEL_TYPE_BTL_DRESS )
    {
      return (reinterpret_cast<xy_system::dress_up::DressUpIModel*>(m_model));
    }
  }
  return NULL;
}

//-----------------------------------------------------------------------------
/**
 *   @brief  [V擾
 */
//-----------------------------------------------------------------------------
proj::motion::BaseMotionCharacter* TrModel::GetMotion(void) const
{
  if( isCreated() )
  {
    return m_motion;
  }
  return NULL;
}


//###########################
//###########################
//
// Jo(friendJo)
//
//###########################
//###########################
TrModel::TrModel(
  TrModelManager* manager,
  gfl::heap::NwAllocator* heap_allocator,
  gfl::heap::NwAllocator* device_allocator,
  const Description& description
)
  : m_id(0),
    //m_formno(0),
    m_model_type(MODEL_TYPE_BTL),
    m_motion_type(MOTION_TYPE_BTL),
    m_model_buffer(NULL),
    m_model_resource(NULL),
    m_model(NULL),
    m_motion_buffer(NULL),
    m_motion(NULL)
{
  m_create_param = NULL;

  startCreate(
    manager,
    heap_allocator,
    device_allocator,
    description
  );
}

TrModel::~TrModel()
{
  destroy();
}

b32 TrModel::isCreated(void) const
{
  if( m_create_param )
  {
    return (m_create_param->state == CreateParam::STATE_CREATED);
  }
  return false;
}

xy_system::PokemonShaderModel* TrModel::getModelForce(void) const
{
  if( m_model_type == MODEL_TYPE_BTL )
  {
    return (reinterpret_cast<xy_system::PokemonShaderModel*>(m_model));
  }
  return NULL;
}

void TrModel::calculateBefore(TrModelManager* manager)
{
  gfl::fs::FileReadManager* file_read_manager = manager->getFileReadManager();

  if( isCreated() )
  {
    // ς݂̂Ƃ̍XV
    if( m_motion )
    {
      m_motion->UpdateMotion();
    }
  }
  else
  {
    // ̂Ƃ̍XV
    gfl::heap::HeapBase* heap_memory = m_create_param->heap_allocator->GetHeapBase();
    gfl::heap::HeapBase* device_memory = m_create_param->device_allocator->GetHeapBase();
    
    switch( m_create_param->state )
    {
    case CreateParam::STATE_MODEL_LOADING:
      {
        b32 is_continue = true; 
        switch(m_model_type)
        {
        case MODEL_TYPE_BTL:
          {
            if( file_read_manager->IsReadFinished(&m_model_buffer) )
            {
              // ft@Cǂݍ݊
              // f𐶐
              {
                m_model_resource = GFL_NEW(heap_memory) gfl::grp::g3d::Resource;
                m_model_resource->AttachBuffer(m_create_param->device_allocator, m_model_buffer);
                u32 common_resource_flag = gfl::grp::g3d::Resource::COMMON_RESOURCE_DEFAULT_SHADER_BIT;
                m_model_resource->Setup(m_create_param->device_allocator, NULL, common_resource_flag);

                gfl::grp::g3d::Model::Description desc;
                desc.animation_slot_num = 1;
                xy_system::PokemonShaderModel* model = GFL_NEW(heap_memory) xy_system::PokemonShaderModel;
                model->Create(m_create_param->heap_allocator, m_create_param->device_allocator,
                    m_model_resource, 0, &desc);
                m_model = model;
              }
              is_continue = false;
            }
            break;
          }
        case MODEL_TYPE_BTL_DRESS:
          {
            xy_system::dress_up::IndividualFashion* individual_fashion = getIndividualFashion();
            xy_system::dress_up::DressUpResourceBuilder::UpdateAsyncLoadResource();
            b32 ret = xy_system::dress_up::DressUpResourceBuilder::DoesExistResource(
              &(individual_fashion->individual)
            );
            if(ret)
            {
              // ft@Cǂݍ݊
              // f𐶐
              {
                xy_system::dress_up::DressUpIModel* model = xy_system::dress_up::DressUpModelBuilder::CreateModelUsingResourceManager(
                    m_create_param->heap_allocator,
                    m_create_param->heap_allocator,
                    m_create_param->device_allocator,
                    &(individual_fashion->individual)
                );
                m_model = model;
              }
              is_continue = false;
            }
            break;
          }
        }
        if( is_continue )
        {
          break;
        }
        else
        {
          // [Vt@Cǂݍ݊Jn
          {
            gfl::fs::ArcFile::ARCID    arcid    = ARCID_TRMODEL;
            gfl::fs::ArcFile::ARCDATID arcdatid = TRMODEL_FILE_MOTION_BTL_TABLE[m_id];
            if( m_motion_type == MOTION_TYPE_OTHER ) arcdatid = TRMODEL_FILE_MOTION_OTHER_TABLE[m_id];
       
            file_read_manager->AddReadRequest(
                &m_motion_buffer, 
                &(m_create_param->motion_size),
                heap_memory,
                4, 
                arcid,
                arcdatid,
                false,
                gfl::fs::FileReadManager::REQUEST_PRIORITY_NORMAL
            );
          }
          ++(m_create_param->state);
          //breakȂ
        }
      }
    case CreateParam::STATE_MOTION_LOADING:
      {
        if( !(file_read_manager->IsReadFinished(&m_motion_buffer)) )
        {
          break;
        }
        else
        {
          // [Vt@Cǂݍ݊
          // [V𐶐
          {
            m_motion = GFL_NEW(heap_memory) proj::motion::BaseMotionCharacter;
            m_motion->Initialize(m_motion_buffer, heap_memory);
            m_motion->SetAttributeOn( proj::motion::Motion::M_ATTR_NO_IK );  // nʂȂ̂

            switch(m_model_type)
            {
            case MODEL_TYPE_BTL:
              {
                xy_system::PokemonShaderModel* model = getModelForce();  // ܂Ȃ̂ŁAf擾̂getModelForcegpB
                m_motion->InitializeModel(model);
                break;
              }
            case MODEL_TYPE_BTL_DRESS:
              {
                // DressUpIModelSetMotionInitializeModelĂ̂ŁAł͉Ȃ
                break;
              }
            }
          }
          ++(m_create_param->state);
          //breakȂ
        }
      }
    }
  }
}

void TrModel::calculateAfter(TrModelManager* manager)
{
  if( isCreated() )
  {
    // ς݂̂Ƃ̍XV
    if( m_motion )
    {
      switch(m_model_type)
      {
      case MODEL_TYPE_BTL:
        {
          m_motion->ToModel();  // InitializeModelĂ̂ŁAȂłB
          break;
        }
      case MODEL_TYPE_BTL_DRESS:
        {
          xy_system::dress_up::DressUpIModel* model = GetDressUpModel();
          model->SetMotion(m_motion);
          break;
        }
      }
    }
  }
}

void TrModel::startCreate(
  TrModelManager* manager,
  gfl::heap::NwAllocator* heap_allocator,
  gfl::heap::NwAllocator* device_allocator,
  const Description& description
)
{
  gfl::fs::FileReadManager* file_read_manager = manager->getFileReadManager();

  gfl::heap::HeapBase* heap_memory = heap_allocator->GetHeapBase();
  gfl::heap::HeapBase* device_memory = device_allocator->GetHeapBase();

  // Description
  m_id = description.id;
  //m_formno = description.formno;
  m_model_type = description.model_type;
  m_motion_type = description.motion_type;
  
  // CreateParam
  m_create_param = GFL_NEW(heap_memory) CreateParam;
  m_create_param->heap_allocator   = heap_allocator;
  m_create_param->device_allocator = device_allocator;
  
  switch(m_model_type)
  {
  case MODEL_TYPE_BTL:
    {
      m_create_param->desc_param = NULL;
      break;
    }
  case MODEL_TYPE_BTL_DRESS:
    {
      xy_system::dress_up::IndividualFashion* individual_fashion = GFL_NEW(heap_memory) xy_system::dress_up::IndividualFashion;
      xy_system::dress_up::CopyIndividualFashion(individual_fashion, reinterpret_cast<xy_system::dress_up::Individual*>(description.param));
      m_create_param->desc_param = individual_fashion;
      break;
    }
  }

  // ft@Cǂݍ݊Jn
  switch(m_model_type)
  {
  case MODEL_TYPE_BTL:
    {
      gfl::fs::ArcFile::ARCID    arcid    = ARCID_TRMODEL;
      gfl::fs::ArcFile::ARCDATID arcdatid = TRMODEL_FILE_MODEL_BTL_TABLE[m_id];
    
      file_read_manager->AddReadRequest(
          &m_model_buffer, 
          &(m_create_param->model_size),
          device_memory,
          128, 
          arcid,
          arcdatid,
          false,
          gfl::fs::FileReadManager::REQUEST_PRIORITY_NORMAL
      );

      m_create_param->state = CreateParam::STATE_MODEL_LOADING;
      break;
    }
  case MODEL_TYPE_BTL_DRESS:
    {
      xy_system::dress_up::IndividualFashion* individual_fashion = getIndividualFashion();

      xy_system::dress_up::DressUpResourceBuilder::RequestAsyncLoadResource(
        heap_memory,
        m_create_param->device_allocator,
        &(individual_fashion->individual)
      );

      m_create_param->state = CreateParam::STATE_MODEL_LOADING;
      break;
    }
  }
}

void TrModel::destroy(void)
{
  GFL_ASSERT_MSG( ( m_create_param->state != CreateParam::STATE_MODEL_LOADING && m_create_param->state != CreateParam::STATE_MOTION_LOADING ), \
      "̂ߔjł܂B\n");

  // [V
  if( m_motion )
  {
    GFL_DELETE m_motion;
    m_motion = NULL;
  }
  if( m_motion_buffer ) 
  {
    GflHeapFreeMemory(m_motion_buffer);
    m_motion_buffer = NULL;
  }

  // f
  if( m_model )
  {
    switch(m_model_type)
    {
    case MODEL_TYPE_BTL:
      {
        if( m_model )
        {
          xy_system::PokemonShaderModel* model = GetModel();
          GFL_DELETE model;
          m_model = NULL;
        }
        if( m_model_resource )
        {
          GFL_DELETE m_model_resource;
          m_model_resource = NULL;
        }
        if( m_model_buffer )
        {
          GflHeapFreeMemory(m_model_buffer);
          m_model_buffer = NULL;
        }
        break;
      }
    case MODEL_TYPE_BTL_DRESS:
      {
        if( m_model )
        {
          xy_system::dress_up::DressUpIModel* model = GetDressUpModel();
          xy_system::dress_up::DressUpModelBuilder::DestroyModelUsingResourceManager(model);
          m_model = NULL;
        }
        if( m_create_param && m_create_param->desc_param )
        {
          xy_system::dress_up::IndividualFashion* individual_fashion = getIndividualFashion();

          xy_system::dress_up::DressUpResourceBuilder::RequestAsyncUnloadResource(&(individual_fashion->individual));
          xy_system::dress_up::DressUpResourceBuilder::UpdateAsyncLoadResource();  // ǂݍݏIĂ郊\[XȂUpdate1ǂł΍폜  // @todo NGXg𔭍sƂɑjɂAւ\[X}l[WCł邩H
          b32 ret = xy_system::dress_up::DressUpResourceBuilder::DoesNotExistResource(
            &(individual_fashion->individual)
          );
          GFL_ASSERT_MSG( ret, "ւf̃\[XjłĂ܂B\n" );
          GFL_DELETE individual_fashion;
          m_create_param->desc_param = NULL;
        }
        break;
      }
    }
  }

  if( m_create_param )
  {
    GFL_DELETE m_create_param;
    m_create_param = NULL;
  }
}

// CreateParamdesc_paramxy_system::dress_up::IndividualFashion*ɃLXgē
xy_system::dress_up::IndividualFashion* TrModel::getIndividualFashion(void) const
{
  if( m_model_type == MODEL_TYPE_BTL_DRESS )
  {
    if( m_create_param )
    {
      return reinterpret_cast<xy_system::dress_up::IndividualFashion*>(m_create_param->desc_param);
    }
  }
  return NULL;
}


} // namespace trainer

