#pragma once
#if !defined( __TRAINER_TRMODEL_H__ )
#define __TRAINER_TRMODEL_H__

//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *	GAME FREAK inc.
 *
 *	@file		TrModel.h
 *	@brief  ogpg[i[f
 *	@author	Koji Kawada
 *	@date		2012.05.18
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]


#include <gflib.h>


// kujira
#include "system/PokemonShaderModel.h"
#include "system/dress_up/DressUpInclude.h"
#include "../../src/system/motion/BaseMotionCharacter.h"


namespace trainer {


// NX̑O錾
class TrModelManager;


// @brief  ogpg[i[fNX
class TrModel
{
  GFL_FORBID_COPY_AND_ASSIGN(TrModel);
  
  friend class TrModelManager;


  //###########################
  //###########################
  //
  // Jo
  //
  //###########################
  //###########################
public:
  // @brief  f^Cv
  enum ModelType
  {
    //MODEL_TYPE_FLD,
    //MODEL_TYPE_FLD_DRESS,
    MODEL_TYPE_BTL,
    MODEL_TYPE_BTL_DRESS
  };

  // @brief  [V^Cv
  enum MotionType
  {
    //MOTION_TYPE_FLD,  // MODEL_TYPE_FLD*n̂Ƃ̂ݗL
    MOTION_TYPE_BTL,    // MODEL_TYPE_BTL*n̂Ƃ̂ݗL
    MOTION_TYPE_OTHER   // MODEL_TYPE_BTL*n̂Ƃ̂ݗL
  };

  // @brief  ݒe
  struct Description
  {
    s32     id :16;          // BtlTrGraID
    //s32     formno :4;  // tHԍǉꂽs32̊Uς܂B
    s32     model_type  :8;  // ModelType
    s32     motion_type :8;  // MotionType
    void*   param;  // gpȂƂNULLBMODEL_TYPE_*_DRESS_UPn̂Ƃxy_system::dress_up::Individual*
  };

public:
  //-----------------------------------------------------------------------------
  /**
   *   @brief  fV[ɓo^
   *           
   *   @param[in]  scene                        V[
   *   @param[in]  scene_calculate_group_index  V[vZO[vCfbNX
   *   @param[in]  scene_draw_group_index       V[`O[vCfbNX
   *
   *   @retval  V[ɓo^łƂtrueԂ
   */
  //-----------------------------------------------------------------------------
  b32 AddModelToScene(
    gfl::grp::g3d::Scene* scene,
    s32 scene_calculate_group_index,
    s32 scene_draw_group_index
  );

  //-----------------------------------------------------------------------------
  /**
   *   @brief  fV[O
   *
   *   @param[in]  scene                        V[
   */
  //-----------------------------------------------------------------------------
  void RemoveModelFromScene(
    gfl::grp::g3d::Scene* scene
  );

  //-----------------------------------------------------------------------------
  /**
   *   @brief  ʒuݒ肷
   *
   *   @param[in]  translate  ʒuW
   */
  //-----------------------------------------------------------------------------
  void SetTranslate(const gfl::math::VEC3& translate);

  //-----------------------------------------------------------------------------
  /**
   *   @brief  [VԍύX
   *
   *   @param[in]  motion_no  [Vԍ
   *                          MOTION_TYPE_BTL̂ƂTRMOT_BTL_*`
   *                          MOTION_TYPE_OTHER̂ƂTRMOT_OTHER_*`
   *   @retval  ͉ȂB
   */
  //-----------------------------------------------------------------------------
  void ChangeMotion(s32 motion_no);

  //-----------------------------------------------------------------------------
  /**
   *   @brief  ʏ탂f(gfl::grp::g3d::Model̔hNXłxy_system::PokemonShaderModel)擾
   *
   *   @retval  ʏ탂fłȂƂNULLԂB
   *            NULLԂB
   */
  //-----------------------------------------------------------------------------
  xy_system::PokemonShaderModel* GetModel(void) const;

  //-----------------------------------------------------------------------------
  /**
   *   @brief  ւf擾
   *
   *   @retval  ւfłȂƂNULLԂB
   *            NULLԂB
   */
  //-----------------------------------------------------------------------------
  xy_system::dress_up::DressUpIModel* GetDressUpModel(void) const;

  //-----------------------------------------------------------------------------
  /**
   *   @brief  [V擾
   *          
   *   @retval  NULLԂB
   */
  //-----------------------------------------------------------------------------
  proj::motion::BaseMotionCharacter* GetMotion(void) const;


  //###########################
  //###########################
  //
  // Jo(friendJo)
  //
  //###########################
  //###########################
private:
  TrModel(
    TrModelManager* manager,
    gfl::heap::NwAllocator* heap_allocator,
    gfl::heap::NwAllocator* device_allocator,
    const Description& description
  );
  ~TrModel();
  b32 isCreated(void) const;

  //-----------------------------------------------------------------------------
  /**
   *   @brief  ʏ탂f(gfl::grp::g3d::Model̔hNXłxy_system::PokemonShaderModel)擾
   *
   *   @retval  ʏ탂fłȂƂNULLԂB
   *            ł擾łB
   */
  //-----------------------------------------------------------------------------
  xy_system::PokemonShaderModel* getModelForce(void) const;

  void calculateBefore(TrModelManager* manager);
  void calculateAfter(TrModelManager* manager);
  void startCreate(
    TrModelManager* manager,
    gfl::heap::NwAllocator* heap_allocator,
    gfl::heap::NwAllocator* device_allocator,
    const Description& description
  );
  void destroy(void);


  //###########################
  //###########################
  //
  // Jo
  //
  //###########################
  //###########################
private:
  // @brief  ɂgȂo
  struct CreateParam
  {
    // @brief  
    enum State
    {
      STATE_NONE,
      STATE_MODEL_LOADING,
      STATE_MOTION_LOADING,
      STATE_CREATED
    };

    gfl::heap::NwAllocator*  heap_allocator;       
    gfl::heap::NwAllocator*  device_allocator;     
    void*                    desc_param;  // DescriptionɏĂparam
    u32                      model_size;
    u32                      motion_size;
    s8                       state;
    s8                       dummy[3];

    CreateParam(void)
      : heap_allocator(NULL),
        device_allocator(NULL),
        desc_param(NULL),
        model_size(0),
        motion_size(0),
        state(STATE_NONE)
    {}
  };

private:
  // CreateParamdesc_paramxy_system::dress_up::IndividualFashion*ɃLXgē
  xy_system::dress_up::IndividualFashion* getIndividualFashion(void) const;

private:
  // Description̓e
  s16     m_id;          // BtlTrGraID
  //s8     m_formno;  // tHԍǉꂽ4oCgACgɂȂ悤܂B
  s8     m_model_type;  // ModelType
  s8     m_motion_type;  // MotionType

  // 
  void*                               m_model_buffer;
  gfl::grp::g3d::Resource*            m_model_resource;
  void*                               m_model;  // xy_system::PokemonShaderModel*xy_system::dress_up::DressUpIModel* 
  void*                               m_motion_buffer;
  proj::motion::BaseMotionCharacter*  m_motion;

  // ɂgȂo
  CreateParam*  m_create_param;
};


} // namespace trainer

#endif // __TRAINER_TRMODEL_H__

