//============================================================================
/**
 *	GAME FREAK inc.
 *
 *	@file		FieldMirror.h
 *	@brief  tB[hf荞
 *	@author
 *
 */
//============================================================================
#include <gflib.h>
#ifndef __FIELDMIRROR_H__
#define __FIELDMIRROR_H__

namespace field{

class FieldMirror
{
  static const int MIRROR_MDL_NUM = 24;
  
  private:
  struct MIRROR_WORK
  {
    bool valid;
    gfl::grp::g3d::Model* model;
  };
  MIRROR_WORK m_Work[MIRROR_MDL_NUM];
  gfl::grp::GraphicsSystem* m_pGraphicsSys;
  gfl::grp::g3d::Scene* m_pScene;

  void SetMirror( nw::gfx::Model* model, bool flg );
  public:
  FieldMirror();
  ~FieldMirror();
  void Initialize( gfl::grp::GraphicsSystem* p_graph_sys, gfl::grp::g3d::Scene* p_scene );
  bool Entry( gfl::grp::g3d::Model* model );
  bool Remove( gfl::grp::g3d::Model* model );
  void DrawBefore( void );
  void DrawAfter( void );
  void Draw( gfl::grp::g3d::StereoCamera* pCamera );
};

}//namespace field

#endif	// __FIELDMIRROR_H__
