//============================================================================
/**
 *	GAME FREAK inc.
 *
 *	@file		FieldMirror.cpp
 *	@brief  tB[hf荞
 *	@author
 *
 */
//============================================================================

#include "FieldMirror.h"
#include "FieldGraphics.h"
namespace field{
//----------------------------------------------------------------------------
/**
 *	@brief  RXgN^
 */
//-----------------------------------------------------------------------------
FieldMirror::FieldMirror()
{
}

//----------------------------------------------------------------------------
/**
 *	@brief  fXgN^
 */
//-----------------------------------------------------------------------------
FieldMirror::~FieldMirror()
{
}

//----------------------------------------------------------------------------
/**
 *	@brief  
 */
//-----------------------------------------------------------------------------
void FieldMirror::Initialize( gfl::grp::GraphicsSystem* p_graph_sys, gfl::grp::g3d::Scene* p_scene )
{
  for (int i=0;i<MIRROR_MDL_NUM;i++)
  {
    m_Work[i].valid = false;
    m_Work[i].model = NULL;
  }
  GFL_ASSERT_STOP(p_graph_sys != NULL);
  GFL_ASSERT_STOP(p_scene != NULL);
  m_pGraphicsSys = p_graph_sys;
  m_pScene = p_scene;
}

//----------------------------------------------------------------------------
/**
 *	@brief  Gg[
 */
//-----------------------------------------------------------------------------
bool FieldMirror::Entry( gfl::grp::g3d::Model* model )
{
  for (int i=0;i<MIRROR_MDL_NUM;i++)
  {
    if ( !m_Work[i].valid )
    {
      m_Work[i].model = model;
      m_Work[i].valid = true;

      //`O[vǉ
      m_pScene->AddModelToSceneDrawGroup(model, SCENE_DRAW_GROUP_INDEX_MIRROR);
      return true;
    }
  }
  GFL_ASSERT_MSG(0,"FIELD_MIRROR_ENTRY OVER");
  return false;
}

//----------------------------------------------------------------------------
/**
 *	@brief  [u
 */
//-----------------------------------------------------------------------------
bool FieldMirror::Remove( gfl::grp::g3d::Model* model )
{
  for (int i=0;i<MIRROR_MDL_NUM;i++)
  {
    if ( m_Work[i].valid )
    {
      if ( m_Work[i].model == model )
      {
        b32 rc;
        //[u
        m_Work[i].valid = false;
        m_Work[i].model = NULL;
        //`O[v폜
        rc = m_pScene->RemoveModelFromSceneDrawGroup(model, SCENE_DRAW_GROUP_INDEX_MIRROR);
        GFL_ASSERT(rc);
        return true;
      }
    }
  }
  GFL_ASSERT_MSG(0,"FIELD_MIRROR_REMOVE NOT FOUND");
  return false;
}

//----------------------------------------------------------------------------
/**
 *	@brief  `
 */
//-----------------------------------------------------------------------------
void FieldMirror::Draw( gfl::grp::g3d::StereoCamera* pCamera )
{
  m_pScene->CommandSaveStereoDraw(
      m_pGraphicsSys,
      pCamera,
      m_pGraphicsSys->GetFrameBufferManager()->GetRenderTarget(m_pGraphicsSys->GetCurrentFrameBufferID(gfl::grp::DISPLAY_UPPER)),
      m_pGraphicsSys->GetFrameBufferManager()->GetRenderTarget(m_pGraphicsSys->GetCurrentFrameBufferID(gfl::grp::DISPLAY_UPPER_RIGHT)),
      SCENE_DRAW_GROUP_INDEX_MIRROR );
}

//----------------------------------------------------------------------------
/**
 *	@brief  f荞݃tOZbg
 */
//-----------------------------------------------------------------------------
void FieldMirror::SetMirror( nw::gfx::Model* model, bool flg )
{
  nw::gfx::res::ResRasterization::CullingMode cull_mode;
  gfl::math::VEC4 param[3];

  if ( flg )
  {
    param[0].x = 1.0f;
    param[0].y = 0.0;
    param[0].z = 0.0;
    param[0].w = 0.0;
    param[1].x = 0.0;
    param[1].y = -1.0;
    param[1].z = 0.0;
    param[1].w = 260.0;
    param[2].x = 0.0;
    param[2].y = 0.0;
    param[2].z = 1.0;
    param[2].w = 0.0;
    cull_mode = nw::gfx::res::ResRasterization::CULLINGMODE_FRONT;
  }
  else
  {
    param[0].x = 1.0f;
    param[0].y = 0.0;
    param[0].z = 0.0;
    param[0].w = 0.0;
    param[1].x = 0.0;
    param[1].y = 1.0;
    param[1].z = 0.0;
    param[1].w = 0.0;
    param[2].x = 0.0;
    param[2].y = 0.0;
    param[2].z = 1.0;
    param[2].w = 0.0;
    cull_mode = nw::gfx::res::ResRasterization::CULLINGMODE_BACK;
  }

  for( s32 i = 0; i < model->GetMaterialCount(); ++i )
  {
    nw::gfx::Material               *material = model->GetMaterial( i );
    nw::gfx::ResMaterial&           res_material_ras = material->GetRasterizationResMaterial();
    nw::gfx::ResMaterial&           res_material_shd = material->GetShaderParameterResMaterial();
    nw::gfx::res::ResRasterization res_rasterization = res_material_ras.GetRasterization();
    res_rasterization.SetCullingMode( cull_mode );
#if 1
    for ( s32 i2 = 0; i2 < res_material_shd.GetShaderParametersCount(); ++i2  )
    {
      nw::gfx::res::ResShaderParameter      res_param = res_material_shd.GetShaderParameters( i2 );
      //float *f_ary = res_param.GetParameter().GetValueF32();
      //NOZOMU_PRINT( "PRM_VAL = %f, %f, %f,%f\n",f_ary[0], f_ary[1], f_ary[2], f_ary[3] );
      res_param.GetParameter().SetValue( param[i2] );
    }
#endif
    material->GetShaderParameterResMaterial().SetShaderParametersHash(0);
    material->GetRasterizationResMaterial().SetRasterizationHash(0);
  }
}

void FieldMirror::DrawBefore( void )
{
  nw::gfx::Model* p_model;
  for (int i=0;i<MIRROR_MDL_NUM;i++)
  {
    if ( m_Work[i].valid )
    {
      p_model = m_Work[i].model->GetNwModel();

      //f荞݂𔽉f
      SetMirror( p_model, true );
    }
  }
}

void FieldMirror::DrawAfter( void )
{
  nw::gfx::Model* p_model;
  for (int i=0;i<MIRROR_MDL_NUM;i++)
  {
    if ( m_Work[i].valid )
    {
      p_model = m_Work[i].model->GetNwModel();

      //f荞݂Zbg
      SetMirror( p_model, false );
    }
  }
}

}//namespace field

