//============================================================================================
/**
 * @file		sparring_hp_gauge.h
 * @brief		HPQ[W֘A
 * @author	sogabe
 * @date		12.05.25
 */
//============================================================================================

#ifndef __SPARRING_HP_GAUGE_H__
#define __SPARRING_HP_GAUGE_H__

#include  "../actor/ActorBase.h"

namespace app {
namespace sparring {

  class GraphicWork;

  class SparringHPGauge
  { 
    GFL_FORBID_COPY_AND_ASSIGN( SparringHPGauge );

    private:
    struct SparringHPGaugeParam
    { 
      bool              enable;       //Q[W̉
      s32               id;           //Q[WID
      actor::ActorBase* actor_base;   //Q[WʒuǏ]AN^[
      u32               max_dot;      //Q[W̍őhbg
      f32               now_frame;    //Q[W݈ʒu
      f32               end_frame;    //Q[WBʒu
      int               wait;         //Q[Wړ̃EGCg
      int               wait_tmp;     //Q[Wړ̃EGCg
      int               vanish_wait;  //Q[W܂ł̃EGCg
      //----------------------------------------------------------------------------
      /**
      *	@brief  RXgN^
      *
      *	@param  heap  q[v
      *	@param  scene V[}l[W̃|C^
      * @param  value AN^[e[uMAX
      */
      //-----------------------------------------------------------------------------
      SparringHPGaugeParam(void) :
      enable( false ),
      id( -1 ),
      actor_base( NULL ),
      max_dot( 0 ),
      now_frame( 0.0f ),
      end_frame( 0.0f ),
      wait( 0 ),
      wait_tmp( 0 )
      {}
    };

    SparringHPGaugeParam* mGaugeParam;
    s32                   mGaugeMax;

    public:
    //----------------------------------------------------------------------------
    /**
     *	@brief    RXgN^
     *
     *	@param[in]  heap      q[v
     *	@param[in]  gauge_max ǗQ[W̍ő吔
     */
    //-----------------------------------------------------------------------------
    SparringHPGauge( gfl::heap::HeapBase* heap, const s32 gauge_max );

    //----------------------------------------------------------------------------
    /**
     *	@brief    fXgN^
     */
    //-----------------------------------------------------------------------------
    ~SparringHPGauge();

    //----------------------------------------------------------------------------
    /**
     *	@brief    ZbgAbv
     *
     *	@param[in]  index       ǗCfbNX
     *	@param[in]  id          Q[WID
     *	@param[in]  max_dot     Q[W̍őhbg
     *	@param[in]  enable      XV邩ǂ
     *	@param[in]  actor_base  ʒuǏ]AN^[
     */
    //-----------------------------------------------------------------------------
    void  Setup( const int index, const int id, const u32 max_dot, bool enable = true, actor::ActorBase* actor_base = NULL );

    //----------------------------------------------------------------------------
    /**
     *	@brief    XV
     */
    //-----------------------------------------------------------------------------
    void  Update( GraphicWork * pGraWork );

    //----------------------------------------------------------------------------
    /**
     *	@brief    vZ
     */
    //-----------------------------------------------------------------------------
    void  Calc( const int index, const u32 nowHP, const u32 maxHP );

  };

} //namespace sparring
} //namespace app

#endif //__SPARRING_HP_GAUGE_H__
