//============================================================================================
/**
 * @file		sparring_hp_gauge.cpp
 * @brief		HPQ[W֘A
 * @author	sogabe
 * @date		12.05.25
 */
//============================================================================================

#include  "sparring_hp_gauge.h"
#include  "app/tool/app_tool_Gauge.h"

namespace app {
namespace sparring {

#define GAUGE_VANISH_WAIT ( 6 )    //HPQ[W̃AjIĂ܂ł̃EGCg

//----------------------------------------------------------------------------
/**
 *	@brief    RXgN^
 *
 *	@param[in]  heap      q[v
 *	@param[in]  gauge_max ǗQ[W̍ő吔
 */
//-----------------------------------------------------------------------------
SparringHPGauge::SparringHPGauge( gfl::heap::HeapBase* heap, const s32 gauge_max )
{ 
  mGaugeParam = GFL_NEW( heap ) SparringHPGaugeParam[ gauge_max ];
  mGaugeMax   = gauge_max;
}

//----------------------------------------------------------------------------
/**
 *	@brief    fXgN^
 */
//-----------------------------------------------------------------------------
SparringHPGauge::~SparringHPGauge()
{ 
  GFL_DELETE_ARRAY( mGaugeParam );
}

//----------------------------------------------------------------------------
/**
 *	@brief    ZbgAbv
 *
 *	@param[in]  index       ǗCfbNX
 *	@param[in]  id          Q[WID
 *	@param[in]  max_dot     Q[W̍őhbg
 *	@param[in]  enable      XV邩ǂ
 *	@param[in]  actor_base  ʒuǏ]AN^[
 */
//-----------------------------------------------------------------------------
void  SparringHPGauge::Setup( const int index, const int id, const u32 max_dot, bool enable, actor::ActorBase* actor_base )
{ 
  GFL_ASSERT( index < mGaugeMax );
  mGaugeParam[ index ].enable     = enable;
  mGaugeParam[ index ].id         = id;
  mGaugeParam[ index ].max_dot    = max_dot;
  mGaugeParam[ index ].actor_base = actor_base;
  mGaugeParam[ index ].now_frame  = max_dot;
  mGaugeParam[ index ].end_frame  = max_dot;
}

//----------------------------------------------------------------------------
/**
 *	@brief    XV
 */
//-----------------------------------------------------------------------------
void  SparringHPGauge::Update( GraphicWork * pGraWork )
{ 
  for( s32 i = 0 ; i < mGaugeMax ; i++ )
  { 
    if( mGaugeParam[ i ].enable )
    { 
      if( mGaugeParam[ i ].now_frame == mGaugeParam[ i ].end_frame )
      { 
        mGaugeParam[ i ].enable = false;
        pGraWork->SetGaugeAnimeFrame( mGaugeParam[ i ].id, mGaugeParam[ i ].now_frame );
        if( mGaugeParam[ i ].actor_base )
        { 
          mGaugeParam[ i ].vanish_wait = GAUGE_VANISH_WAIT;
        }
      }
      else
      { 
        if( mGaugeParam[ i ].now_frame < mGaugeParam[ i ].end_frame ) mGaugeParam[ i ].now_frame++;
        if( mGaugeParam[ i ].now_frame > mGaugeParam[ i ].end_frame ) mGaugeParam[ i ].now_frame--;
        pGraWork->SetGaugeAnimeFrame( mGaugeParam[ i ].id, mGaugeParam[ i ].now_frame );
        if( mGaugeParam[ i ].actor_base )
        { 
          pGraWork->SetGaugePaneVisible( mGaugeParam[ i ].id, true );
          gfl::math::VEC3 pos = mGaugeParam[ i ].actor_base->GetTranslate();
          pos.y += 4.0f;
          pGraWork->SetGaugePanePos( mGaugeParam[ i ].id, pos );
        }
      }
    }
    else if( mGaugeParam[ i ].vanish_wait )
    { 
      gfl::math::VEC3 pos = mGaugeParam[ i ].actor_base->GetTranslate();
      pGraWork->SetGaugePanePos( mGaugeParam[ i ].id, pos );
      if( --mGaugeParam[ i ].vanish_wait == 0 )
      { 
        pGraWork->SetGaugePaneVisible( mGaugeParam[ i ].id, false );
      }
    }
  }
}

//----------------------------------------------------------------------------
/**
 *	@brief    vZ
 */
//-----------------------------------------------------------------------------
void  SparringHPGauge::Calc( const int index, const u32 nowHP, const u32 maxHP )
{ 
  mGaugeParam[ index ].enable = true;
  mGaugeParam[ index ].end_frame = app::tool::Gauge::GetDottoNum( nowHP, maxHP, mGaugeParam[ index ].max_dot );
}

} //namespace sparring
} //namespace app
