//============================================================================================
/**
 * @file		sparring_ui.cpp
 * @brief		UI֘A
 * @author	sogabe
 * @date		12.05.09
 *
 * namespace	app::sparring::
 *
 * 5279-6982		Avpev[gt@C쐬ꂽƂp^O
 */
//============================================================================================
#include "sparring_ui.h"


namespace app {
namespace sparring {


//--------------------------------------------------------------------------------------------
/**
 * @brief		RXgN^
 *
 * @param		heap		q[v
 */
//--------------------------------------------------------------------------------------------
UI::UI( app::util::Heap * heap )
{
	CreateUI( heap );
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		fXgN^
 */
//--------------------------------------------------------------------------------------------
UI::~UI()
{
	DeleteUI();
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		fobOpI{^擾
 *
 * @param		none
 *
 * @retval	"true = ꂽ"
 * @retval	"false = ȊO"
 */
//--------------------------------------------------------------------------------------------
bool UI::DEBUG_GetEndButton(void)
{
	return pButton->IsTrigger( gfl::ui::BUTTON_B );
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		UI֘A쐬
 *
 * @param		haap		q[v
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void UI::CreateUI( app::util::Heap * heap )
{
	gamesystem::GameManager * pgm = GFL_SINGLETON_INSTANCE( gamesystem::GameManager );
	pUiDeviceManager = pgm->GetUiDeviceManager();
	pButton     = pUiDeviceManager->GetButton( gfl::ui::CTR_DeviceManager::BUTTON_STANDARD );
	pKey        = pUiDeviceManager->GetCrossKey( gfl::ui::CTR_DeviceManager::CROSSKEY_STANDARD );
	pStick      = pUiDeviceManager->GetStick( gfl::ui::CTR_DeviceManager::STICK_STANDARD );
	pTouchPanel = pUiDeviceManager->GetTouchPanel( gfl::ui::CTR_DeviceManager::TOUCHPANEL_STANDARD );

#ifdef	USE_UI_GYROSCOPE
	// WC
	pUiDeviceManager->BootGyroscope( heap->pHeap, gfl::ui::CTR_DeviceManager::GYROSCOPE_STANDARD );
	pGyroscope  = pUiDeviceManager->GetGyroscope( gfl::ui::CTR_DeviceManager::GYROSCOPE_STANDARD );
	pGyroscope->SetZeroDriftMode( gfl::ui::Gyroscope::ZERO_DRIFT_MODE_TIGHT );
	pGyroscope->DisableRevisionByAcceleration();
	pGyroscope->DisableZeroDrift();
#endif	// USE_UI_GYROSCOPE

#ifdef	USE_UI_ACCELEROMETER
	// xZT[
	pUiDeviceManager->BootAccelerometer( heap->pHeap, gfl::ui::CTR_DeviceManager::ACCELEROMETER_STANDARD );
	pAccelerometer = pUiDeviceManager->GetAccelerometer( gfl::ui::CTR_DeviceManager::ACCELEROMETER_STANDARD );
#endif	// USE_UI_ACCELEROMETER
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		UI֘A폜
 *
 * @param		none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void UI::DeleteUI(void)
{
#ifdef	USE_UI_ACCELEROMETER
	pUiDeviceManager->StopAccelerometer( gfl::ui::CTR_DeviceManager::ACCELEROMETER_STANDARD );
#endif	// USE_UI_ACCELEROMETER
#ifdef	USE_UI_GYROSCOPE
	pUiDeviceManager->StopGyroscope( gfl::ui::CTR_DeviceManager::GYROSCOPE_STANDARD );
#endif	// USE_UI_GYROSCOPE
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		^b`
 *
 * @param		none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
bool UI::CheckTouchTrigger( u16* tx, u16* ty )
{ 
  bool  result = pTouchPanel->IsTouchTrigger();
  if( result )
  { 
    if( tx != NULL && ty != NULL )
    { 
      pTouchPanel->GetXY( tx, ty );
    }
  }
  return result;
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		L[z[h
 *
 * @param		none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
bool  UI::IsKeyHold( u32 key )
{ 
  return pKey->IsHold( key );
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		L[gK[
 *
 * @param		none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
bool  UI::IsKeyTrigger( u32 key )
{ 
  return pKey->IsTrigger( key );
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		L[s[g
 *
 * @param		none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
bool  UI::IsKeyRepeat( u32 key )
{ 
  return pKey->IsRepeat( key );
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		XChpbhړʎ擾
 *
 * @param		none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void  UI::GetVector( f32* x, f32* y )
{ 
  pStick->GetVector( x, y );
}

}		// sparring
}		// app
