//============================================================================================
/**
 * @file		sparring_pokemodel.h
 * @brief		Xp[O |Pf
 * @author	soga
 * @date		12.05.10
 *
 * namespace	app::sparring::
 */
//============================================================================================
#pragma	once

#include <gflib.h>
#include "poke_tool/poke_model_sys.h"


namespace app {
namespace sparring {

#define SPARRING_POKE_MODEL_MAX ( 8 ) //gp郂f̍ő吔̃ftHgl

class SparringPokeModel {
public:
	//------------------------------------------------------------------------------------------
	/**
	 * @brief		RXgN^
	 *
	 * @param		heap						q[v
	 * @param		allocator				AP[^
	 * @param		dev_allocator		foCXAP[^
	 * @param		man							t@Cǂݍ݃}l[W
	 * @param		scene						G3DV[
	 * @param   use_model_max   gp郂f̍ő吔
	 */
	//------------------------------------------------------------------------------------------
	SparringPokeModel(
		gfl::heap::HeapBase*      heap,
		gfl::heap::NwAllocator*   allocator,
		gfl::heap::NwAllocator*   dev_allocator,
		gfl::fs::FileReadManager* man,
	  gfl::grp::g3d::Scene*     scene,
    int                       use_model_max = SPARRING_POKE_MODEL_MAX );

	//------------------------------------------------------------------------------------------
	/**
	 * @brief		fXgN^
	 */
	//------------------------------------------------------------------------------------------
	virtual ~SparringPokeModel(void);

	//------------------------------------------------------------------------------------------
	/**
	 * @brief		Abvf[g
	 *
	 * @param		none
	 *
	 * @return	none
	 */
	//------------------------------------------------------------------------------------------
	void Update(void);

	//------------------------------------------------------------------------------------------
	/**
	 * @brief		Aj̃Abvf[g
	 *
	 * @param		none
	 *
	 * @return	none
	 */
	//------------------------------------------------------------------------------------------
	void UpdateAnime(void);

	//------------------------------------------------------------------------------------------
	/**
	 * @brief		`
	 *
	 * @param		none
	 *
	 * @return	none
	 */
	//------------------------------------------------------------------------------------------
//	void Draw(void);

	//------------------------------------------------------------------------------------------
	/**
	 * @brief		f쐬
	 *
	 * @param		cp			|Pp[^
	 * @param		scene		V[
	 *
	 * @return	fID
	 */
	//------------------------------------------------------------------------------------------
	int Create( const pml::pokepara::CoreParam * cp );
	int Create( const poke_tool::PokeModel::SimpleParam * sp );

	//------------------------------------------------------------------------------------------
	/**
	 * @brief		f폜
	 *
	 * @param		fID
	 *
	 * @return	none
	 */
	//------------------------------------------------------------------------------------------
	void Delete( int id );

	//------------------------------------------------------------------------------------------
	/**
	 * @brief		f폜
	 *
	 * @param		none
	 *
	 * @return	none
	 */
	//------------------------------------------------------------------------------------------
	void DeleteAll( void );

	//------------------------------------------------------------------------------------------
	/**
	 * @brief		\؂ւ
	 *
   * @param   id    fID
	 * @param		flg		true = \, false = \
	 *
	 * @return	none
	 */
	//------------------------------------------------------------------------------------------
	void SetVisible( int id, bool flg );

	//------------------------------------------------------------------------------------------
	/**
	 * @brief		NodeW擾
	 *
   * @param   id    fID
	 * @param		node	m[h
	 * @param		pos	  擾W
	 *
	 * @return	none
	 */
	//------------------------------------------------------------------------------------------
	void GetNodePostion( int id, poke_tool::POKEMODEL_NODE node, gfl::math::VEC3* pos );

private:
	//------------------------------------------------------------------------------------------
	/**
	 * @brief		f̓ǂݍ݂҂Ċef[^Zbg
	 *
	 * @param		pPokeModel  |Pf
	 *
	 * @return	none
	 */
	//------------------------------------------------------------------------------------------
	bool Setting( poke_tool::PokeModel* pPokeModel );

	//------------------------------------------------------------------------------------------
	/**
	 * @brief		V[֒ǉ
	 *
	 * @param		pPokeModel  |Pf
	 *
	 * @return	none
	 */
	//------------------------------------------------------------------------------------------
	void AddScene( poke_tool::PokeModel* pPokeModel );

	//------------------------------------------------------------------------------------------
	/**
	 * @brief		V[폜
	 *
	 * @param		pPokeModel  |Pf
	 *
	 * @return	none
	 */
	//------------------------------------------------------------------------------------------
	void RemoveScene( poke_tool::PokeModel* pPokeModel );


private:
	gfl::heap::HeapBase*    pHeap;
	gfl::heap::NwAllocator* pHeapAllocator;
	gfl::heap::NwAllocator* pDevHeapAllocator;

	poke_tool::PokeModelSystem* pPokeModelSystem;
	gfl::grp::g3d::Scene*       pScene;

  struct SPARRING_POKE_MODEL
  { 
	  poke_tool::PokeModel*     pPokeModel;
	  int	seq;
    SPARRING_POKE_MODEL( void ) :
    pPokeModel( NULL ),
    seq( 0 )
    {}
  };

  int                         mUseModelMax;
  SPARRING_POKE_MODEL*        arraySparringPokeModel;
};


}	// tool
}	// app
