//============================================================================================
/**
 * @file		sparring_pokemodel.cpp
 * @brief		Xp[O |Pf
 * @author	soga
 * @date		12.05.10
 *
 * namespace	app::sparring::
 */
//============================================================================================
#include "sparring_pokemodel.h"


namespace app {
namespace sparring {

//------------------------------------------------------------------------------------------
/**
 * @brief		RXgN^
 *
 * @param		heap						q[v
 * @param		allocator				AP[^
 * @param		dev_allocator		foCXAP[^
 * @param		man							t@Cǂݍ݃}l[W
 */
//------------------------------------------------------------------------------------------
SparringPokeModel::SparringPokeModel(
		gfl::heap::HeapBase*      heap,
		gfl::heap::NwAllocator*   allocator,
		gfl::heap::NwAllocator*   dev_allocator,
		gfl::fs::FileReadManager* man,
	  gfl::grp::g3d::Scene*     scene,
    int                       use_model_max )
{
	pPokeModelSystem = GFL_NEW( heap ) poke_tool::PokeModelSystem();
	pPokeModelSystem->InitSystem( allocator, dev_allocator, man );

	pHeap = heap;
	pHeapAllocator = allocator;
	pDevHeapAllocator = dev_allocator;
	pScene = scene;

  arraySparringPokeModel = GFL_NEW_ARRAY( heap ) SPARRING_POKE_MODEL[ use_model_max ];
  mUseModelMax = use_model_max;
}

//------------------------------------------------------------------------------------------
/**
 * @brief		fXgN^
 */
//------------------------------------------------------------------------------------------
SparringPokeModel::~SparringPokeModel(void)
{
	DeleteAll();

	pPokeModelSystem->ExitSystem();
	GFL_DELETE pPokeModelSystem;
  GFL_DELETE_ARRAY  arraySparringPokeModel;
}

//------------------------------------------------------------------------------------------
/**
 * @brief		Abvf[g
 *
 * @param		none
 *
 * @return	none
 */
//------------------------------------------------------------------------------------------
void SparringPokeModel::Update(void)
{
  for( s32 i = 0 ; i < mUseModelMax ; i++ )
  { 
	  if( arraySparringPokeModel[ i ].pPokeModel != NULL )
    {
		  switch( arraySparringPokeModel[ i ].seq ){
		  case 0:
			  if( Setting( arraySparringPokeModel[ i ].pPokeModel ) == true )
        {
				  AddScene( arraySparringPokeModel[ i ].pPokeModel );
				  arraySparringPokeModel[ i ].seq++;
			  }
			  break;
		  case 1:
		  default:
			  break;
		  }
	  }
  }
	pPokeModelSystem->UpdateSystem();
	pPokeModelSystem->UpdateModel();
}

//------------------------------------------------------------------------------------------
/**
 * @brief		Aj̃Abvf[g
 *
 * @param		none
 *
 * @return	none
 */
//------------------------------------------------------------------------------------------
void SparringPokeModel::UpdateAnime(void)
{
	pPokeModelSystem->UpdateModelAnime();
}

//------------------------------------------------------------------------------------------
/**
 * @brief		`
 *
 * @param		none
 *
 * @return	none
 */
//------------------------------------------------------------------------------------------
/*
void BoxPokeModel::Draw(void)
{
}
*/

/*
    void Model::SetupPokeModelParams( 
        const pml::pokepara::PokemonParam* poke_param,
        poke_tool::PokeModel* poke_model )
    {
      proj::motion::BaseMotionCharacter* motion_data = poke_model->GetMotionData();
      if( motion_data ) {
        motion_data->SetAttributeOn( proj::motion::Motion::M_ATTR_NO_IK );
      }
      poke_model->SetPosition( 0, 0.0f, 0 );
      poke_model->ChangeAnime( poke_tool::MODEL_ANIME_BT_WAIT_A );
      poke_model->PlayAnime(); 

      poke_model->SetScale( MODEL_COMMON_SCALE );

      // KvɂȂ郉Cg
      xy_system::PokemonShaderModel* shader_model = poke_model->GetShaderModel();
      shader_model->SetLightVec( gfl::math::VEC4(1, 0, 0, 1) );
      shader_model->SetLightColor( gfl::math::VEC4(1, 1, 1, 1) ); 
    }
*/

//------------------------------------------------------------------------------------------
/**
 * @brief		f쐬
 *
 * @param		cp			|Pp[^
 *
 * @return	fIDi-1Ősj
 */
//------------------------------------------------------------------------------------------
int SparringPokeModel::Create( const pml::pokepara::CoreParam * cp )
{
  for( s32 i = 0 ; i < mUseModelMax ; i++ )
  { 
    if( arraySparringPokeModel[ i ].pPokeModel == NULL )
    { 
	    poke_tool::PokeModel::SetupOption option;

	    option.useShaderModel = true;
//	option.isAsync = true;

//	option.anmType = poke_tool::MODEL_ANIME_TYPE_BATTLE;
//	option.useDaeFaceAnime = false;  // @todo ً}̂false
	    arraySparringPokeModel[ i ].pPokeModel =
      pPokeModelSystem->CreateModelCoreParam( cp, pHeapAllocator, pDevHeapAllocator, &option );
	    arraySparringPokeModel[ i ].seq = 0;
      return i;
    }
  }
  //Ɏs
  GFL_ASSERT( 0 );
  return -1;
}

//------------------------------------------------------------------------------------------
/**
 * @brief		f쐬
 *
 * @param		sp			|PVvp[^
 *
 * @return	fIDi-1Ősj
 */
//------------------------------------------------------------------------------------------
int SparringPokeModel::Create( const poke_tool::PokeModel::SimpleParam * sp )
{
  for( s32 i = 0 ; i < mUseModelMax ; i++ )
  { 
    if( arraySparringPokeModel[ i ].pPokeModel == NULL )
    { 
	    poke_tool::PokeModel::SetupOption option;

	    option.useShaderModel = true;
      option.anmType = poke_tool::MODEL_ANIME_TYPE_BATTLE;
	    arraySparringPokeModel[ i ].pPokeModel =
      pPokeModelSystem->CreateModelSimple( sp, pHeapAllocator, pDevHeapAllocator, &option );
	    arraySparringPokeModel[ i ].seq = 0;
      return i;
    }
  }
  //Ɏs
  GFL_ASSERT( 0 );
  return -1;
}

//------------------------------------------------------------------------------------------
/**
 * @brief		f폜
 *
 * @param		id    fID
 *
 * @return	none
 */
//------------------------------------------------------------------------------------------
void SparringPokeModel::Delete( int id )
{
  GFL_ASSERT( id >= 0 && id < mUseModelMax );
	if( arraySparringPokeModel[ id ].pPokeModel != NULL ){
		if( arraySparringPokeModel[ id ].seq >= 1 ){
			RemoveScene( arraySparringPokeModel[ id ].pPokeModel );
		}
		pPokeModelSystem->DeleteModel( arraySparringPokeModel[ id ].pPokeModel );
		arraySparringPokeModel[ id ].pPokeModel = NULL;
	}
}

//------------------------------------------------------------------------------------------
/**
 * @brief		f폜
 *
 * @param		none 
 *
 * @return	none
 */
//------------------------------------------------------------------------------------------
void SparringPokeModel::DeleteAll( void )
{ 
  for( s32 i = 0 ; i < mUseModelMax ; i++ )
  { 
    Delete( i );
  }
}

//------------------------------------------------------------------------------------------
/**
 * @brief		f̓ǂݍ݂҂Ċef[^Zbg
 *
 * @param		none
 *
 * @return	none
 */
//------------------------------------------------------------------------------------------
bool SparringPokeModel::Setting( poke_tool::PokeModel* pPokeModel )
{
	if( pPokeModel->IsFinishLoad() == false ){
		return false;
	}

	pPokeModel->SetAdjustScaleType( poke_tool::POKE_ADJUST_STATUS );

	proj::motion::BaseMotionCharacter* motion_data = pPokeModel->GetMotionData();
	if( motion_data ) {
		motion_data->SetAttributeOn( proj::motion::Motion::M_ATTR_NO_IK );
	}

	pPokeModel->SetPosition( 0.0f, 0.0f, 0.0f );
	pPokeModel->ChangeAnime( poke_tool::MODEL_ANIME_BT_WAIT_A );
	pPokeModel->PlayAnime();
	pPokeModel->SetIsLoop( true );
	pPokeModel->SetNodeFastMode();

	//const f32 MODEL_COMMON_SCALE = 1.14f;
	//pPokeModel->SetScale( MODEL_COMMON_SCALE );

	xy_system::PokemonShaderModel* shader_model = pPokeModel->GetShaderModel();
	shader_model->SetLightVec( gfl::math::VEC4(1, 0, 0, 1) );
	shader_model->SetLightColor( gfl::math::VEC4(1, 1, 1, 1) ); 

	return true;
}

//------------------------------------------------------------------------------------------
/**
 * @brief		V[֒ǉ
 *
 * @param		none
 *
 * @return	none
 */
//------------------------------------------------------------------------------------------
void SparringPokeModel::AddScene( poke_tool::PokeModel* pPokeModel )
{
	pPokeModel->AddScene( pScene );
	pScene->SwitchEdgeMapModel( pPokeModel->GetG3dModel(), true );
}

//------------------------------------------------------------------------------------------
/**
 * @brief		V[폜
 *
 * @param		none
 *
 * @return	none
 */
//------------------------------------------------------------------------------------------
void SparringPokeModel::RemoveScene( poke_tool::PokeModel* pPokeModel )
{
	if( pPokeModel != NULL ){
		pScene->SwitchEdgeMapModel( pPokeModel->GetG3dModel(), false );
		pPokeModel->RemoveScene( pScene );
	}
}

//------------------------------------------------------------------------------------------
/**
 * @brief		\؂ւ
 *
 * @param		flg		true = \, false = \
 *
 * @return	none
 */
//------------------------------------------------------------------------------------------
void SparringPokeModel::SetVisible( int id, bool flg )
{
	if( arraySparringPokeModel[ id ].pPokeModel != NULL ){
		arraySparringPokeModel[ id ].pPokeModel->SetVisible( flg );
	}
}

//------------------------------------------------------------------------------------------
/**
 * @brief		NodeW擾
 *
 * @param   id    fID
 * @param		node	m[h
 * @param		pos	  擾W
 *
 * @return	none
 */
//------------------------------------------------------------------------------------------
void SparringPokeModel::GetNodePostion( int id, poke_tool::POKEMODEL_NODE node, gfl::math::VEC3* pos )
{ 
	if( ( arraySparringPokeModel[ id ].pPokeModel != NULL ) && ( arraySparringPokeModel[ id ].seq != 0 ) )
  { 
	  bool ret = arraySparringPokeModel[ id ].pPokeModel->GetNodePosition( node, pos );
    GFL_ASSERT( ret == true );
  }
}


}	// tool
}	// app
