//============================================================================================
/**
 * @file		sparring_main.h
 * @brief		C
 * @author	sogabe
 * @date		12.05.09
 *
 * namespace	app::sparring::
 *
 * 5279-6982		Avpev[gt@C쐬ꂽƂp^O
 */
//============================================================================================
#pragma	once

#include "app/util/app_util_heap.h"
//#include "app/sparring/sparring.h"
#include "sparring.h"
#include "sparring_graphic.h"
#include "sparring_ui.h"

namespace actor { 
  class ActorManager;
  class ActorCollision;
}

namespace app {
namespace sparring {

// Tu[NiʑJڎɉj
typedef struct {
	GraphicWork * pGraWork;
	UI * ui;
}SUB_WORK;

// C[N
typedef struct {
	APP_PARAM * prm;

	int	mainSeq;
	int	nextSeq;
	int	fadeNextSeq;
}MAIN_WORK;

//Q[[N
typedef struct
{ 
  SUB_WORK*               sub_wk;
  actor::ActorManager*    actor_manager;
  actor::ActorCollision*  actor_collision;
  bool                    damage_req;
  bool                    shoot;
  u16                     tx;
  u16                     ty;
  bool                    hit;
  gfl::math::VEC3         hit_pos;
}SPARRING_GAME_WORK;

class MainSystem {
public:
	// Abvf[g̖߂l
	enum {
		UPDATE_CONTINUE = 0,
		UPDATE_FINISH,
	};

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		RXgN^
	 *
	 * @param		prm		Oݒp[^
	 */
	//--------------------------------------------------------------------------------------------
	MainSystem( APP_PARAM * prm );

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		fXgN^
	 */
	//--------------------------------------------------------------------------------------------
	~MainSystem();

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		Abvf[g
	 *
	 * @param		none
	 *
	 * @return	
	 */
	//--------------------------------------------------------------------------------------------
	int Update(void);

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		`揈
	 *
	 * @param		none
	 *
	 * @return	none
	 */
	//--------------------------------------------------------------------------------------------
	void Draw(void);

private:
	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		AvI
	 *
	 * @param		none
	 *
	 * @retval	"true = I"
	 * @retval	"false = ȊO"
	 */
	//--------------------------------------------------------------------------------------------
	bool BreakFunc(void);

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		Tu[N쐬
	 *
	 * @param		none
	 *
	 * @return	none
	 */
	//--------------------------------------------------------------------------------------------
	void CreateSubWork(void);

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		Xe[Wf[^ZbgAbv
	 *
	 * @param		none
	 *
	 * @return	none
	 */
	//--------------------------------------------------------------------------------------------
	void Setup(void);

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		Tu[N폜
	 *
	 * @param		none
	 *
	 * @return	none
	 */
	//--------------------------------------------------------------------------------------------
	void DeleteSubWork(void);

  //--------------------------------------------------------------------------------------------
  /**
   * @brief		Xe[Wf[^I
   *
   * @param		none
   *
   * @return	none
   */
  //--------------------------------------------------------------------------------------------
  void Finish( void );

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		tF[hCZbg
	 *
	 * @param		next		tF[h̃V[PX
	 *
	 * @return	MAINSEQ_FADE
	 */
	//--------------------------------------------------------------------------------------------
	int SetFadeIn( int next );

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		tF[hAEgZbg
	 *
	 * @param		next		tF[h̃V[PX
	 *
	 * @return	MAINSEQ_FADE
	 */
	//--------------------------------------------------------------------------------------------
	int SetFadeOut( int next );

// CV[PX
public:
	int MainSeq_Init(void);
	int MainSeq_Release(void);
	int MainSeq_Fade(void);
	int MainSeq_Main(void);

private:
  static  const int       mDamageFrame = 16;

	MAIN_WORK               mainWork;		// C[N
	SUB_WORK*               subWork;
  SPARRING_GAME_WORK      mSparringGameWork;
	app::util::Heap         heap;
  actor::ActorManager*    mActorManager;
  actor::ActorCollision*  mActorCollision;
  f32                     mPhi;
  f32                     mTheta;
  f32                     mRadius;
  gfl::math::VEC3         mCenter;
  gfl::math::VEC3         mOfs;
  int                     mDamage;
};

}		// sparring
}		// app
