//============================================================================================
/**
 * @file		sparring_main.cpp
 * @brief		C
 * @author	sogabe
 * @date		12.05.09
 *
 * namespace	app::sparring::
 *
 * 5279-6982		Avpev[gt@C쐬ꂽƂp^O
 */
//============================================================================================

#include  "system/gfl_use.h"
#include "sound/sound.h"
#include "sound/SoundMiddleID.h"
#include "sparring_main.h"
#include "gamesystem/ForcedReturnManager.h"

#include "../actor/actor_manager.h"
#include "../actor/actor_collision.h"
#include "../actor/actor_factory.h"
#include "../actor/actor_resource_manager.h"
#include "../actor/actor_poke_model.h"
#include "../actor/sparring_enemy_actor.h"
#include "../actor/sparring_act_def.h"


namespace app {
namespace sparring {


//============================================================================================
//	萔`
//============================================================================================
// CV[PX`
enum {
	MAINSEQ_INIT = 0,
	MAINSEQ_RELEASE,
	MAINSEQ_FADE,
	MAINSEQ_MAIN,
	MAINSEQ_END
};

typedef int (MainSystem::*pSeqFunc)(void);


static const u32 SPARRING_APP_HEAP_SIZE = 0x50000;			// Avp[Jq[vTCY
static const u32 SPARRING_DEVICE_HEAP_SIZE = 0x500000;		// Avp[JfoCXq[vTCY

static const u32 SPARRING_ACTOR_MAX = 100;		  // ǗAN^[ő吔
static const u32 SPARRING_COLLISION_MAX = 16;	  // 蔻o^ő吔

static const u32 SPARRING_FADE_SYNC = 8;		// tF[hx

// CV[PX֐e[u
static const pSeqFunc MainSeq[] = {
	&MainSystem::MainSeq_Init,
	&MainSystem::MainSeq_Release,
	&MainSystem::MainSeq_Fade,
	&MainSystem::MainSeq_Main,
};



//--------------------------------------------------------------------------------------------
/**
 * @brief		RXgN^
 *
 * @param		prm		Oݒp[^
 */
//--------------------------------------------------------------------------------------------
MainSystem::MainSystem( APP_PARAM * prm ) :
	subWork( NULL ),
  mPhi( 0.0f ),
  mTheta( 90.0f ),
  mRadius( 200.0f ),
  mCenter( 0.0f, 5.0f, 0.0f ),
  mOfs( 0.0f, 0.0f, 0.0f ),
  mDamage( 0.0f )
{
	mainWork.prm = prm;
	mainWork.mainSeq = MAINSEQ_INIT;
  mSparringGameWork.sub_wk = NULL;
  mSparringGameWork.actor_manager = NULL;
  mSparringGameWork.damage_req = false;
  mSparringGameWork.shoot = false;
  mSparringGameWork.tx = 0;
  mSparringGameWork.ty = 0;
  mSparringGameWork.hit = false;
  mSparringGameWork.hit_pos.Set( 0.0f, 0.0f, 0.0f );
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		fXgN^
 */
//--------------------------------------------------------------------------------------------
MainSystem::~MainSystem()
{
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		Abvf[g
 *
 * @param		none
 *
 * @return	
 */
//--------------------------------------------------------------------------------------------
int MainSystem::Update(void)
{
	MAIN_WORK * mwk = &mainWork;
	SUB_WORK * swk = subWork;

	if( BreakFunc() == true ){
		return UPDATE_FINISH;
	}

	mwk->mainSeq = (this->*MainSeq[mwk->mainSeq])();

	if( mwk->mainSeq == MAINSEQ_END ){
		return UPDATE_FINISH;
	}

  if( mDamage )
  { 
    mDamage--;
    mOfs.Set( 0.0f, 0.0f, 0.0f );
    if( mDamage )
    { 
      u32 value = xy_system::GflUse::GetPublicRand( 4 );
      f32 shake = ( value & 1 ) ? 2.0f : -2.0f;
      switch( value / 2 ){ 
      case 0:
        mOfs.x = shake;
        break;
      case 1:
        mOfs.y = shake;
        break;
      }
    }
  }

	if( swk != NULL ){
    gfl::math::VEC3 pos;
    pos = mCenter + mOfs;
    swk->pGraWork->SetCameraPosition( mPhi, mTheta, mRadius, &pos, false );
    bool  result;
    u16 tx, ty;
    result = swk->ui->CheckTouchTrigger( &tx, &ty );
		swk->pGraWork->Update( result, tx, ty );
	}

	return UPDATE_CONTINUE;
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		`揈
 *
 * @param		none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void MainSystem::Draw(void)
{
	SUB_WORK * swk = subWork;

	if( swk == NULL ){
		return;
	}

	subWork->pGraWork->Draw();
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		AvI
 *
 * @param		none
 *
 * @retval	"true = I"
 * @retval	"false = ȊO"
 */
//--------------------------------------------------------------------------------------------
bool MainSystem::BreakFunc(void)
{
	if( GFL_SINGLETON_INSTANCE(gamesystem::ForcedReturnManager)->IsReturn( gamesystem::ForcedReturnManager::FORCERETURN_APP ) == true ){
		if( subWork != NULL ){
			/* ʂŃmۂꍇ͂ɒǉ */
			MainSeq_Release();
		}
		return true;
	}
	return false;
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		Tu[N쐬
 *
 * @param		none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void MainSystem::CreateSubWork(void)
{
  int app_size = gfl::heap::Manager::GetHeapByHeapId(HEAPID_APP)->GetTotalAllocatableSize();
  int dev_size = gfl::heap::Manager::GetHeapByHeapId(HEAPID_APP_DEVICE)->GetTotalAllocatableSize();
	//heap.Create( HEAPID_SPARRING_APP, SPARRING_APP_HEAP_SIZE, HEAPID_SPARRING_DEVICE, SPARRING_DEVICE_HEAP_SIZE );
	heap.Create( HEAPID_SPARRING_APP, app_size, HEAPID_SPARRING_DEVICE, dev_size );

	subWork = GFL_NEW( heap.pHeap )	SUB_WORK;

	subWork->ui = GFL_NEW( heap.pHeap )	UI( &heap );

	subWork->pGraWork = GFL_NEW( heap.pHeap ) GraphicWork( &heap, mainWork.prm->gameManager->GetFileReadManager() );

}

//--------------------------------------------------------------------------------------------
/**
 * @brief		Xe[Wf[^ZbgAbv
 *
 * @param		none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void MainSystem::Setup( void )
{ 
  mActorManager = GFL_NEW( heap.pHeap ) actor::ActorManager( heap.pHeap, SPARRING_ACTOR_MAX, actor::ACT_SPARRING_MAX );
  mActorCollision = GFL_NEW( heap.pHeap ) actor::ActorCollision( heap.pHeap, SPARRING_COLLISION_MAX );
  actor::ActorResourceManager* act_res_mgr = GFL_NEW_LOW( heap.pHeap ) actor::ActorResourceManager( heap.pHeap,
                                                                                                    ARCID_SPARRING,
                                                                                                    ARCID_SPARRING_ACT_DAT,
                                                                                                    actor::ACT_SPARRING_MAX,
                                                                                                    ARCID_SPARRING_ANM_DAT );
  actor::ActorFactory* factory = GFL_NEW_LOW( heap.pHeap ) actor::ActorFactory( subWork->pGraWork->GetG3DUtil(),
                                                                                &heap,
                                                                                mActorManager,
                                                                                act_res_mgr );
#if 1
  //{X
  { 
    factory->CreateActor( actor::ACT_SPARRING_BOSS );
    actor::ActorBase* actor_base = mActorManager->GetActorBaseWithSysID( actor::ACT_SPARRING_BOSS, 0 );
    actor::ActorPokeModel* poke_model = GFL_NEW( heap.pHeap ) actor::ActorPokeModel();
    const poke_tool::PokeModel::SimpleParam sp = {  
      MONSNO_MARAKATTI,
      0,
      pml::SEX_MALE,   // IX
      0,
      false,
      0,          //pb`[p
    };
    poke_model->CreateModel( subWork->pGraWork->GetPokeModelSystem(),
                             subWork->pGraWork->GetG3DUtil()->GetScene(),
                             heap.pHeapAllocator, heap.pDevHeapAllocator,
                             &sp );
    actor_base->SetModel( poke_model );
    actor_base->SetAnime( 0 );
    actor_base->SetVisible( true );
    gfl::grp::ColorF32 col = gfl::grp::ColorF32( 0.2f, 0.2f, 0.2f, 0.0f );
    actor_base->SetConstantColor( col );
    mActorManager->AddSceneActor( actor::ACT_SPARRING_BOSS, 0 );
  }

  //e
  { 
    for( s32 i = 0 ; i < 8 ; i++ )
    { 
      factory->CreateActor( actor::ACT_SPARRING_SWB );
    }
    for( s32 i = 0 ; i < 8 ; i++ )
    { 
      factory->CreateActor( actor::ACT_SPARRING_SWP );
    }
    for( s32 i = 0 ; i < 8 ; i++ )
    { 
      factory->CreateActor( actor::ACT_SPARRING_MINE );
    }
  }

  //UR
  { 
    gfl::math::VEC3 pos[ 3 ] = {  
      gfl::math::VEC3( -30.0f, 30.0f, 60.0f ),
      gfl::math::VEC3(   0.0f, 30.0f, 60.0f ),
      gfl::math::VEC3(  30.0f, 30.0f, 60.0f ),
    };
    for( s32 i = 0 ; i < 3 ; i++ )
    { 
      factory->CreateActor( actor::ACT_SPARRING_ZAKO );
      mActorManager->AddSceneActor( actor::ACT_SPARRING_ZAKO, i );
      actor::SparringEnemyActor* enemy_actor = ( actor::SparringEnemyActor* )mActorManager->GetActorBaseWithSysID( actor::ACT_SPARRING_ZAKO, i );
      enemy_actor->GenerateTypeFly( pos[ i ], 10.0f );
      enemy_actor->SetAnime( 0 );
    }
  }
#else
  for( s32 i = 0 ; i < 8 ; i++ )
  { 
    factory->CreateActor( actor::ACT_SPARRING_MINE );
  }
#endif

  GFL_DELETE factory;
  GFL_DELETE act_res_mgr;
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		Tu[N폜
 *
 * @param		none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void MainSystem::DeleteSubWork(void)
{
	GFL_DELETE	subWork->pGraWork;

	GFL_DELETE	subWork->ui;
	GFL_DELETE	subWork;
	subWork = NULL;

	heap.Delete();
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		Xe[Wf[^I
 *
 * @param		none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void MainSystem::Finish( void )
{ 
  GFL_DELETE  mActorManager;
  GFL_DELETE  mActorCollision;
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		tF[hCZbg
 *
 * @param		next		tF[h̃V[PX
 *
 * @return	MAINSEQ_FADE
 */
//--------------------------------------------------------------------------------------------
int MainSystem::SetFadeIn( int next )
{
	gfl::math::VEC4	col( 0.0f, 0.0f, 0.0f, 1.0f );
	gfl::grp::Fade_ForceOut( gfl::grp::Fade::DISP_DOUBLE, &col );
	gfl::grp::Fade_RequestIn( gfl::grp::Fade::DISP_DOUBLE, SPARRING_FADE_SYNC );
	mainWork.fadeNextSeq = next;
	return MAINSEQ_FADE;
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		tF[hAEgZbg
 *
 * @param		next		tF[h̃V[PX
 *
 * @return	MAINSEQ_FADE
 */
//--------------------------------------------------------------------------------------------
int MainSystem::SetFadeOut( int next )
{
	gfl::grp::Fade_RequestOut( gfl::grp::Fade::DISP_DOUBLE, gfl::grp::Fade::OUTTYPE_BLACK, SPARRING_FADE_SYNC, false );
	mainWork.fadeNextSeq = next;
	return MAINSEQ_FADE;
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		CV[PXF
 *
 * @param		none
 *
 * @return	̃V[PX
 *
 *	`FMAINSEQ_INIT
 */
//--------------------------------------------------------------------------------------------
int MainSystem::MainSeq_Init(void)
{
	CreateSubWork();
  Setup();

  mSparringGameWork.sub_wk          = subWork;
  mSparringGameWork.actor_manager   = mActorManager;
  mSparringGameWork.actor_collision = mActorCollision;

  xy_snd::StartBGM( STRM_BGM_VS_NORAPOKE );

	return SetFadeIn( MAINSEQ_MAIN );
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		CV[PXF
 *
 * @param		none
 *
 * @return	̃V[PX
 *
 *	`FMAINSEQ_RELEASE
 */
//--------------------------------------------------------------------------------------------
int MainSystem::MainSeq_Release(void)
{
  Finish();
	DeleteSubWork();

  xy_snd::StopBGM( 32 );

	return mainWork.nextSeq;
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		CV[PXFtF[h҂
 *
 * @param		none
 *
 * @return	̃V[PX
 *
 *	`FMAINSEQ_FADE
 */
//--------------------------------------------------------------------------------------------
int MainSystem::MainSeq_Fade(void)
{
	if( gfl::grp::Fade_IsEnd() == true ){
		return mainWork.fadeNextSeq;
	}
	return MAINSEQ_FADE;
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		CV[PXFC
 *
 * @param		none
 *
 * @return	̃V[PX
 *
 *	`FMAINSEQ_MAIN
 */
//--------------------------------------------------------------------------------------------
int MainSystem::MainSeq_Main(void)
{
	if( subWork->ui->DEBUG_GetEndButton() == true ){
		mainWork.nextSeq = MAINSEQ_END;
		return SetFadeOut( MAINSEQ_RELEASE );
	}

  mSparringGameWork.shoot = subWork->ui->CheckTouchTrigger( &mSparringGameWork.tx, &mSparringGameWork.ty );

  mActorManager->Run( &mSparringGameWork );

  if( mSparringGameWork.damage_req )
  { 
    mSparringGameWork.damage_req = false;
    subWork->pGraWork->StartAnime2D( 17 );
    mDamage = mDamageFrame;
  }
  if( ( mSparringGameWork.shoot ) &&
      ( mActorManager->GetRegistTotal( actor::ACT_SPARRING_MINE ) > mActorManager->GetRentalTotal( actor::ACT_SPARRING_MINE ) ) )
  { 
    gfl::math::VEC3 dst;
    gfl::math::VEC3 cam_pos;
    subWork->pGraWork->GetCameraPosition( cam_pos );
    if( mSparringGameWork.hit )
    { 
      mSparringGameWork.hit = false;
      dst = mSparringGameWork.hit_pos;
    }
    else
    { 
      s32 scr_x = ( ( mSparringGameWork.tx - 160 ) / 0.8 ) + 200;
      s32 scr_y = mSparringGameWork.ty;
      gfl::math::VEC3 pos;
      subWork->pGraWork->ConvertPosScreenToWorld( &pos, scr_x, scr_y );
      dst = pos - cam_pos; 
      gfl::math::VEC3Normalize( &dst, &dst );
      dst *= gfl::math::VEC3Len( &cam_pos ) * 0.75f;
      dst += cam_pos;
    }
    s32 sysID = mActorManager->AddSceneActor( actor::ACT_SPARRING_MINE, 0 );
    actor::SparringEnemyActor* enemy_actor = ( actor::SparringEnemyActor* )mActorManager->GetActorBaseWithSysID( actor::ACT_SPARRING_MINE, sysID );
    enemy_actor->GenerateTypeMine( cam_pos, dst, 4.0f, 4.0f );
    enemy_actor->SetAnime( 0 );
    s32 index = mActorCollision->RegistCollisionTable( enemy_actor );
    enemy_actor->SetCollisionIndex( index );
  }

#if 0
  mRadius += -1.0f * ( subWork->ui->IsKeyHold( gfl::ui::BUTTON_UP ) && mRadius >= 100.0f ) +
              1.0f * ( subWork->ui->IsKeyHold( gfl::ui::BUTTON_DOWN ) && mRadius <= 300.0f );
  mTheta  += -1.0f * ( subWork->ui->IsKeyHold( gfl::ui::BUTTON_RIGHT ) && mTheta >= 45.0f ) +
              1.0f * ( subWork->ui->IsKeyHold( gfl::ui::BUTTON_LEFT ) && mTheta <= 135.0f );
#else
  { 
    f32 sx, sy;
    subWork->ui->GetVector( &sx, &sy );
    mRadius -= sy * 2;
    mTheta -= sx * 2;
    if( mRadius < 100.0f ) mRadius = 100.0f;
    if( mRadius > 300.0f ) mRadius = 300.0f;
    if( mTheta < 45.0f ) mTheta = 45.0f;
    if( mTheta > 135.0f ) mTheta = 135.0f;
  }
#endif

	return MAINSEQ_MAIN;
}


}		// sparring
}		// app

