//============================================================================================
/**
 * @file		sparring_graphic.h
 * @brief		OtBbN֘A
 * @author	sogabe
 * @date		12.05.09
 *
 * namespace	app::sparring::
 *
 * 5279-6982		Avpev[gt@C쐬ꂽƂp^O
 */
//============================================================================================
#pragma	once

#include "app/util/app_util_heap.h"
#include "app/util/app_util_2d.h"
#include "app/util/app_util_3d.h"

namespace app {
namespace sparring {


class GraphicWork {
public:
	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		RXgN^
	 *
	 * @param		heap		q[v
	 */
	//--------------------------------------------------------------------------------------------
  GraphicWork( app::util::Heap * heap, gfl::fs::FileReadManager* fr_man );

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		fXgN^
	 */
	//--------------------------------------------------------------------------------------------
	~GraphicWork();

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		Abvf[g
	 *
	 * @param		none
	 *
	 * @return	none
	 */
	//--------------------------------------------------------------------------------------------
  void Update( bool result, u16 tx, u16 ty );

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		`
	 *
	 * @param		none
	 *
	 * @return	none
	 */
	//--------------------------------------------------------------------------------------------
	void Draw(void);

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		[hWXN[Wɕϊ
	 *
	 * @param		none
	 *
	 * @return	none
	 */
	//--------------------------------------------------------------------------------------------
  void  ConvertPosWorldToScreen( const gfl::math::VEC3 pos, s32* scr_x, s32* scr_y );

  //--------------------------------------------------------------------------------------------
  /**
   * @brief   XN[W[hWɕϊ
   *
   * @param		none
   *
   * @return	none
   */
  //--------------------------------------------------------------------------------------------
  void  ConvertPosScreenToWorld( gfl::math::VEC3* pos, const s32 scr_x, const s32 scr_y );

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		J|WVZbg
	 *
	 * @param		none
	 *
	 * @return	none
	 */
	//--------------------------------------------------------------------------------------------
	void SetCameraPosition( gfl::math::VEC3* pos );

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		J|WVZbg
	 *
	 * @param		none
	 *
	 * @return	none
	 */
	//--------------------------------------------------------------------------------------------
  void SetCameraPosition( f32 phi, f32 theta, f32 radius, gfl::math::VEC3* center, bool target = true );

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		J^[QbgZbg
	 *
	 * @param		none
	 *
	 * @return	none
	 */
	//--------------------------------------------------------------------------------------------
	void SetTargetPosition( gfl::math::VEC3* tar );

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		J|WV&^[QbgZbg
	 *
	 * @param		none
	 *
	 * @return	none
	 */
	//--------------------------------------------------------------------------------------------
	void SetCameraAndTargetPosition( gfl::math::VEC3* pos, gfl::math::VEC3* tar );

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		J|WVQbg
	 *
	 * @param		none
	 *
	 * @return	none
	 */
	//--------------------------------------------------------------------------------------------
  void GetCameraPosition( gfl::math::VEC3& pos );

  //--------------------------------------------------------------------------------------------
  /**
   * @brief		J|WV&^[QbgQbg
   *
   * @param		none
   *
   * @return	none
   */
  //--------------------------------------------------------------------------------------------
  void GetCameraAndTargetPosition( gfl::math::VEC3& pos, gfl::math::VEC3& tar );

  //--------------------------------------------------------------------------------------------
  /**
   * @brief		2DAjĐ
   *
   * @param		none
   *
   * @return	none
   */
  //--------------------------------------------------------------------------------------------
  void StartAnime2D( const int anm_no );

  //--------------------------------------------------------------------------------------------
  /**
  * @brief		^[QbgyC|WVZbg
  *
  * @param[in] id    yCID
  * @param[in] pos   Zbg|WV
  *
  * @return	none
  */
  //--------------------------------------------------------------------------------------------
  void SetTargetPanePos( const int id, gfl::math::VEC3& pos );

  //--------------------------------------------------------------------------------------------
  /**
  * @brief		^[QbgyCrWuZbg
  *
  * @param[in] id    yCID
  * @param[in] value ZbgrWu
  *
  * @return	none
  */
  //--------------------------------------------------------------------------------------------
  void SetTargetPaneVisible( const int id, const bool  value );

  app::util::G3DUtil* GetG3DUtil( void ) { return pG3dUtil; } 
  poke_tool::PokeModelSystem* GetPokeModelSystem( void ) { return pPokeModelSystem; } 

private:
	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		OtBbNVXe쐬
	 *
	 * @param		heap		q[v
	 *
	 * @return	none
	 */
	//--------------------------------------------------------------------------------------------
	void CreateGraphicsSystem( app::util::Heap * heap );

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		OtBbNVXe폜
	 *
	 * @param		none
	 *
	 * @return	none
	 */
	//--------------------------------------------------------------------------------------------
	void DeleteGraphicsSystem(void);

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		2D֘A쐬
	 *
	 * @param		heap		q[v
	 *
	 * @return	none
	 */
	//--------------------------------------------------------------------------------------------
	void Create2D( app::util::Heap * heap );

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		2D֘A폜
	 *
	 * @param		none
	 *
	 * @return	none
	 */
	//--------------------------------------------------------------------------------------------
	void Delete2D(void);

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		3D֘A쐬
	 *
	 * @param		heap		q[v
	 *
	 * @return	none
	 */
	//--------------------------------------------------------------------------------------------
	void Create3D( app::util::Heap * heap );

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		3D֘A폜
	 *
	 * @param		none
	 *
	 * @return	none
	 */
	//--------------------------------------------------------------------------------------------
	void Delete3D(void);

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		|Pf֘A쐬
	 *
	 * @param		heap		q[v
	 * @param		fr_mann	t@C[h}l[W
	 *
	 * @return	none
	 */
	//--------------------------------------------------------------------------------------------
	void CreatePokeModel( app::util::Heap * heap, gfl::fs::FileReadManager* fr_man );

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		|Pf֘A폜
	 *
	 * @param		none
	 *
	 * @return	none
	 */
	//--------------------------------------------------------------------------------------------
	void DeletePokeModel(void);

private:
	gfl::grp::GraphicsSystem*   pGraSystem;	      // OtBbNVXe
	app::util::G2DUtil*         pG2dUtil;					// 2D֘A
	app::util::G3DUtil*         pG3dUtil;					// 3D֘A
	poke_tool::PokeModelSystem* pPokeModelSystem; // |Pf

};


}	// sparring
}	// app
