//============================================================================================
/**
 * @file		sparring_graphic.cpp
 * @brief		OtBbN֘A
 * @author	sogabe
 * @date		12.05.09
 *
 * namespace	app::sparring::
 *
 * 5279-6982		Avpev[gt@C쐬ꂽƂp^O
 */
//============================================================================================
#include "arc/arc_def.h"
#include "sparring_graphic.h"
#include "nakahiro_test_res.gaix"
#include "battle_3d.gaix"
//#include "message/msg_sparring.h"
#include "upper.h"
#include "upper_pane.h"
#include "lower.h"
#include "lower_pane.h"


namespace app {
namespace sparring {

static const u32 SPARRING_MODEL_DATA_MAX = 100;		// ff[^o^

#define POKE_SHADER_GROUP(idx) \
  SCENE_DRAW_GROUP_POKE ## idx ## _SHADER1, \
  SCENE_DRAW_GROUP_POKE ## idx ## _SHADER2, \
  SCENE_DRAW_GROUP_POKE ## idx ## _SHADER3, \
  SCENE_DRAW_GROUP_POKE ## idx ## _SHADER4

//DRAW_GROUP
enum {
	SCENE_DRAW_GROUP_MODEL,         // f
	SCENE_DRAW_GROUP_EDGE_MAP,      // GbW}bv
	SCENE_DRAW_GROUP_POST_EFFECT,   // |XgGtFNg

  POKE_SHADER_GROUP(1),           // |PVF[_[i\|PKvɂȂjƂ肠P̕

	SCENE_DRAW_GROUP_NUM
};

#define OWN_MODEL_NUM_MAX ( 128 )

enum
{ 
  ANM_AIM00,
  ANM_AIM01,
  ANM_AIM02,
  ANM_AIM03,
  ANM_AIM04,
  ANM_AIM05,
  ANM_AIM06,
  ANM_AIM07,
  ANM_HIT00,
  ANM_HIT01,
  ANM_HIT02,
  ANM_HIT03,
  ANM_HIT04,
  ANM_HIT05,
  ANM_HIT06,
  ANM_HIT07,
  ANM_NO_DAMAGE,
  ANM_DAMAGE,
};

static  const gfl::grp::g2d::LytPaneIndex TargetPaneTable[] =
{ 
  PANENAME_UPPER_PANE_TARGET_00,
  PANENAME_UPPER_PANE_TARGET_01,
  PANENAME_UPPER_PANE_TARGET_02,
  PANENAME_UPPER_PANE_TARGET_03,
  PANENAME_UPPER_PANE_TARGET_04,
  PANENAME_UPPER_PANE_TARGET_05,
  PANENAME_UPPER_PANE_TARGET_06,
  PANENAME_UPPER_PANE_TARGET_07,
};

//--------------------------------------------------------------------------------------------
/**
 * @brief		RXgN^
 *
 * @param		heap		q[v
 */
//--------------------------------------------------------------------------------------------
GraphicWork::GraphicWork( app::util::Heap * heap, gfl::fs::FileReadManager* fr_man )
{
	CreateGraphicsSystem( heap );

	Create2D( heap );
	Create3D( heap );
	CreatePokeModel( heap, fr_man );
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		fXgN^
 */
//--------------------------------------------------------------------------------------------
GraphicWork::~GraphicWork()
{
  DeletePokeModel();
	Delete3D();
	Delete2D();

	DeleteGraphicsSystem();
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		Abvf[g
 *
 * @param		none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void GraphicWork::Update( bool result, u16 tx, u16 ty )
{
	pG2dUtil->Update2D();
	pG3dUtil->CalculateG3dScene();
	pPokeModelSystem->UpdateSystem();
	pPokeModelSystem->UpdateModel();
	pPokeModelSystem->UpdateModelAnime();
	pG3dUtil->Update3D( false );
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		`
 *
 * @param		none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void GraphicWork::Draw(void)
{
	pG3dUtil->Draw3D( pGraSystem );
  pPokeModelSystem->DrawSystem( pGraSystem, pG3dUtil->GetUpperCamera() );
	pG2dUtil->Draw2D( pGraSystem, 0 );
	pG2dUtil->Draw2D( pGraSystem, 1 );
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		OtBbNVXe쐬
 *
 * @param		heap		q[v
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void GraphicWork::CreateGraphicsSystem( app::util::Heap * heap )
{
	gamesystem::GameManager * gm = GFL_SINGLETON_INSTANCE( gamesystem::GameManager );
	pGraSystem = gm->GetGraphicsSystem();
	pGraSystem->InitializeApplicationMemory( heap->pDevHeapAllocator );
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		OtBbNVXe폜
 *
 * @param		none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void GraphicWork::DeleteGraphicsSystem(void)
{
	pGraSystem->FinalizeApplicationMemory();
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		2D֘A쐬
 *
 * @param		heap		q[v
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void GraphicWork::Create2D( app::util::Heap * heap )
{
	pG2dUtil = GFL_NEW( heap->pHeap ) app::util::G2DUtil( heap );

	// \[Xf[^e[u
	static const app::util::G2DUtil::LYT_RES_DATA resTbl[] =
	{
    { ARCID_SPARRING, 0, 0 },
    { ARCID_SPARRING, 1, 0 },
	};

	// Ajf[^
	static const gfl::grp::g2d::LytArcIndex UpperAnmIndex[] =
  { 
    LYTRES_UPPER_UPPER_AIM00_BCLAN,
    LYTRES_UPPER_UPPER_AIM01_BCLAN,
    LYTRES_UPPER_UPPER_AIM02_BCLAN,
    LYTRES_UPPER_UPPER_AIM03_BCLAN,
    LYTRES_UPPER_UPPER_AIM04_BCLAN,
    LYTRES_UPPER_UPPER_AIM05_BCLAN,
    LYTRES_UPPER_UPPER_AIM06_BCLAN,
    LYTRES_UPPER_UPPER_AIM07_BCLAN,
    LYTRES_UPPER_UPPER_HIT00_BCLAN,
    LYTRES_UPPER_UPPER_HIT01_BCLAN,
    LYTRES_UPPER_UPPER_HIT02_BCLAN,
    LYTRES_UPPER_UPPER_HIT03_BCLAN,
    LYTRES_UPPER_UPPER_HIT04_BCLAN,
    LYTRES_UPPER_UPPER_HIT05_BCLAN,
    LYTRES_UPPER_UPPER_HIT06_BCLAN,
    LYTRES_UPPER_UPPER_HIT07_BCLAN,
    LYTRES_UPPER_UPPER_NODAMAGE_BCLAN,
    LYTRES_UPPER_UPPER_DAMAGE_BCLAN,
  };

	// CAEgf[^
	static const app::util::G2DUtil::LYTWK_DATA layoutData[] =
	{
		{	// 
			0,
      LYTRES_UPPER_UPPER_BCLYT,		                    // resID̃CAEgf[^ID
			UpperAnmIndex,																	// Aj[Vf[^IDe[u	AĵȂꍇNULL
			GFL_NELEMS( UpperAnmIndex ),										// Aj[Vf[^IDe[u AĵȂꍇ0
			GFL_NELEMS( UpperAnmIndex ),										// o^Aj[Vő吔
			false,																					// \yCɍsvZs
			app::util::G2DUtil::SETUP_UPPER,								// fBXvC
			true,																						// \ݒ
		},
		{	// 
			1,
      LYTRES_LOWER_LOWER_BCLYT,
			NULL,
			0,
			0,
			false,
			app::util::G2DUtil::SETUP_LOWER,
			true,
		},
	};

	pG2dUtil->CreateLayoutSystem( heap );
//	pG2dUtil->SetDefaultFont( const char * file );
	pG2dUtil->CreateLayoutEnv( heap, false );
  pG2dUtil->CreateLayoutWork( resTbl, GFL_NELEMS( resTbl ), GFL_NELEMS( layoutData ), heap, true );
	pG2dUtil->SetLayoutWork( layoutData, 0, GFL_NELEMS(layoutData) );
//	pG2dUtil->CreateMessageData( const wchar_t * arcFilePath, u32 datID, gfl::str::MsgData::LoadType loadType, Heap * heap );
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		2D֘A폜
 *
 * @param		none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void GraphicWork::Delete2D(void)
{
//	pG2dUtil->DeleteMessageData();
	pG2dUtil->DeleteLayoutResource();
	pG2dUtil->DeleteLayoutWork2();
	pG2dUtil->DeleteLayoutEnv();
	pG2dUtil->DeleteLayoutSystem();

	GFL_DELETE	pG2dUtil;
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		3D֘A쐬
 *
 * @param		heap		q[v
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void GraphicWork::Create3D( app::util::Heap * heap )
{
	pG3dUtil = GFL_NEW( heap->pHeap ) app::util::G3DUtil();

	pG3dUtil->CreateG3dSystem( heap );
  { 
	  gfl::grp::g3d::Scene::Description desc;
	  desc.own_model_num_max    = OWN_MODEL_NUM_MAX;
	  desc.scene_draw_group_num = SCENE_DRAW_GROUP_NUM;
	  pG3dUtil->CreateG3dScene( ARCID_BATTLE_3D, GARC_battle_3d_SceneEnvironment_BCENV, heap, false, &desc );
  }

	const app::util::G3DUtil::CAMERA_CREATE_DATA dat[] =
	{
		{	// 
			gfl::math::VEC3( 0.0f,  2.0f, 200.0f ),
			gfl::math::VEC3( 0.0f, 50.0f,   0.0f ),
			gfl::grp::g3d::Camera::NEAR_CLIP_DEFAULT,
			gfl::grp::g3d::Camera::FAR_CLIP_DEFAULT,
			gfl::grp::g3d::Camera::FOVY_RADIAN_DEFAULT,
			0.0f,
			gfl::grp::g3d::Camera::NEAR_CLIP_DEFAULT + 5.0f,
			1.0f,
			false
		},
		{	// 
			gfl::math::VEC3( 0.0f, 25.0f, 100.0f ),
			gfl::math::VEC3( 0.0f, 25.0f, 0.0f ),
			gfl::grp::g3d::Camera::NEAR_CLIP_DEFAULT,
			gfl::grp::g3d::Camera::FAR_CLIP_DEFAULT,
			gfl::grp::g3d::Camera::FOVY_RADIAN_DEFAULT,
			0.0f,
			gfl::grp::g3d::Camera::NEAR_CLIP_DEFAULT + 5.0f,
			1.0f,
			false
		}
	};
	pG3dUtil->CreateG3dCamera( heap, app::util::G3DUtil::SETUP_CAMERA_UPPER, &dat[0], NULL );
	//pG3dUtil->CreateG3dLight( ARCID_SPARRING, GARC_sparring_sparring_BCLGT_LZ, heap, true );
	pG3dUtil->CreateG3dModelWork( heap, SPARRING_MODEL_DATA_MAX );
	gfl::fs::ArcFile * af = GFL_NEW(  heap->pHeap ) gfl::fs::ArcFile(  heap->pHeap , ARCID_NAKAHIRO_TEST, gfl::fs::ArcFile::OPEN );
	pG3dUtil->AddG3dModel( af, GARC_nakahiro_test_res_haikei_BCMDL, heap, app::util::G3DUtil::ADD_MODEL_ID_FREE, NULL, 0 );
	GFL_DELETE af;
  pG3dUtil->CreateEdgeSystem( pGraSystem, app::util::G3DUtil::EDGE_SET_FLAG_UPPER, heap );
	pG3dUtil->SetupG3dScene();
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		3D֘A폜
 *
 * @param		none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void GraphicWork::Delete3D(void)
{
	for( int i = 0 ; i< SPARRING_MODEL_DATA_MAX ; i++ )
  {
		pG3dUtil->DelG3dModel( i );
	}
  pG3dUtil->DeleteEdgeSystem();
	pG3dUtil->DeleteG3dModelWork();
	//pG3dUtil->DeleteG3dLight();
	pG3dUtil->DeleteG3dCamera();

	pG3dUtil->DeleteG3dScene();
	pG3dUtil->DeleteG3dSystem();

	GFL_DELETE	pG3dUtil;
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		|Pf֘A쐬
 *
 * @param		heap		q[v
 * @param		fr_mann	t@C[h}l[W
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void GraphicWork::CreatePokeModel( app::util::Heap * heap, gfl::fs::FileReadManager* fr_man )
{ 
	pPokeModelSystem = GFL_NEW( heap->pHeap ) poke_tool::PokeModelSystem();
	pPokeModelSystem->InitSystem( heap->pHeapAllocator, heap->pDevHeapAllocator, fr_man );
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		|Pf֘A폜
 *
 * @param		none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void GraphicWork::DeletePokeModel( void )
{ 
	pPokeModelSystem->ExitSystem();
	GFL_DELETE pPokeModelSystem;
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		[hWXN[Wɕϊ
 *
 * @param		none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void  GraphicWork::ConvertPosWorldToScreen( const gfl::math::VEC3 pos, s32* scr_x, s32* scr_y )
{ 
	gfl::grp::FrameBufferManager * fbm = pGraSystem->GetFrameBufferManager();
	gfl::grp::RenderTarget * target = fbm->GetRenderTarget( pGraSystem->GetCurrentFrameBufferID( gfl::grp::DISPLAY_UPPER ) );
  pG3dUtil->GetUpperCamera()->ConvertWorldPointToUpperScreenPoint( scr_x, scr_y, pos, *target );
}

//--------------------------------------------------------------------------------------------
/**
 * @brief   XN[W[hWɕϊ
 *
 * @param		none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void  GraphicWork::ConvertPosScreenToWorld( gfl::math::VEC3* pos, const s32 scr_x, const s32 scr_y )
{ 
	gfl::grp::FrameBufferManager * fbm = pGraSystem->GetFrameBufferManager();
	gfl::grp::RenderTarget * target = fbm->GetRenderTarget( pGraSystem->GetCurrentFrameBufferID( gfl::grp::DISPLAY_UPPER ) );
  pG3dUtil->GetUpperCamera()->ConvertUpperScreenPointToWorldPoint( pos, false, scr_x, scr_y, *target );
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		J|WVZbg
 *
 * @param		none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void GraphicWork::SetCameraPosition( gfl::math::VEC3* pos )
{ 
  pG3dUtil->GetUpperCamera()->SetCameraPosition( *pos );
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		J|WVZbg
 *
 * @param		none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void GraphicWork::SetCameraPosition( f32 phi, f32 theta, f32 radius, gfl::math::VEC3* center, bool target )
{ 
  gfl::math::VEC3 pos;

  pos.x = gfl::math::CosDeg( theta ) * gfl::math::CosDeg( phi ) * radius;
  pos.y = gfl::math::SinDeg( phi ) * radius;
  pos.z = gfl::math::SinDeg( theta ) * gfl::math::CosDeg( phi ) * radius;
  if( center != NULL )
  { 
    pos.x += center->x;
    pos.y += center->y;
    pos.z += center->z;
    if( target )
    { 
      pG3dUtil->GetUpperCamera()->SetCameraAndTargetPosition( pos, *center );
    }
    else
    { 
      pG3dUtil->GetUpperCamera()->SetCameraPosition( pos );
    }
  }
  else
  { 
    pG3dUtil->GetUpperCamera()->SetCameraPosition( pos );
  }
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		J^[QbgZbg
 *
 * @param		none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void GraphicWork::SetTargetPosition( gfl::math::VEC3* tar )
{ 
  pG3dUtil->GetUpperCamera()->SetTargetPosition( *tar );
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		J|WV&^[QbgZbg
 *
 * @param		none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void GraphicWork::SetCameraAndTargetPosition( gfl::math::VEC3* pos, gfl::math::VEC3* tar )
{ 
  pG3dUtil->GetUpperCamera()->SetCameraAndTargetPosition( *pos, *tar );
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		J|WVQbg
 *
 * @param		none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void GraphicWork::GetCameraPosition( gfl::math::VEC3& pos )
{ 
  pG3dUtil->GetUpperCamera()->GetCameraPosition( pos );
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		J|WV&^[QbgQbg
 *
 * @param		none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void GraphicWork::GetCameraAndTargetPosition( gfl::math::VEC3& pos, gfl::math::VEC3& tar )
{ 
  pG3dUtil->GetUpperCamera()->GetCameraAndTargetPosition( pos, tar );
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		2DAjĐ
 *
 * @param		none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void GraphicWork::StartAnime2D( const int anm_no )
{ 
  pG2dUtil->StopAnime( 0, anm_no );
  pG2dUtil->StartAnime( 0, anm_no );
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		^[QbgyC|WVZbg
 *
 * @param[in] id    yCID
 * @param[in] pos   Zbg|WV
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void GraphicWork::SetTargetPanePos( const int id, gfl::math::VEC3& pos )
{ 
  pG2dUtil->SetPanePos( 0, TargetPaneTable[ id ], &pos );
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		^[QbgyCrWuZbg
 *
 * @param[in] id    yCID
 * @param[in] value ZbgrWu
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void GraphicWork::SetTargetPaneVisible( const int id, const bool  value )
{ 
  pG2dUtil->SetPaneVisible( 0, TargetPaneTable[ id ], value );
}

}	// sparring
}	// app
