#if PM_DEBUG

//============================================================================================
/**
 * @file		sogabe.cpp
 * @brief		^CgfobOuSogabe Hisashiv
 * @author	soga
 * @date		12.05.09
 *
 * namespace	test::sogabe::
 */
//============================================================================================
#include <gflib.h>
#include <base/gfl_ProcManager.h>
#include <ro/gfl_RoManager.h>

#include "arc/arc_def.h"
#include "dll/DllProc.h"

// xy_project
#include "gamesystem/GameProc.h"
#include "gamesystem/GameProcManager.h"

#include "test/sogabe/sogabe.h"
#include "sparring/sparring.h"

namespace test {
namespace sogabe {

// x`
enum SkelUserLabel {
	LAUNCHERLABEL_SPARRING,

	LAUNCHERLABEL_MAX,     // xől

	ENUM_FORCE_DWORD(SkelUserLabel)
};

static skel::LauncherSelectRet SetUpUserProc( u32 selectNum, gamesystem::GameProcManager* p_procMan, gfl::heap::HeapBase* heap );

// N
static const skel::LauncherLabel LauncherLabel[] =
{
	{ L"Xp[O", LAUNCHERLABEL_SPARRING },
};

// NZbgAbv
static const skel::LauncherSetUp LauncherSetUp = {
	LauncherLabel,
	LAUNCHERLABEL_MAX
};

//--------------------------------------------------------------------------------------------
/**
 * @brief		RXgN^
 */
//--------------------------------------------------------------------------------------------
Proc::Proc(void)
{
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		fXgN^
 */
//--------------------------------------------------------------------------------------------
Proc::~Proc(void)
{
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		Proc
 *
 * @param		proc_manager		gfl::proc::Manager
 *
 * @return	gfl::proc::Result
 */
//--------------------------------------------------------------------------------------------
gfl::proc::Result Proc::InitFunc( gfl::proc::Manager * )
{
	return gfl::proc::RES_FINISH;
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		ProcI
 *
 * @param		proc_manager		gfl::proc::Manager
 *
 * @return	gfl::proc::Result
 */
//--------------------------------------------------------------------------------------------
gfl::proc::Result Proc::EndFunc( gfl::proc::Manager * )
{
	return gfl::proc::RES_FINISH;
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		ProcAbvf[g
 *
 * @param		proc_manager		gfl::proc::Manager
 *
 * @return	gfl::proc::Result
 */
//--------------------------------------------------------------------------------------------
gfl::proc::Result Proc::UpdateFunc( gfl::proc::Manager * )
{
	CreateMenu();
	return gfl::proc::RES_CONTINUE;
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		Proc`揈
 *
 * @param		proc_manager		gfl::proc::Manager
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void Proc::DrawFunc( gfl::proc::Manager * )
{
}


void Proc::CreateMenu(void)
{
	skel::LauncherProc * pLauncher = GFL_NEW( mpGameProcManager->GetHeap() )	skel::LauncherProc;
	pLauncher->SetGameProcManager( mpGameProcManager );
	mpGameProcManager->CallProc( pLauncher );
	pLauncher->SetParamGM( &LauncherSetUp, SetUpUserProc );
}
void Proc::DeleteMenu(void)
{
//	GFL_DELETE	pLauncher;
}


static skel::LauncherSelectRet SetUpUserProc( u32 selectNum, gamesystem::GameProcManager* p_procMan, gfl::heap::HeapBase* heap )
{
	GFL_UNUSED( heap );

	switch( selectNum ){
	case LAUNCHERLABEL_SPARRING:
    static  app::sparring::APP_PARAM prm = { 0 };
		GFL_PROC_CALL( p_procMan, app::sparring::Proc( &prm ) );
		return skel::LAUNCHER_RET_CALL_NORMAL;
	}

	return skel::LAUNCHER_RET_CALL_DEBUGMODE;
}

}	// sogabe
}	// test

#endif // PM_DEBUG
