//===================================================================
/**
 * @file    sparring_enemy_actor.h
 * @brief   Xp[OGl~[AN^[
 * @author  soga
 * @date    12.05.21
*/
//===================================================================

#ifndef __SPARRING_ENEMY_ACTOR_H__
#define __SPARRING_ENEMY_ACTOR_H__

#include  "gflib.h"
#include  "ActorBase.h"

namespace actor {

  class SparringEnemyActor : public actor::ActorBase
  { 
    GFL_FORBID_COPY_AND_ASSIGN( SparringEnemyActor );

    private:

    typedef enum
    { 
      ENEMY_TYPE_NONE = -1,
      ENEMY_TYPE_FLY = 0,
      ENEMY_TYPE_BULLET,
      ENEMY_TYPE_MINE,
    }EnemyType;

    struct EnemyTypeFly
    { 
      f32   center_x;     //̊_
      f32   center_y;     //̊_
      f32   center_z;     //̊_
      f32   radius;       //ړ\͈͔a
      bool  bullet_flag;  //e˂tO
      u32   bullet_id;    //esysID
    };
    struct EnemyTypeBullet
    { 
      f32   old_x;      //Pt[Öʒu
      f32   old_y;      //Pt[Öʒu
      f32   old_z;      //Pt[Öʒu
      f32   move_frame; //Bt[
    };
    struct EnemyTypeMine
    { 
      f32   jump_accele;
      f32   jump_speed;
    };

    union EnemyParam
    { 
      EnemyTypeFly    fly_param;
      EnemyTypeBullet bullet_param;
      EnemyTypeMine   mine_param;
    };

    static  const int mDamageFrame = 16;

    int             mType;
    gfl::math::VEC3 mSpeed;     //ړx
    int             mDamage;
    EnemyParam      mEnemyParam;

    public:
    //----------------------------------------------------------------------------
    /**
     *	@brief    RXgN^
     */
    //-----------------------------------------------------------------------------
    SparringEnemyActor();

    //-----------------------------------------------------------------------------
    /**
     * @brief ֐
     *
     * @retval ACT_MOVE_RESULT_CONTINUE p@ACT_MOVE_RESULT_FINISH I
     */
    //-----------------------------------------------------------------------------
    virtual ACT_MOVE_RESULT Move( void* act_move_param );

    //-----------------------------------------------------------------------------
    /**
     * @brief Generate֐(FlyType)
     */
    //-----------------------------------------------------------------------------
    void  GenerateTypeFly( gfl::math::VEC3& center, f32 radius );

    //-----------------------------------------------------------------------------
    /**
     * @brief Generate֐(BulletType)
     */
    //-----------------------------------------------------------------------------
    void  GenerateTypeBullet( gfl::math::VEC3& src, gfl::math::VEC3& dst, f32 speed );

    //-----------------------------------------------------------------------------
    /**
     * @brief Generate֐(MineType)
     */
    //-----------------------------------------------------------------------------
    void  GenerateTypeMine( gfl::math::VEC3& src, gfl::math::VEC3& dst, f32 height, f32 speed );

    private:
    static  ACT_MOVE_RESULT (SparringEnemyActor::*EnemyTypeFuncTbl[])( void* act_move_param );

    //-----------------------------------------------------------------------------
    /**
     * @brief Move֐(FlyType)
     */
    //-----------------------------------------------------------------------------
    ACT_MOVE_RESULT MoveFlyFunc( void* act_move_param );

    //-----------------------------------------------------------------------------
    /**
     * @brief Move֐(BulletType)
     */
    //-----------------------------------------------------------------------------
    ACT_MOVE_RESULT MoveBulletFunc( void* act_move_param );

    //-----------------------------------------------------------------------------
    /**
     * @brief Move֐(MineType)
     */
    //-----------------------------------------------------------------------------
    ACT_MOVE_RESULT MoveMineFunc( void* act_move_param );

  };

} // namespace actor

#endif //__SPARRING_ENEMY_ACTOR_H__
