//===================================================================
/**
 * @file    sparring_boss_actor.h
 * @brief   Xp[O{XAN^[
 * @author  soga
 * @date    12.05.21
*/
//===================================================================

#ifndef __SPARRING_BOSS_ACTOR_H__
#define __SPARRING_BOSS_ACTOR_H__

#include  "gflib.h"
#include  "ActorBase.h"

namespace actor {

  class SparringBossActor : public actor::ActorBase
  { 
    GFL_FORBID_COPY_AND_ASSIGN( SparringBossActor );

    private:
    static  const int mTargetMax  = 8;
    static  const int mTargetWait = 300;  //_炯o

    struct TargetParam
    { 
      int                       seq_no;
      int                       time;
      //----------------------------------------------------------------------------
      /**
       *	@brief    RXgN^
       */
      //-----------------------------------------------------------------------------
      TargetParam( void ):
      seq_no( 0 ),
      time( 0 )
      {}
    };

    TargetParam mTargetParam[ mTargetMax ];

    public:
    //----------------------------------------------------------------------------
    /**
     *	@brief    RXgN^
     */
    //-----------------------------------------------------------------------------
    SparringBossActor();

    //-----------------------------------------------------------------------------
    /**
     * @brief ֐
     *
     * @retval ACT_MOVE_RESULT_CONTINUE p@ACT_MOVE_RESULT_FINISH I
     */
    //-----------------------------------------------------------------------------
    virtual ACT_MOVE_RESULT Move( void* act_move_param );

  };

} // namespace actor

#endif //__SPARRING_BOSS_ACTOR_H__
