//===================================================================
/**
 * @file    sparring_boss_actor.cpp
 * @brief   Xp[O{XAN^[
 * @author  soga
 * @date    12.05.21
*/
//===================================================================

#include  "sparring_boss_actor.h"
#include  "../sparring/sparring_main.h"

namespace actor {

static  const poke_tool::POKEMODEL_NODE node_table[] = 
{ 
  poke_tool::MODEL_NODE_EYE_01,    //({͉EE2ȏ̉\
  poke_tool::MODEL_NODE_EYE_02,    //({͍E2ȏ̉\
  poke_tool::MODEL_NODE_MOUTH,     //(̉\
  poke_tool::MODEL_NODE_HAND_01,   //({͉EE2ȏ̉\
  poke_tool::MODEL_NODE_HAND_02,   //({͍E2ȏ̉\
};

//----------------------------------------------------------------------------
/**
 *	@brief    RXgN^
 */
//-----------------------------------------------------------------------------
SparringBossActor::SparringBossActor()
{ 

}

//-----------------------------------------------------------------------------
/**
 * @brief ֐
 *
 * @retval ACT_MOVE_RESULT_CONTINUE p@ACT_MOVE_RESULT_FINISH I
 */
//-----------------------------------------------------------------------------
ACT_MOVE_RESULT SparringBossActor::Move( void* act_move_param )
{ 
  app::sparring::SPARRING_GAME_WORK* sgw = ( app::sparring::SPARRING_GAME_WORK* )act_move_param; 

  switch( mSeqNo ){ 
  case 0:
    //_炯o`FbN
    if( xy_system::GflUse::GetPublicRand() % 50 == 0 )
    { 
      int id = xy_system::GflUse::GetPublicRand( GFL_NELEMS( node_table ) );
      if( mTargetParam[ id ].seq_no == 0 )
      { 
        mTargetParam[ id ].seq_no = 1;
        mTargetParam[ id ].time   = mTargetWait;
        sgw->sub_wk->pGraWork->SetTargetPaneVisible( id, true );
      }
    }
    break;
  case 1:
    SetAnime( poke_tool::MODEL_ANIME_DAMAGE_S );
    mSeqNo++;
    /*fallthru*/
  case 2:
    if( IsFinishAnime() )
    { 
      SetAnime( poke_tool::MODEL_ANIME_BT_WAIT_A );
      mSeqNo = 0;
    }
    break;
  }

  for( s32 i = 0 ; i < mTargetMax ; i++ )
  { 
    switch( mTargetParam[ i ].seq_no ){ 
    case 0:
      break;
    case 1:
      { 
        gfl::math::VEC3 pos;
        GetNodePosition( node_table[ i ], &pos );
        s32 scr_x, scr_y;
        sgw->sub_wk->pGraWork->ConvertPosWorldToScreen( pos, &scr_x, &scr_y );
        gfl::math::VEC3 pane_pos;
        pane_pos.x = scr_x - 200;
        pane_pos.y = 120 - scr_y;
        pane_pos.z = 0;
        sgw->sub_wk->pGraWork->SetTargetPanePos( i, pane_pos );

        if( mSeqNo != 0 ) break;

        if( --mTargetParam[ i ].time < 0 )
        { 
          sgw->sub_wk->pGraWork->SetTargetPaneVisible( i, false );
          u32 sysID = sgw->actor_manager->AddSceneActor( ACT_SPARRING_SWB, 0 );
          actor::SparringEnemyActor* enemy_actor = ( actor::SparringEnemyActor* )sgw->actor_manager->GetActorBaseWithSysID( ACT_SPARRING_SWB, sysID );
          gfl::math::VEC3 dst;
          sgw->sub_wk->pGraWork->GetCameraPosition( dst );
          enemy_actor->GenerateTypeBullet( pos, dst, 4.0f );
          enemy_actor->SetAnime( 0 );
          xy_snd::PlaySE( SEQ_SE_BT_BOWA1 );
          mTargetParam[ i ].time  = mTargetWait;
          mTargetParam[ i ].seq_no = 2; 
        }
        else
        { 
          if( sgw->actor_collision->CheckCollision( pos, 5.0f ) )
          { 
            sgw->sub_wk->pGraWork->SetTargetPaneVisible( i, false );
            xy_snd::PlaySE( SEQ_SE_BT_KOUKA_M );
            mTargetParam[ i ].seq_no = 0; 
            mSeqNo = 1;
          }
        }
      }
      break;
    case 2:
      if( --mTargetParam[ i ].time == 0 )
      { 
        mTargetParam[ i ].seq_no = 0; 
      }
      break;
    }
  }

  return ACT_MOVE_RESULT_CONTINUE;
}

} // namespace actor
