//===================================================================
/**
 * @file    actor_resource_manager.h
 * @brief   AN^[\[X}l[W[
 * @author  soga
 * @date    12.05.17
*/
//===================================================================

#ifndef __ACTOR_RESOURCE_MANAGER_H__
#define __ACTOR_RESOURCE_MANAGER_H__

#include  "gflib.h"
#include "act_anm_data.h"

namespace actor {

  class ActorResourceManager
  { 
    private:
    struct ACT_DAT
    { 
      gfl::fs::ArcFile::ARCDATID  mdlIdx;
      gfl::fs::ArcFile::ARCDATID  anmIdx;
      s32                         ActNo;
    };

    gfl::fs::ArcFile*     mG3DResourceArcFile;
    gfl::fs::ArcFile*     mActAnmArcFile;
    ACT_DAT*              mActDat;
    int                   mActMax;

    public:
    //----------------------------------------------------------------------------
    /**
     *	@brief  RXgN^
     *
     *	@param[in]  heap      q[v
     *	@param[in]  arcID_gra G3D\[XARCID  @todo Iɂ́Aʂ̃\[X}l[WɊǗ
     *	@param[in]  arcID_act AN^[\[XARCID
     *	@param[in]  inActMax  AN^[\[X̍ől
     *	@param[in]  arcID_anm AN^[Aj\[XARCID
     */
    //-----------------------------------------------------------------------------
    ActorResourceManager( gfl::heap::HeapBase* heap, const gfl::fs::ArcFile::ARCID arcID_gra,
                          const gfl::fs::ArcFile::ARCID arcID_act, const int inActMax,
                          const gfl::fs::ArcFile::ARCID arcID_anm );

    //----------------------------------------------------------------------------
    /**
     *	@brief  fXgN^
     */
    //-----------------------------------------------------------------------------
    ~ActorResourceManager();

    //----------------------------------------------------------------------------
    /**
     *	@brief  mG3DResourceArcFile擾
     */
    //-----------------------------------------------------------------------------
    gfl::fs::ArcFile* GetG3DResourceArcFile( void );
    
    //----------------------------------------------------------------------------
    /**
     *	@brief  fIDX擾
     *
     *	@param[in]  act_no  fIDX擾AN^[io[
     */
    //-----------------------------------------------------------------------------
    gfl::fs::ArcFile::ARCDATID GetModelIdx( int act_no );

    //----------------------------------------------------------------------------
    /**
     *	@brief  G3dUtilɓnAjf[^\̂𐶐
     *
     *	@param[in]  heap        q[v
     *	@param[in]  act_no      AN^[io[
     *	@param[in]  inPatternNo Aj[Vp^[No
     *	@param[out] anm_max     Aj[V̐
     *	@param[out] first       ŏɑ݂Aj̃io[
     *
     *  @retval anm_data  Ajf[^\̂̃|C^iĂяoŉĂj
     */
    //-----------------------------------------------------------------------------
    app::util::G3DUtil::ANIME_DATA* CreateAnimeData( gfl::heap::HeapBase* heap, const int act_no, const int inPatternNo, int* max = NULL, actor::ActAnmData::ANM_IDXS* first = NULL );

  };

} //namespace actor

#endif //__ACTOR_RESOURCE_MANAGER_H__
