//===================================================================
/**
 * @file    actor_resource_manager.cpp
 * @brief   AN^[\[X}l[W[
 * @author  soga
 * @date    12.05.17
*/
//===================================================================

#include "actor_resource_manager.h"

namespace actor {

//----------------------------------------------------------------------------
/**
 *	@brief  RXgN^
 *
 *	@param[in]  heap      q[v
 *	@param[in]  arcID_gra G3D\[XARCID  @todo Iɂ́Aʂ̃\[X}l[WɊǗ
 *	@param[in]  arcID_act AN^[\[XARCID
 *	@param[in]  inActMax  AN^[\[X̍ől
 *	@param[in]  arcID_anm AN^[Aj\[XARCID
 */
//-----------------------------------------------------------------------------
ActorResourceManager::ActorResourceManager( gfl::heap::HeapBase* heap, const gfl::fs::ArcFile::ARCID arcID_gra,
                                            const gfl::fs::ArcFile::ARCID arcID_act, const int inActMax,
                                            const gfl::fs::ArcFile::ARCID arcID_anm )
{ 
  mG3DResourceArcFile = GFL_NEW_LOW( heap ) gfl::fs::ArcFile( heap, arcID_gra, gfl::fs::ArcFile::OPEN );
  mActAnmArcFile = GFL_NEW_LOW( heap ) gfl::fs::ArcFile( heap, arcID_anm, gfl::fs::ArcFile::OPEN );
  mActDat = GFL_NEW_LOW( heap ) ACT_DAT[ inActMax ];
  mActMax = inActMax;

  gfl::fs::ArcFile* af = GFL_NEW_LOW( heap ) gfl::fs::ArcFile( heap, arcID_act, gfl::fs::ArcFile::OPEN );

  for( s32 i = 0 ; i < inActMax ; i++ )
  { 
    af->LoadData( i, &mActDat[ i ] );
  }

  GFL_DELETE af;
}

//----------------------------------------------------------------------------
/**
*	@brief  fXgN^
*/
//-----------------------------------------------------------------------------
ActorResourceManager::~ActorResourceManager()
{ 
  GFL_DELETE mG3DResourceArcFile;
  GFL_DELETE mActAnmArcFile;
  GFL_DELETE_ARRAY mActDat;
}

//----------------------------------------------------------------------------
/**
 *	@brief  mG3DResourceArcFile擾
 */
//-----------------------------------------------------------------------------
gfl::fs::ArcFile* ActorResourceManager::GetG3DResourceArcFile( void )
{ 
  return mG3DResourceArcFile;
}
    
//----------------------------------------------------------------------------
/**
 *	@brief  fIDX擾
 *
 *	@param[in]  act_no  fIDX擾AN^[io[
 */
//-----------------------------------------------------------------------------
gfl::fs::ArcFile::ARCDATID ActorResourceManager::GetModelIdx( int act_no )
{ 
  GFL_ASSERT_STOP( act_no < mActMax );
  if( act_no < mActMax )
  {  
    return mActDat[ act_no ].mdlIdx;
  }
  return 0;
}

//----------------------------------------------------------------------------
/**
 *	@brief  G3dUtilɓnAjf[^\̂𐶐
 *
 *	@param[in]  heap        q[v
 *	@param[in]  act_no      AN^[io[
 *	@param[in]  inPatternNo Aj[Vp^[No
 *	@param[out] anm_max     Aj[V̐
 *	@param[out] first       ŏɑ݂Aj̃io[
 *
 *  @retval anm_data  Ajf[^\̂̃|C^iĂяoŉĂj
 */
//-----------------------------------------------------------------------------
app::util::G3DUtil::ANIME_DATA* ActorResourceManager::CreateAnimeData( gfl::heap::HeapBase* heap, const int act_no, const int inPatternNo, int* anm_max, actor::ActAnmData::ANM_IDXS* first )
{ 
  actor::ActAnmData* act_anm_data = GFL_NEW_LOW( heap ) actor::ActAnmData();
  int size = mActAnmArcFile->GetDataSize( mActDat[ act_no ].anmIdx );
  void* data = GflHeapAllocMemoryLow( heap, size );

  mActAnmArcFile->LoadData( mActDat[ act_no ].anmIdx, data );
  act_anm_data->SetData( data );

  app::util::G3DUtil::ANIME_DATA* anm_data = act_anm_data->CreateAnimeData( heap, inPatternNo );

  if( anm_max != NULL )
  { 
    *anm_max = act_anm_data->GetActionNum( inPatternNo );
  }
  if( first != NULL )
  { 
    first->FirstSklaIdx = act_anm_data->GetFirstAnmIdxs( inPatternNo )->FirstSklaIdx;
    first->FirstMataIdx = act_anm_data->GetFirstAnmIdxs( inPatternNo )->FirstMataIdx;
  }

  GflHeapFreeMemory( data );
  GFL_DELETE  act_anm_data;

  return anm_data;
}

} //namespace actor
