//===================================================================
/**
 * @file    actor_poke_model.h
 * @brief   |PfgpAN^[
 * @author  soga
 * @date    12.05.15
*/
//===================================================================

#pragma once

#include  "ActorModelBase.h"

namespace actor {

  class ActorPokeModel : public  actor::ActorModelBase
  { 
    GFL_FORBID_COPY_AND_ASSIGN( ActorPokeModel );

    private:
    poke_tool::PokeModelSystem* mPokeModelSys;
    gfl::grp::g3d::Scene*       mScene;
    poke_tool::PokeModel*       mPokeModel;
    bool                        mAddSceneFlag;
    bool                        mInitializeFlag;

    public:
    //----------------------------------------------------------------------------
    /**
     *	@brief    RXgN^
     */
    //-----------------------------------------------------------------------------
    ActorPokeModel();

    //-----------------------------------------------------------------------------
    /**
     * @brief fXgN^
     */
    //-----------------------------------------------------------------------------
    virtual ~ActorPokeModel();

    //-----------------------------------------------------------------------------
    /**
     * @brief Update֐i]VEC3Łj
     */
    //-----------------------------------------------------------------------------
    virtual void  Update( const gfl::math::VEC3& trans, const gfl::math::VEC3& rotate, const gfl::math::VEC3& scale );

    //-----------------------------------------------------------------------------
    /**
     * @brief Update֐i]MTX34Łj
     */
    //-----------------------------------------------------------------------------
    virtual void  Update( const gfl::math::VEC3& trans, const gfl::math::MTX34& mtx, const gfl::math::VEC3& scale );

    //-----------------------------------------------------------------------------
    /**
     * @brief Aj[VZbg
     *
     * @param[in] anm_no ZbgAj[VNo
     */
    //-----------------------------------------------------------------------------
    virtual void  SetAnime( int anm_no );

    //-----------------------------------------------------------------------------
    /**
     * @brief Aj[VI`FbN
     *
     * @param[in] none
     *
     * @retval  true:I false:p
     */
    //-----------------------------------------------------------------------------
    virtual bool  IsFinishAnime( void );

    //-----------------------------------------------------------------------------
    /**
     * @brief AddScene
     */
    //-----------------------------------------------------------------------------
    virtual void  AddSceneModel( void );

    //-----------------------------------------------------------------------------
    /**
     * @brief RemoveScene
     */
    //-----------------------------------------------------------------------------
    virtual void  RemoveSceneModel( void );

    //-----------------------------------------------------------------------------
    /**
     * @brief SetVisible
     *
     * @param[in] flag  true:\@false:\
     */
    //-----------------------------------------------------------------------------
    virtual void  SetVisible( bool flag );

    //-----------------------------------------------------------------------------
    /**
    * @brief SetConstantColor
    *
    * @param[in] col ZbgJ[
    * @param[in] no  ZbgRX^gJ[io[i|Pf̓RX^gJ[ł͂Ȃj
    */
    //-----------------------------------------------------------------------------
    virtual void  SetConstantColor( const gfl::grp::ColorF32 col, const int col_no = 0 );

    //-----------------------------------------------------------------------------
    /**
     * @brief GetNodePosition
     *
     * @param[in]   node  擾m[hCfbNX
     * @param[out]  pos   擾|WV̊i[
     */
    //-----------------------------------------------------------------------------
    virtual void  GetNodePosition( int node, gfl::math::VEC3* pos );

    //-----------------------------------------------------------------------------
    /**
     * @brief PokeModeliPokemonCoreParamŁj
     *
     * @param[in] sys   |PfVXẽ|C^
     * @param[in] scene G3DScenẽ|C^
     * @param[in] app   Avq[vAP[^̃|C^
     * @param[in] dev   foCXq[vAP[^̃|C^
     * @param[in] cp    |Pfp[^
     */
    //-----------------------------------------------------------------------------
    void  CreateModel( poke_tool::PokeModelSystem* sys, gfl::grp::g3d::Scene* scene,
                       gfl::heap::NwAllocator* app, gfl::heap::NwAllocator* dev, const pml::pokepara::CoreParam* cp );

    //-----------------------------------------------------------------------------
    /**
     * @brief PokeModeliSimpleParamŁj
     *
     * @param[in] sys   |PfVXẽ|C^
     * @param[in] scene G3DScenẽ|C^
     * @param[in] app   Avq[vAP[^̃|C^
     * @param[in] dev   foCXq[vAP[^̃|C^
     * @param[in] sp    |Pfp[^
     */
    //-----------------------------------------------------------------------------
    void  CreateModel( poke_tool::PokeModelSystem* sys, gfl::grp::g3d::Scene* scene,
                       gfl::heap::NwAllocator* app, gfl::heap::NwAllocator* dev, const poke_tool::PokeModel::SimpleParam* sp );

    private:
    //-----------------------------------------------------------------------------
    /**
     * @brief PokeModel
     */
    //-----------------------------------------------------------------------------
    void  Initialize( void );

  };

} // namespace system
