//===================================================================
/**
 * @file    actor_poke_model.h
 * @brief   |PfgpAN^[
 * @author  soga
 * @date    12.05.15
*/
//===================================================================

#pragma once

#include  "actor_poke_model.h"

namespace actor {

//----------------------------------------------------------------------------
/**
 *	@brief    RXgN^
 */
//-----------------------------------------------------------------------------
ActorPokeModel::ActorPokeModel() :
  ActorModelBase(),
  mPokeModelSys( NULL ),
  mScene( NULL ),
  mPokeModel( NULL ),
  mAddSceneFlag( false ),
  mInitializeFlag( false )
{
}

//-----------------------------------------------------------------------------
/**
 * @brief fXgN^
 */
//-----------------------------------------------------------------------------
ActorPokeModel::~ActorPokeModel()
{ 
  if( mPokeModel )
  { 
    if( mAddSceneFlag )
    { 
      RemoveSceneModel();
    }
    mPokeModelSys->DeleteModel( mPokeModel );
    mPokeModel = NULL;
  }
}

//-----------------------------------------------------------------------------
/**
 * @brief Update֐i]VEC3Łj
 */
//-----------------------------------------------------------------------------
void  ActorPokeModel::Update( const gfl::math::VEC3& trans, const gfl::math::VEC3& rotate, const gfl::math::VEC3& scale )
{ 
  if( mPokeModel )
  { 
    mPokeModel->SetPosition( &trans );
    mPokeModel->SetRotate( &rotate );
    mPokeModel->SetScale( &scale );
  }
}

//-----------------------------------------------------------------------------
/**
 * @brief Update֐i]MTX34Łj
 */
//-----------------------------------------------------------------------------
void  ActorPokeModel::Update( const gfl::math::VEC3& trans, const gfl::math::MTX34& mtx, const gfl::math::VEC3& scale )
{ 
  GFL_UNUSED( trans );
  GFL_UNUSED( mtx );
  GFL_UNUSED( scale );
  //PokeModelɂ͉]sŎw肷֐݂Ȃ̂ŁA
  //Update֐̌Ăяo֎~ɂ邽߂ɃAT[gŎ~߂
  GFL_ASSERT( 0 );
}

//-----------------------------------------------------------------------------
/**
 * @brief Aj[VZbg
 *
 * @param[in] anm_no ZbgAj[VNo
 */
//-----------------------------------------------------------------------------
void  ActorPokeModel::SetAnime( int anm_no )
{ 
  GFL_ASSERT( mPokeModel );
  if( mPokeModel )
  { 
	  mPokeModel->ChangeAnime( (poke_tool::POKEMODEL_ANIME)anm_no );
	  mPokeModel->PlayAnime();
  }
}

//-----------------------------------------------------------------------------
/**
 * @brief Aj[VI`FbN
 *
 * @param[in] none
 *
 * @retval  true:I false:p
 */
//-----------------------------------------------------------------------------
bool  ActorPokeModel::IsFinishAnime( void )
{ 
  GFL_ASSERT( mPokeModel );
  bool  result = true;
  if( mPokeModel )
  { 
	  result = mPokeModel->IsFinishAnime();
  }
  return result;
}

//-----------------------------------------------------------------------------
/**
 * @brief Scene֒ǉ
 *
 * @param none
 */
//-----------------------------------------------------------------------------
void  ActorPokeModel::AddSceneModel( void )
{ 
  GFL_ASSERT( mPokeModel );
  GFL_ASSERT( !mAddSceneFlag );
  if( mPokeModel && !mAddSceneFlag )
  { 
    mPokeModel->AddScene( mScene );
	  gamesystem::GameManager * gm = GFL_SINGLETON_INSTANCE( gamesystem::GameManager );
    mPokeModel->SetupShader( mScene, gm->GetGraphicsSystem() );
    //mScene->SwitchEdgeMapModel( mPokeModel->GetG3dModel(), true );
    mAddSceneFlag = true;
  }
}

//-----------------------------------------------------------------------------
/**
 * @brief Scene폜
 *
 * @param none
 */
//-----------------------------------------------------------------------------
void  ActorPokeModel::RemoveSceneModel( void )
{ 
  GFL_ASSERT( mPokeModel );
  GFL_ASSERT( mAddSceneFlag );
  if( mPokeModel && mAddSceneFlag )
  { 
    //mScene->SwitchEdgeMapModel( mPokeModel->GetG3dModel(), false );
    mPokeModel->RemoveScene( mScene );
    SetVisible( false );
    mAddSceneFlag = false;
  }
}

//-----------------------------------------------------------------------------
/**
 * @brief SetVisible
 *
 * @param[in] flag  true:\@false:\
 */
//-----------------------------------------------------------------------------
void  ActorPokeModel::SetVisible( bool flag )
{ 
  GFL_ASSERT( mPokeModel );
  if( mPokeModel )
  { 
    mPokeModel->SetVisible( flag );
  }
}

//-----------------------------------------------------------------------------
/**
 * @brief SetConstantColor
 *
 * @param[in] col ZbgJ[
 * @param[in] no  ZbgRX^gJ[io[
 */
//-----------------------------------------------------------------------------
void  ActorPokeModel::SetConstantColor( const gfl::grp::ColorF32 col, const int col_no )
{ 
  GFL_UNUSED( col_no );
  GFL_ASSERT( mPokeModel );
  if( mPokeModel )
  { 
    gfl::math::VEC4 shader_color;
    shader_color.x = col.r;
    shader_color.y = col.g;
    shader_color.z = col.b;
    shader_color.w = col.a;
    mPokeModel->SetStatusShaderColor( shader_color, 1.0f );
  }
}

//-----------------------------------------------------------------------------
/**
 * @brief GetNodePosition
 *
 * @param[in]   node  擾m[hCfbNX
 * @param[out]  pos   擾|WV̊i[
 */
//-----------------------------------------------------------------------------
void  ActorPokeModel::GetNodePosition( int node, gfl::math::VEC3* pos )
{ 
  GFL_ASSERT( mPokeModel );
  if( mPokeModel )
  { 
    mPokeModel->GetNodePosition( (poke_tool::POKEMODEL_NODE)node, pos );
  }
}

//-----------------------------------------------------------------------------
/**
 * @brief PokeModeliPokemonCoreParamŁj
 *
 * @param[in] sys   |PfVXẽ|C^
 * @param[in] scene G3DScenẽ|C^
 * @param[in] app Avq[vAP[^̃|C^
 * @param[in] dev foCXq[vAP[^̃|C^
 * @param[in] cp  |Pfp[^
 */
//-----------------------------------------------------------------------------
void  ActorPokeModel::CreateModel( poke_tool::PokeModelSystem* sys, gfl::grp::g3d::Scene* scene,
                                   gfl::heap::NwAllocator* app, gfl::heap::NwAllocator* dev,
                                   const pml::pokepara::CoreParam* cp )
{ 
  GFL_ASSERT( !mPokeModel );
  if( !mPokeModel )
  { 
    mPokeModelSys = sys;
    mScene = scene;
    poke_tool::PokeModel::SetupOption option;
    option.useShaderModel = true;
    option.shaderDrawGroupTop = 3;
    option.anmType = poke_tool::MODEL_ANIME_TYPE_BATTLE;
    mPokeModel = mPokeModelSys->CreateModelCoreParam( cp, app, dev, &option );
    Initialize();
  }
}

//-----------------------------------------------------------------------------
/**
 * @brief PokeModeliSimpleParamŁj
 *
 * @param[in] app Avq[vAP[^̃|C^
 * @param[in] dev foCXq[vAP[^̃|C^
 * @param[in] sp  |Pfp[^
 */
//-----------------------------------------------------------------------------
void  ActorPokeModel::CreateModel( poke_tool::PokeModelSystem* sys, gfl::grp::g3d::Scene* scene,
                                   gfl::heap::NwAllocator* app, gfl::heap::NwAllocator* dev,
                                   const poke_tool::PokeModel::SimpleParam* sp )
{ 
  GFL_ASSERT( !mPokeModel );
  if( !mPokeModel )
  { 
    mPokeModelSys = sys;
    mScene = scene;
    poke_tool::PokeModel::SetupOption option;
    option.useShaderModel = true;
    option.shaderDrawGroupTop = 3;
    option.anmType = poke_tool::MODEL_ANIME_TYPE_BATTLE;
    mPokeModel = mPokeModelSys->CreateModelSimple( sp, app, dev, &option );
    Initialize();
  }
}

//-----------------------------------------------------------------------------
/**
 * @brief PokeModel
 */
//-----------------------------------------------------------------------------
void  ActorPokeModel::Initialize( void )
{ 
  if( !mPokeModel ) return;
  if( mInitializeFlag ) return;
	if( mPokeModel->IsFinishLoad() == false ) return;

	mPokeModel->SetAdjustScaleType( poke_tool::POKE_ADJUST_STATUS );

	proj::motion::BaseMotionCharacter* motion_data = mPokeModel->GetMotionData();
	if( motion_data ) {
		motion_data->SetAttributeOn( proj::motion::Motion::M_ATTR_NO_IK );
	}

	mPokeModel->SetNodeFastMode();

	xy_system::PokemonShaderModel* shader_model = mPokeModel->GetShaderModel();
	shader_model->SetLightVec( gfl::math::VEC4(1, 0, 0, 1) );
	shader_model->SetLightColor( gfl::math::VEC4(1, 1, 1, 1) ); 

	SetVisible( false );
  mInitializeFlag = true;
}

} // namespace actor
