//===================================================================
/**
 * @file    actor_manager.h
 * @brief   AN^[}l[W
 * @author  soga
 * @date    12.05.15
*/
//===================================================================

#pragma once

#include  "ActorBase.h"

namespace actor {

  class ActorManager
  { 
    GFL_FORBID_COPY_AND_ASSIGN( ActorManager );

    public:
    static  const s32 ACT_NO_NONE  = -1;
    static  const s32 NONE_USER_ID = -1;

    private:
    struct ACTOR_TABLE
    { 
      s32                     act_no;      //o^AN^[No
      s32                     sys_id;      //}l[WǗ郆j[NID
      s32                     user_id;     //[Uwł郆j[NID
      bool                    enable_flag; //AddSceneNodeĂ邩
      actor::ActorBase*       actor_base;  //ǗĂActorBasẽ|C^
      //----------------------------------------------------------------------------
      /**
      *	@brief  RXgN^
      *
      *	@param  heap  q[v
      *	@param  scene V[}l[W̃|C^
      * @param  value AN^[e[uMAX
      */
      //-----------------------------------------------------------------------------
      ACTOR_TABLE(void) :
      act_no( ACT_NO_NONE ),
      sys_id( 0 ),
      user_id( NONE_USER_ID ),
      enable_flag( false ),
      actor_base( NULL )
      {}
    };

    ACTOR_TABLE*  mActorTable;
    s32           mActorTableMax;
    s32*          mActorRegistTotal;
    s32*          mActorRentalTotal;

    public:
    //----------------------------------------------------------------------------
    /**
    *	@brief  RXgN^
    *
    *	@param  heap    q[v
    * @param  value   AN^[e[uMAX
    * @param  act_max ǗAN^[MAX
    */
    //-----------------------------------------------------------------------------
    ActorManager( gfl::heap::HeapBase* heap, s32 value, s32 act_max );

    //-----------------------------------------------------------------------------
    /**
    * @brief fXgN^
    */
    //-----------------------------------------------------------------------------
    ~ActorManager();

    //-----------------------------------------------------------------------------
    /**
    * @brief s֐
    */
    //-----------------------------------------------------------------------------
    void  Run( void* act_move_param );

    //-----------------------------------------------------------------------------
    /**
    * @brief RegistrationActor
    *
    * @param[in]  act_no            o^AN^[No
    * @param[in]  action_actor_base o^ActionActorBaseNX̃|C^
    */
    //-----------------------------------------------------------------------------
    void  RegistrationActor( s32 act_no, actor::ActorBase* actor_base );

    //-----------------------------------------------------------------------------
    /**
    * @brief AddSceneActor
    *
    * @param[in]  act_no  AddSceneAN^[No
    * @param[in]  user_id AddSceneuser_id
    */
    //-----------------------------------------------------------------------------
    s32 AddSceneActor( s32 act_no, s32 user_id = NONE_USER_ID );

    //-----------------------------------------------------------------------------
    /**
    * @brief RemoveSceneActor
    *
    * @param[in]  act_no  RemoveSceneAN^[No
    * @param[in]  sys_id  RemoveScenesys_id
    * @param[in]  user_id RemoveSceneuser_id
    */
    //-----------------------------------------------------------------------------
    void  RemoveSceneActor( s32 act_no, s32 sys_id, s32 user_id = NONE_USER_ID );

    //-----------------------------------------------------------------------------
    /**
    * @brief w肳ꂽActorBase擾
    *
    * @param[in]  act_no  擾AN^[No
    * @param[in]  sys_id  擾sys_id
    * @param[in]  user_id 擾user_id
    */
    //-----------------------------------------------------------------------------
    actor::ActorBase*  GetActorBase( s32 act_no, s32 sys_id, s32 user_id = NONE_USER_ID );

    //-----------------------------------------------------------------------------
    /**
    * @brief w肳ꂽActorBase擾isys_idwŁj
    *
    * @param[in]  act_no   擾AN^[No
    * @param[in]  sys_id   擾sys_id
    */
    //-----------------------------------------------------------------------------
    actor::ActorBase*  GetActorBaseWithSysID( s32 act_no, s32 sys_id );

    //-----------------------------------------------------------------------------
    /**
    * @brief w肳ꂽActionActorBase擾iuser_idwŁj
    *
    * @param[in]  act_no   擾AN^[No
    * @param[in]  user_id  擾user_id
    */
    //-----------------------------------------------------------------------------
    actor::ActorBase*  GetActorBaseWithUserID( s32 act_no, s32 user_id );

    //-----------------------------------------------------------------------------
    /**
    * @brief w肳ꂽǗĂClass݂邩`FbN
    *
    * @param[in]  act_no  擾AN^[No
    * @param[in]  sys_id  擾sys_id
    * @param[in]  user_id 擾user_id
    */
    //-----------------------------------------------------------------------------
    bool  IsValidActorBase( s32 act_no, s32 sys_id, s32 user_id = NONE_USER_ID );

    //-----------------------------------------------------------------------------
    /**
    * @brief w肳ꂽActorBase݂邩`FbNisys_idwŁj
    *
    * @param[in]  act_no   擾AN^[No
    * @param[in]  sys_id   擾sys_id
    */
    //-----------------------------------------------------------------------------
    bool  IsValidActorBaseWithSysID( s32 act_no, s32 sys_id );

    //-----------------------------------------------------------------------------
    /**
    * @brief w肳ꂽActorBase݂邩`FbNiuser_idwŁj
    *
    * @param[in]  act_no  擾AN^[No
    * @param[in]  user_id 擾user_id
    */
    //-----------------------------------------------------------------------------
    bool  IsValidActorBaseWithUserID( s32 act_no, s32 user_id );

    //-----------------------------------------------------------------------------
    /**
     * @brief w肳ꂽǗĂClass݂AddSceneNodeĂ邩`FbN
     *
     * @param[in]  act_no   擾AN^[No
     * @param[in]  sys_id   擾sys_id
     * @param[in]  user_id  擾user_id
     *
     * @retval  true:݂@false:݂Ȃ
     */
    //-----------------------------------------------------------------------------
    bool  IsEnableActorBase( s32 act_no, s32 sys_id, s32 user_id = NONE_USER_ID );

    //-----------------------------------------------------------------------------
    /**
     * @brief w肳ꂽǗĂClass݂AddSceneNodeĂ邩`FbN
     *
     * @param[in]  act_no   擾AN^[No
     * @param[in]  sys_id   擾sys_id
     *
     * @retval  true:݂@false:݂Ȃ
     */
    //-----------------------------------------------------------------------------
    bool  IsEnableActorBaseWithSysID( s32 act_no, s32 sys_id );

    //-----------------------------------------------------------------------------
    /**
     * @brief w肳ꂽǗĂClass݂AddSceneNodeĂ邩`FbN
     *
     * @param[in]  act_no   擾AN^[No
     * @param[in]  user_id  擾user_id
     *
     * @retval  true:݂@false:݂Ȃ
     */
    //-----------------------------------------------------------------------------
    bool  IsEnableActorBaseWithUserID( s32 act_no, s32 user_id );

    //-----------------------------------------------------------------------------
    /**
    * @brief ResistTotal擾
    *
    * @param[in]  act_no  擾AN^[io[
    */
    //-----------------------------------------------------------------------------
    s32 GetRegistTotal( s32 act_no ) const { return mActorRegistTotal[ act_no ]; }

    //-----------------------------------------------------------------------------
    /**
    * @brief RentalTotal擾
    *
    * @param[in]  act_no  擾AN^[io[
    */
    //-----------------------------------------------------------------------------
    s32 GetRentalTotal( s32 act_no ) const { return mActorRentalTotal[ act_no ]; }

  };

} // namespace actor
