//===================================================================
/**
 * @file    actor_manager.h
 * @brief   AN^[}l[W
 * @author  soga
 * @date    12.05.15
 */
//===================================================================

#include  "actor_manager.h"

namespace actor {

//----------------------------------------------------------------------------
/**
 *	@brief  RXgN^
 *
 *  @param  heap  q[v
 *  @param  value AN^[e[uMAX
 *  @param  act_max ǗAN^[MAX
 */
//-----------------------------------------------------------------------------
ActorManager::ActorManager( gfl::heap::HeapBase* heap, s32 value, s32 act_max )
{ 
  GFL_ASSERT( value > 0 );
  mActorTableMax    = value;
  mActorTable       = GFL_NEW( heap ) ACTOR_TABLE[ value ];
  mActorRegistTotal = GFL_NEW( heap ) s32[ act_max ];
  mActorRentalTotal = GFL_NEW( heap ) s32[ act_max ];

  for( s32 i = 0 ; i < act_max ; i++ )
  { 
    mActorRegistTotal[ i ] = 0;
    mActorRentalTotal[ i ] = 0;
  }
}

//-----------------------------------------------------------------------------
/**
 * @brief fXgN^
 */
//-----------------------------------------------------------------------------
ActorManager::~ActorManager()
{ 
  for( s32 i = 0 ; i < mActorTableMax ; i++ )
  { 
    if( mActorTable[ i ].actor_base )
    { 
      GFL_DELETE( mActorTable[ i ].actor_base );
    }
  }
  GFL_DELETE_ARRAY( mActorTable );
  GFL_DELETE_ARRAY( mActorRegistTotal );
  GFL_DELETE_ARRAY( mActorRentalTotal );
}

//-----------------------------------------------------------------------------
/**
 * @brief s֐
 */
//-----------------------------------------------------------------------------
void  ActorManager::Run( void* act_move_param )
{ 
  for( s32 i = 0 ; i < mActorTableMax ; i++ )
  {
    if( mActorTable[ i ].enable_flag )
    { 
      actor::ACT_MOVE_RESULT result = mActorTable[ i ].actor_base->Move( act_move_param );

      if( result == actor::ACT_MOVE_RESULT_FINISH )
      { 
        RemoveSceneActor( mActorTable[ i ].act_no, mActorTable[ i ].sys_id, mActorTable[ i ].user_id );
      }
      else
      { 
        mActorTable[ i ].actor_base->Update();
      }
    }
  }
}

//-----------------------------------------------------------------------------
/**
 * @brief RegistrationActor
 *
 * @param[in]  act_no      o^AN^[No
 * @param[in]  actor_base  o^ActorBaseNX̃|C^
 */
//-----------------------------------------------------------------------------
void  ActorManager::RegistrationActor( s32 act_no, actor::ActorBase* actor_base )
{ 
  s32 i;
  s32 sys_id = 0;
  for( i = 0 ; i < mActorTableMax ; i++ )
  { 
    if( mActorTable[ i ].actor_base == NULL )
    { 
      mActorTable[ i ].act_no     = act_no;
      mActorTable[ i ].actor_base = actor_base;
      mActorTable[ i ].sys_id     = sys_id;
      mActorRegistTotal[ act_no ] = sys_id + 1;
      break;
    }
    else if( mActorTable[ i ].act_no == act_no )
    { 
      sys_id++;
    }
  }
  GFL_ASSERT_STOP_MSG( i < mActorTableMax, "Regist Error act_no = %d", act_no );
}

//-----------------------------------------------------------------------------
/**
 * @brief AddSceneActor
 *
 * @param[in]  act_no  AddSceneAN^[No
 * @param[in]  user_id AddSceneuser_id
 *
 * @retval  AddSceneꂽAN^[̃VXeǗID
 */
//-----------------------------------------------------------------------------
s32 ActorManager::AddSceneActor( s32 act_no, s32 user_id )
{ 
  s32 i;

  for( i = 0 ; i < mActorTableMax ; i++ )
  { 
    if( ( !mActorTable[ i ].enable_flag ) && ( mActorTable[ i ].act_no == act_no ) )
    { 
      mActorTable[ i ].enable_flag = true;
      mActorTable[ i ].user_id     = user_id;
      mActorTable[ i ].actor_base->AddSceneModel();
      mActorRentalTotal[ act_no ]++;
      break;
    }
  }
  //AddScenełȂ
  GFL_ASSERT_MSG( i < mActorTableMax,"ACTNO %d is over", act_no);

  return mActorTable[ i ].sys_id;
}

//-----------------------------------------------------------------------------
/**
* @brief RemoveSceneActor
*
* @param[in]  act_no  RemoveSceneAN^[No
* @param[in]  user_id RemoveScenesys_id
* @param[in]  user_id RemoveSceneuser_id
*/
//-----------------------------------------------------------------------------
void  ActorManager::RemoveSceneActor( s32 act_no, s32 sys_id, s32 user_id )
{ 
  s32 i;

  for( i = 0 ; i < mActorTableMax ; i++ )
  { 
    if( ( mActorTable[ i ].enable_flag ) &&
        ( mActorTable[ i ].act_no == act_no ) &&
        ( mActorTable[ i ].sys_id == sys_id ) &&
        ( mActorTable[ i ].user_id == user_id ) )
    { 
      mActorTable[ i ].enable_flag = false;
      mActorTable[ i ].actor_base->RemoveSceneModel();
      mActorRentalTotal[ act_no ]--;
      break;
    }
  }
  //RemoveScenełȂ
  GFL_ASSERT_MSG( i < mActorTableMax, "act=%d, sys=%d, user=%d", act_no, sys_id, user_id );
}

//-----------------------------------------------------------------------------
/**
 * @brief w肳ꂽActorBase擾
 *
 * @param[in]  act_no   擾AN^[No
 * @param[in]  sys_id   擾sys_id
 * @param[in]  user_id  擾user_id
 */
//-----------------------------------------------------------------------------
actor::ActorBase*  ActorManager::GetActorBase( s32 act_no, s32 sys_id, s32 user_id )
{ 
  s32 i;

  for( i = 0 ; i < mActorTableMax ; i++ )
  { 
    if( ( mActorTable[ i ].act_no == act_no ) &&
        ( mActorTable[ i ].sys_id == sys_id ) &&
        ( mActorTable[ i ].user_id == user_id ) )
    { 
      break;
    }
  }

  //擾łȂ
  GFL_ASSERT_STOP_MSG( i < mActorTableMax, "act_no = %d user_id = %d", act_no,user_id );

  return  mActorTable[ i ].actor_base;
}

//-----------------------------------------------------------------------------
/**
 * @brief w肳ꂽActorBase擾isys_idwŁj
 *
 * @param[in]  act_no   擾AN^[No
 * @param[in]  sys_id   擾sys_id
 */
//-----------------------------------------------------------------------------
actor::ActorBase*  ActorManager::GetActorBaseWithSysID( s32 act_no, s32 sys_id )
{ 
  s32 i;

  for( i = 0 ; i < mActorTableMax ; i++ )
  { 
    if( ( mActorTable[ i ].act_no == act_no ) &&
        ( mActorTable[ i ].sys_id == sys_id ) )
    { 
      break;
    }
  }

  //擾łȂ
  GFL_ASSERT_STOP( i < mActorTableMax );

  return  mActorTable[ i ].actor_base;
}

//-----------------------------------------------------------------------------
/**
 * @brief w肳ꂽActorBase擾iuser_idwŁj
 *
 * @param[in]  act_no   擾AN^[No
 * @param[in]  sys_id   擾sys_id
 */
//-----------------------------------------------------------------------------
actor::ActorBase*  ActorManager::GetActorBaseWithUserID( s32 act_no, s32 user_id )
{ 
  s32 i;

  for( i = 0 ; i < mActorTableMax ; i++ )
  { 
    if( ( mActorTable[ i ].act_no == act_no ) &&
        ( mActorTable[ i ].user_id == user_id ) )
    { 
      break;
    }
  }

  //擾łȂ
  GFL_ASSERT_STOP_MSG( i < mActorTableMax, "act_no:%d user_id:%d\n", act_no, user_id );

  return  mActorTable[ i ].actor_base;
}

//-----------------------------------------------------------------------------
/**
 * @brief w肳ꂽǗĂClass݂邩`FbN
 *
 * @param[in]  act_no   擾AN^[No
 * @param[in]  sys_id   擾sys_id
 * @param[in]  user_id  擾user_id
 *
 * @retval  true:݂@false:݂Ȃ
 */
//-----------------------------------------------------------------------------
bool  ActorManager::IsValidActorBase( s32 act_no, s32 sys_id, s32 user_id )
{ 
  bool ret = false;

  for( s32 i = 0 ; i < mActorTableMax ; i++ )
  { 
    if( ( mActorTable[ i ].actor_base ) &&
        ( mActorTable[ i ].act_no == act_no ) &&
        ( mActorTable[ i ].sys_id == sys_id ) &&
        ( mActorTable[ i ].user_id == user_id ) )
    { 
      ret = true;
      break;
    }
  }

  return  ret;
}

//-----------------------------------------------------------------------------
/**
 * @brief w肳ꂽActorBase݂邩`FbNisys_idwŁj
 *
 * @param[in]  act_no   擾AN^[No
 * @param[in]  sys_id   擾sys_id
 */
//-----------------------------------------------------------------------------
bool  ActorManager::IsValidActorBaseWithSysID( s32 act_no, s32 sys_id )
{ 
  bool ret = false;

  for( s32 i = 0 ; i < mActorTableMax ; i++ )
  { 
    if( ( mActorTable[ i ].actor_base ) &&
        ( mActorTable[ i ].act_no == act_no ) &&
        ( mActorTable[ i ].sys_id == sys_id ) )
    { 
      ret = true;
      break;
    }
  }

  return  ret;
}

//-----------------------------------------------------------------------------
/**
 * @brief w肳ꂽActorBase݂邩`FbNiuser_idwŁj
 *
 * @param[in]  act_no   擾AN^[No
 * @param[in]  user_id  擾user_id
 */
//-----------------------------------------------------------------------------
bool  ActorManager::IsValidActorBaseWithUserID( s32 act_no, s32 user_id )
{ 
  bool ret = false;

  for( s32 i = 0 ; i < mActorTableMax ; i++ )
  { 
    if( ( mActorTable[ i ].actor_base ) &&
        ( mActorTable[ i ].act_no == act_no ) &&
        ( mActorTable[ i ].user_id == user_id ) )
    { 
      ret = true;
      break;
    }
  }

  return  ret;
}

//-----------------------------------------------------------------------------
/**
 * @brief w肳ꂽǗĂClass݂AddSceneNodeĂ邩`FbN
 *
 * @param[in]  act_no   擾AN^[No
 * @param[in]  user_id  擾user_id
 *
 * @retval  true:݂@false:݂Ȃ
 */
//-----------------------------------------------------------------------------
bool  ActorManager::IsEnableActorBaseWithSysID( s32 act_no, s32 sys_id )
{ 
  bool ret = false;

  for( s32 i = 0 ; i < mActorTableMax ; i++ )
  { 
    if( ( mActorTable[ i ].actor_base ) &&
        ( mActorTable[ i ].enable_flag == true ) &&
        ( mActorTable[ i ].act_no == act_no ) &&
        ( mActorTable[ i ].sys_id == sys_id ) )
    { 
      ret = true;
      break;
    }
  }

  return  ret;
}

//-----------------------------------------------------------------------------
/**
 * @brief w肳ꂽǗĂClass݂AddSceneNodeĂ邩`FbN
 *
 * @param[in]  act_no   擾AN^[No
 * @param[in]  sys_id   擾sys_id
 * @param[in]  user_id  擾user_id
 *
 * @retval  true:݂@false:݂Ȃ
 */
//-----------------------------------------------------------------------------
bool  ActorManager::IsEnableActorBase( s32 act_no, s32 sys_id, s32 user_id )
{ 
  bool ret = false;

  for( s32 i = 0 ; i < mActorTableMax ; i++ )
  { 
    if( ( mActorTable[ i ].actor_base ) &&
        ( mActorTable[ i ].enable_flag == true ) &&
        ( mActorTable[ i ].act_no == act_no ) &&
        ( mActorTable[ i ].sys_id == sys_id ) &&
        ( mActorTable[ i ].user_id == user_id ) )
    { 
      ret = true;
      break;
    }
  }

  return  ret;
}

//-----------------------------------------------------------------------------
/**
 * @brief w肳ꂽǗĂClass݂AddSceneNodeĂ邩`FbN
 *
 * @param[in]  act_no   擾AN^[No
 * @param[in]  user_id  擾user_id
 *
 * @retval  true:݂@false:݂Ȃ
 */
//-----------------------------------------------------------------------------
bool  ActorManager::IsEnableActorBaseWithUserID( s32 act_no, s32 user_id )
{ 
  bool ret = false;

  for( s32 i = 0 ; i < mActorTableMax ; i++ )
  { 
    if( ( mActorTable[ i ].actor_base ) &&
        ( mActorTable[ i ].enable_flag == true ) &&
        ( mActorTable[ i ].act_no == act_no ) &&
        ( mActorTable[ i ].user_id == user_id ) )
    { 
      ret = true;
      break;
    }
  }

  return  ret;
}

} // namespace actor
