//===================================================================
/**
 * @file    actor_g3d_model.cpp
 * @brief   G3DUtilG3DfgpAN^[
 * @author  soga
 * @date    12.05.15
*/
//===================================================================

#pragma once

#include  "actor_g3d_model.h"

namespace actor {

//----------------------------------------------------------------------------
/**
 *	@brief    RXgN^
 */
//-----------------------------------------------------------------------------
ActorG3DModel::ActorG3DModel() :
  ActorModelBase(),
  mG3DUtil( NULL ),
  mHeap( NULL ),
  mModelID( NO_MODEL_ID )
{
}

//-----------------------------------------------------------------------------
/**
 * @brief fXgN^
 */
//-----------------------------------------------------------------------------
ActorG3DModel::~ActorG3DModel()
{ 
  if( mModelID != NO_MODEL_ID )
  { 
    mG3DUtil->DelG3dModel( mModelID );
    mModelID = NO_MODEL_ID;
  }
}

//-----------------------------------------------------------------------------
/**
 * @brief Update֐i]VEC3Łj
 */
//-----------------------------------------------------------------------------
void  ActorG3DModel::Update( const gfl::math::VEC3& trans, const gfl::math::VEC3& rotate, const gfl::math::VEC3& scale )
{ 
  if( mModelID != NO_MODEL_ID )
  { 
    gfl::grp::g3d::Model* model = mG3DUtil->GetModel( mModelID );
    model->SetTranslate( trans );
    model->SetRotateXYZ( rotate );
    model->SetScale( scale );
  }
}

//-----------------------------------------------------------------------------
/**
 * @brief Update֐i]MTX34Łj
 */
//-----------------------------------------------------------------------------
void  ActorG3DModel::Update( const gfl::math::VEC3& trans, const gfl::math::MTX34& mtx, const gfl::math::VEC3& scale )
{ 
  if( mModelID != NO_MODEL_ID )
  { 
    gfl::grp::g3d::Model* model = mG3DUtil->GetModel( mModelID );
  
    model->SetTranslate( trans );
    model->SetRotateMatrix( mtx );
    model->SetScale( scale );
  }
}

//-----------------------------------------------------------------------------
/**
 * @brief Aj[VZbg
 *
 * @param[in] anm_no ZbgAj[VNo
 */
//-----------------------------------------------------------------------------
void  ActorG3DModel::SetAnime( int anm_no )
{ 
  if( mModelID != NO_MODEL_ID )
  { 
    mG3DUtil->ChangeG3dModelAnime( mModelID, anm_no, mHeap );
  }
}

//-----------------------------------------------------------------------------
/**
 * @brief Aj[VI`FbN
 *
 * @param[in] none
 *
 * @retval  true:I false:p
 */
//-----------------------------------------------------------------------------
bool  ActorG3DModel::IsFinishAnime( void )
{ 
  bool  result = true;
  if( mModelID != NO_MODEL_ID )
  { 
    result = mG3DUtil->IsFinishG3dModelAnime( mModelID );
  }
  return result;
}

//-----------------------------------------------------------------------------
/**
 * @brief AddScene
 */
//-----------------------------------------------------------------------------
void  ActorG3DModel::AddSceneModel( void )
{ 
  if( mModelID != NO_MODEL_ID )
  { 
    gfl::grp::g3d::Model* model = mG3DUtil->GetModel( mModelID );
  
    model->SetTreeFlag( true );
    // @todo |PfƋƃGbW㏑̂ŎgGbWLɂKvH
    // TAP̃fGbWLɂƐ^ɂȂĂ܂̂ŁA̓RgAEg
    //mG3DUtil->GetScene()->SwitchEdgeMapModel( mG3DUtil->GetModel( mModelID ), true );
  }
}

//-----------------------------------------------------------------------------
/**
 * @brief RemoveScene
 */
//-----------------------------------------------------------------------------
void  ActorG3DModel::RemoveSceneModel( void )
{ 
  if( mModelID != NO_MODEL_ID )
  { 
    gfl::grp::g3d::Model* model = mG3DUtil->GetModel( mModelID );
  
    model->SetTreeFlag( false );
    SetVisible( false );
    // @todo |PfƋƃGbW㏑̂ŎgGbWLɂKvH
    // TAP̃fGbWLɂƐ^ɂȂĂ܂̂ŁA̓RgAEg
    //mG3DUtil->GetScene()->SwitchEdgeMapModel( mG3DUtil->GetModel( mModelID ), false );
  }
}

//-----------------------------------------------------------------------------
/**
 * @brief SetVisible
 *
 * @param[in] flag  true:\@false:\
 */
//-----------------------------------------------------------------------------
void  ActorG3DModel::SetVisible( bool flag )
{ 
  if( mModelID != NO_MODEL_ID )
  { 
    gfl::grp::g3d::Model* model = mG3DUtil->GetModel( mModelID );
  
    model->SetVisible( flag );
  }
}

//-----------------------------------------------------------------------------
/**
 * @brief GetVisible
 *
 * @retval  true:\ false:\
 */
//-----------------------------------------------------------------------------
bool  ActorG3DModel::GetVisible( void ) const
{
  bool result = false;

  if( mModelID != NO_MODEL_ID )
  { 
    gfl::grp::g3d::Model* model = mG3DUtil->GetModel( mModelID );
  
    result = model->IsVisible();
  }

  return result;
}

//-----------------------------------------------------------------------------
/**
 * @brief SetConstantColor
 *
 * @param[in] col ZbgJ[
 * @param[in] no  ZbgRX^gJ[io[
 */
//-----------------------------------------------------------------------------
void  ActorG3DModel::SetConstantColor( const gfl::grp::ColorF32 col, const int col_no )
{ 
  if( mModelID != NO_MODEL_ID )
  { 
    gfl::grp::g3d::Model* model = mG3DUtil->GetModel( mModelID );
  
    for( s32 no = 0 ; no < model->GetMaterialCount() ; no++ )
    { 
      model->SetMaterialColorConstant( no, col_no, col );
    }
  }
}

//-----------------------------------------------------------------------------
/**
 * @brief GetNodePosition
 *
 * @param[in]   node  擾m[hCfbNX
 * @param[out]  pos   擾|WV̊i[
 */
//-----------------------------------------------------------------------------
void  ActorG3DModel::GetNodePosition( int node, gfl::math::VEC3* pos )
{ 
  if( mModelID != NO_MODEL_ID )
  { 
    gfl::grp::g3d::Model* model = mG3DUtil->GetModel( mModelID );

    gfl::math::MTX34* mtx = model->GetBoneMatrixPointerOfWorldMatrixPose( node );
    pos->x = mtx->_03;
    pos->y = mtx->_13;
    pos->z = mtx->_23;
  }
}

//-----------------------------------------------------------------------------
/**
 * @brief Model
 */
//-----------------------------------------------------------------------------
void  ActorG3DModel::CreateModel( app::util::G3DUtil* util, gfl::fs::ArcFile* af, gfl::fs::ArcFile::ARCDATID mdlID, app::util::Heap* heap, app::util::G3DUtil::ANIME_DATA* anm, u32 anmMax )
{ 
  // @todo G3dUtil̃\[XǗ@\쐬i\[X̎g܂킵ɑΉł͂j
  mG3DUtil = util;
  mHeap    = heap;
  // @todo f\[X͈k݂̂ǁA񈳏kɂΉ邩v
  mModelID = mG3DUtil->AddG3dModel( af, mdlID, heap, app::util::G3DUtil::ADD_MODEL_ID_FREE, anm, anmMax, true );
  this->RemoveSceneModel();
}

} // namespace actor
