//===================================================================
/**
 * @file    actor_factory.h
 * @brief   AN^[t@Ng[
 * @author  soga
 * @date    12.05.15
*/
//===================================================================

#ifndef __ACTOR_FACTORY_H__
#define __ACTOR_FACTORY_H__

#include "ActorModelBase.h"

namespace actor {
	class ActorManager;
	class ActorBase;
  class ActorResourceManager;

  class ActorFactory
  { 
    private:
    app::util::G3DUtil*           mG3DUtil;
    app::util::Heap*              mHeap;
    actor::ActorManager*          mActorManager;
    actor::ActorResourceManager*  mActorResourceManager;

    public:
    //----------------------------------------------------------------------------
    /**
    *	@brief  RXgN^
    *
    * @param  actor_manager   AN^[}l[W
    */
    //-----------------------------------------------------------------------------
    ActorFactory( app::util::G3DUtil* util, app::util::Heap* heap, actor::ActorManager* actor_manager, actor::ActorResourceManager* actor_resource_manager );

    //----------------------------------------------------------------------------
    /**
    *	@brief  fXgN^
    */
    //-----------------------------------------------------------------------------
    ~ActorFactory();

    //----------------------------------------------------------------------------
    /**
    *	@brief  CreateActor
    * @param[in]  act_no          AN^[No
    */
    //-----------------------------------------------------------------------------
    void  CreateActor( const u32 act_no );

    private:
    actor::ActorBase*  CreateActorBase( const u32 act_no, actor::ActorModelBase* model );

  };

} // namespace actor

#endif //__ACTOR_FACTORY_H__
