//===================================================================
/**
 * @file    actor_factory.cpp
 * @brief   AN^[t@Ng[
 * @author  soga
 * @date    12.05.15
*/
//===================================================================

#include "ActorBase.h"
#include "actor_factory.h"
#include "actor_manager.h"
#include "actor_resource_manager.h"
#include "actor_g3d_model.h"
#include "sparring_boss_actor.h"
#include "sparring_enemy_actor.h"

namespace actor {

typedef actor::ActorBase* (*CreateFunc)( gfl::heap::HeapBase* heap, const u32 act_no, actor::ActorModelBase* model );
static  actor::ActorBase*  CreateDefault( gfl::heap::HeapBase* heap, const u32 act_no, actor::ActorModelBase* model );
static  actor::ActorBase*  CreatePlayer( gfl::heap::HeapBase* heap, const u32 act_no, actor::ActorModelBase* model );
static  actor::ActorBase*  CreateBoss( gfl::heap::HeapBase* heap, const u32 act_no, actor::ActorModelBase* model );
static  actor::ActorBase*  CreateEnemy( gfl::heap::HeapBase* heap, const u32 act_no, actor::ActorModelBase* model);

typedef struct
{ 
  CreateFunc  createFunc;   //NGCg֐
}CREATE_TABLE;

#include "create_sparring_func.cdat"

//----------------------------------------------------------------------------
/**
 *	@brief  RXgN^
 *
 *  @param  actor_manager           AN^[}l[W
 *  @param  actor_resource_manager  AN^[\[X}l[W
 */
//-----------------------------------------------------------------------------
ActorFactory::ActorFactory( app::util::G3DUtil* util, app::util::Heap* heap, actor::ActorManager* actor_manager, actor::ActorResourceManager* actor_resource_manager ) :
  mG3DUtil( util ),
  mHeap( heap ),
  mActorManager( actor_manager ),
  mActorResourceManager( actor_resource_manager )
{ 
}

//----------------------------------------------------------------------------
/**
 *	@brief  fXgN^
 */
//-----------------------------------------------------------------------------
ActorFactory::~ActorFactory()
{ 
}

//----------------------------------------------------------------------------
/**
 *	@brief  CreateActor
 * @param[in]  act_no           AN^[No
 */
//-----------------------------------------------------------------------------
void  ActorFactory::CreateActor( const u32 act_no )
{ 
  actor::ActorModelBase* model = NULL;
  gfl::fs::ArcFile::ARCDATID  datID = mActorResourceManager->GetModelIdx( act_no );
  if( datID != 0xffffffff )
  { 
    actor::ActorG3DModel* g3d_model = GFL_NEW( mHeap->GetSystemHeap() ) actor::ActorG3DModel();
    int anm_max;
    ActAnmData::ANM_IDXS  idxs;
    app::util::G3DUtil::ANIME_DATA* anm_data = mActorResourceManager->CreateAnimeData( mHeap->GetSystemHeap(), act_no, 0, &anm_max, &idxs );

    g3d_model->CreateModel( mG3DUtil, mActorResourceManager->GetG3DResourceArcFile(), datID, mHeap, anm_data, anm_max );
    if( idxs.FirstSklaIdx != 0xffffffff )
    { 
      g3d_model->SetAnime( idxs.FirstSklaIdx );
    }
    if( idxs.FirstMataIdx != 0xffffffff )
    { 
      g3d_model->SetAnime( idxs.FirstMataIdx );
    }

    GflHeapFreeMemory( anm_data );

    model = g3d_model;
  }
  actor::ActorBase* actor_base = CreateActorBase( act_no, model );
  mActorManager->RegistrationActor( act_no, actor_base );
}

actor::ActorBase*  ActorFactory::CreateActorBase( const u32 act_no, actor::ActorModelBase* model )
{
  if (act_no < GFL_NELEMS( create_sparring_func ) )
  {
    if( create_sparring_func[ act_no ].createFunc != NULL )
    {
      return create_sparring_func[ act_no ].createFunc( mHeap->GetSystemHeap(), act_no, model );
    }
  }
  GFL_ASSERT_MSG(0,"NOT EXITST CreateFunc");
  return CreateDefault( mHeap->GetSystemHeap(), act_no, model );
}

static  actor::ActorBase*  CreateDefault( gfl::heap::HeapBase* heap, const u32 act_no, actor::ActorModelBase* model )
{ 
  actor::ActorBase* actor_base = GFL_NEW( heap ) actor::ActorBase();
  actor_base->SetActNo( act_no );
  actor_base->SetModel( model );
  return actor_base;
}

static  actor::ActorBase*  CreatePlayer( gfl::heap::HeapBase* heap, const u32 act_no, actor::ActorModelBase* model )
{ 
  //actor::ActorBase* actor_base = GFL_NEW( heap ) actor::PlayerActor();
  actor::ActorBase* actor_base = GFL_NEW( heap ) actor::ActorBase();
  actor_base->SetActNo( act_no );
  actor_base->SetModel( model );
  return actor_base;
}

static  actor::ActorBase*  CreateBoss( gfl::heap::HeapBase* heap, const u32 act_no, actor::ActorModelBase* model )
{ 
  actor::ActorBase* actor_base = GFL_NEW( heap ) actor::SparringBossActor();
  actor_base->SetActNo( act_no );
  actor_base->SetModel( model );
  return actor_base;
}

static  actor::ActorBase*  CreateEnemy( gfl::heap::HeapBase* heap, const u32 act_no, actor::ActorModelBase* model )
{ 
  actor::ActorBase* actor_base = GFL_NEW( heap ) actor::SparringEnemyActor();
  actor_base->SetActNo( act_no );
  actor_base->SetModel( model );
  return actor_base;
}

} // namespace actor
