//===================================================================
/**
 * @file    actor_collision.h
 * @brief   AN^[m̓蔻
 * @author  soga
 * @date    12.05.24
*/
//===================================================================

#ifndef __ACTOR_COLLISION_H__
#define __ACTOR_COLLISION_H__

#include  "gflib.h"
#include  "ActorBase.h"

namespace actor {

  class ActorCollision
  { 
    GFL_FORBID_COPY_AND_ASSIGN( ActorCollision );

    private:
    ActorBase** mCollisionTable;
    s32         mCollisionTableMax;

    public:
    //----------------------------------------------------------------------------
    /**
     *	@brief    RXgN^
     *
     *	@param[in]  heap      q[v
     *	@param[in]  table_max RWe[u̍ő吔
     */
    //-----------------------------------------------------------------------------
    ActorCollision( gfl::heap::HeapBase* heap, const s32 table_max );

    //----------------------------------------------------------------------------
    /**
     *	@brief    fXgN^
     */
    //-----------------------------------------------------------------------------
    ~ActorCollision();

    //----------------------------------------------------------------------------
    /**
     *	@brief    RWe[uɓo^
     *
     *	@param[in]  actor_base  o^AN^[
     *
     *	@retval RWe[uCfbNX
     */
    //-----------------------------------------------------------------------------
    s32  RegistCollisionTable( ActorBase* actor_base );

    //----------------------------------------------------------------------------
    /**
     *	@brief    RWe[u폜
     *
     *	@param[in]  index RWe[uCfbNX
     */
    //-----------------------------------------------------------------------------
    void  RemoveCollisionTable( const s32 index );

    //----------------------------------------------------------------------------
    /**
     *	@brief    RW`FbN
     *
     *	@param[in]  actor_base  `FbNAN^[
     *
     *	@retval true:qbg false:m[qbg
     */
    //-----------------------------------------------------------------------------
    bool  CheckCollision( ActorBase* actor_base );

    //----------------------------------------------------------------------------
    /**
     *	@brief    RW`FbN
     *
     *	@param[in]  pos     `FbNW
     *	@param[in]  radius  `FbN͈
     *
     *	@retval true:qbg false:m[qbg
     */
    //-----------------------------------------------------------------------------
    bool  CheckCollision( const gfl::math::VEC3& pos, f32 radius );

  };

} //namespace actor

#endif //__ACTOR_COLLISION_H__
