//===================================================================
/**
 * @file    actor_collision.cpp
 * @brief   AN^[m̓蔻
 * @author  soga
 * @date    12.05.24
*/
//===================================================================

#include  "actor_collision.h"

namespace actor {

//----------------------------------------------------------------------------
/**
 *	@brief    RXgN^
 *
 *	@param[in]  heap      q[v
 *	@param[in]  table_max RWe[u̍ő吔
 */
//-----------------------------------------------------------------------------
ActorCollision::ActorCollision( gfl::heap::HeapBase* heap, const s32 table_max )
{ 
  mCollisionTable = GFL_NEW( heap ) ActorBase*[ table_max ];
  mCollisionTableMax = table_max;

  for( s32 i = 0 ; i < table_max ; i++ )
  { 
    mCollisionTable[ i ] = NULL;
  }
}

//----------------------------------------------------------------------------
/**
 *	@brief    fXgN^
 */
//-----------------------------------------------------------------------------
ActorCollision::~ActorCollision()
{ 
  GFL_DELETE_ARRAY( mCollisionTable );
}

//----------------------------------------------------------------------------
/**
 *	@brief    RWe[uɓo^
 *
 *	@param[in]  actor_base  o^AN^[
 *
 *	@retval RWe[uCfbNX
 */
//-----------------------------------------------------------------------------
s32  ActorCollision::RegistCollisionTable( ActorBase* actor_base )
{ 
  s32 i;
  for( i = 0 ; i < mCollisionTableMax ; i++ )
  { 
    if( mCollisionTable[ i ] == NULL )
    { 
      mCollisionTable[ i ] = actor_base;
      break;
    }
  }
  GFL_ASSERT( i < mCollisionTableMax );
  return i;
}

//----------------------------------------------------------------------------
/**
 *	@brief    RWe[u폜
 *
 *	@param[in]  index RWe[uCfbNX
 */
//-----------------------------------------------------------------------------
void  ActorCollision::RemoveCollisionTable( const s32 index )
{ 
  GFL_ASSERT( index < mCollisionTableMax );
  mCollisionTable[ index ] = NULL;
}

//----------------------------------------------------------------------------
/**
 *	@brief    RW`FbN
 *
 *	@param[in]  actor_base  `FbNAN^[
 *
 *	@retval true:qbg false:m[qbg
 */
//-----------------------------------------------------------------------------
bool  ActorCollision::CheckCollision( ActorBase* actor_base )
{ 
  bool  result = false;

  for( s32 i = 0 ; i < mCollisionTableMax ; i++ )
  { 
    if( mCollisionTable[ i ] != NULL )
    { 
      gfl::math::VEC3 src_pos = actor_base->GetCalcTranslate();
      gfl::math::VEC3 dst_pos = mCollisionTable[ i ]->GetCalcTranslate();
      f32 distance = actor_base->GetCollisionRadius() + mCollisionTable[ i ]->GetCollisionRadius();
      if( gfl::math::VEC3Dist( &src_pos, &dst_pos ) < distance )
      { 
        actor_base->SetCollision( true );
        mCollisionTable[ i ]->SetCollision( true );
        result = true;
      }
    }
  }

  return result;
}

//----------------------------------------------------------------------------
/**
 *	@brief    RW`FbN
 *
 *	@param[in]  pos     `FbNW
 *	@param[in]  radius  `FbN͈
 *
 *	@retval true:qbg false:m[qbg
 */
//-----------------------------------------------------------------------------
bool  ActorCollision::CheckCollision( const gfl::math::VEC3& pos, f32 radius )
{ 
  bool  result = false;

  for( s32 i = 0 ; i < mCollisionTableMax ; i++ )
  { 
    if( mCollisionTable[ i ] != NULL )
    { 
      gfl::math::VEC3 dst_pos = mCollisionTable[ i ]->GetCalcTranslate();
      f32 distance = radius + mCollisionTable[ i ]->GetCollisionRadius();
      if( gfl::math::VEC3Dist( &pos, &dst_pos ) < distance )
      { 
        mCollisionTable[ i ]->SetCollision( true );
        result = true;
      }
    }
  }

  return result;
}

} //namespace actor

