//===================================================================
/**
 * @file    act_anm_data.h
 * @brief   AjǗf[^iTTQXYpɃJX^}CYj
 * @author  saito changed by soga
 * @date    12.05.17
*/
//===================================================================
#ifndef __ACT_ANM_DATA_H__
#define __ACT_ANM_DATA_H__

#include  "app/util/app_util_3d.h"

namespace actor
{

class ActAnmData
{
  public:
  static const u32 NONE_CODE = 0xffffffff;

  //oCiˑ
  struct ACTION_DATA
  {
    int DataOfs;
    u32 SklaIdx;
    u32 MataIdx;
  };
  struct ANM_IDXS
  {
    u32 FirstSklaIdx;
    u32 FirstMataIdx;
  };
  struct ANM_DATA_COUNT
  {
    int AnmCountSkla;
    int AnmCountMata;
  };
  //oCiˑ

  private:
  int mAnmTopIdx;
  int mPatternNum;
  int* mPatternActNumAry;
  int* mActionTopIdxAry;
  ANM_IDXS* mAnmFirstIdxAry;
  ANM_DATA_COUNT* mAnmDataCountAry;
  ACTION_DATA* mActionDataAry;

  public:
  ActAnmData();
  ActAnmData( const int inAnmTopIdx );
  void SetData(void* pData);

  int GetActionNum( const int inPatternNo );
  ActAnmData::ACTION_DATA* GetActionDataPtr( const int inPatternNo, const int anm_no );
  int GetPatternNum(void){ return mPatternNum; }
  int GetAnmIdx( const int inPatternNo, const int anm_no );
  ActAnmData::ANM_IDXS* GetFirstAnmIdxs( const int inPatternNo );
  ActAnmData::ANM_DATA_COUNT* GetAnmDataCount( const int inPatternNo );
  app::util::G3DUtil::ANIME_DATA* CreateAnimeData( gfl::heap::HeapBase* heap, const int inPatternNo );

};

} //namespace actor

#endif //__ACT_ANM_DATA_H__
