//===================================================================
/**
 * @file    act_anm_data.cpp
 * @brief   AjǗf[^iTTQXYpɃJX^}CYj
 * @author  saito changed by soga
 * @date    12.05.17
*/
//===================================================================

#include <gflib.h>

#include "act_anm_data.h"

namespace actor
{

//----------------------------------------------------------------------------
/**
 *	@brief  RXgN^
 */
//-----------------------------------------------------------------------------
ActAnmData::ActAnmData()
{
  mAnmTopIdx = 0;
  mPatternNum = 0;
  mPatternActNumAry = NULL;
  mAnmDataCountAry = NULL;
  mActionDataAry = NULL;
}
//----------------------------------------------------------------------------
/**
 *	@brief  RXgN^
 */
//-----------------------------------------------------------------------------
ActAnmData::ActAnmData( const int inAnmTopIdx )
{
  mAnmTopIdx = inAnmTopIdx;
  mPatternNum = 0;
  mPatternActNumAry = NULL;
  mAnmDataCountAry = NULL;
  mActionDataAry = NULL;
}

//----------------------------------------------------------------------------
/**
 *	@brief  f[^Zbg
 *
 *  @param  pData   f[^|C^
 */
//-----------------------------------------------------------------------------
void ActAnmData::SetData( void* pData )
{
  int* data = (int*)(pData);
  mPatternNum = *data;
  data++;
  mPatternActNumAry = data;
  data += mPatternNum;

  mActionTopIdxAry = data;
  data += mPatternNum;

  mAnmFirstIdxAry = (ANM_IDXS*)data;
  int size = (sizeof(ANM_IDXS) / sizeof(int)) * mPatternNum;
  data += size;

  mAnmDataCountAry = (ANM_DATA_COUNT*)data;
  size = (sizeof(ANM_DATA_COUNT) / sizeof(int)) * mPatternNum;
  data += size;

  mActionDataAry = (ACTION_DATA*)data;
}

//----------------------------------------------------------------------------
/**
 *	@brief  ANVio[擾
 *  @param  inPatternNo       p^[io[
 *  @return int io[
 */
//-----------------------------------------------------------------------------
int ActAnmData::GetActionNum( const int inPatternNo )
{
  if( inPatternNo < mPatternNum )
  {
    return mPatternActNumAry[inPatternNo];
  }
  GFL_ASSERT(0);
  return 0;
}

//----------------------------------------------------------------------------
/**
 *	@brief  ANVf[^|C^擾
 *  @param  inPatternNo     p^[io[
 *  @param  anm_no          Ajio[
 *  @return ACTION_DATA*
 */
//-----------------------------------------------------------------------------
ActAnmData::ACTION_DATA* ActAnmData::GetActionDataPtr( const int inPatternNo, const int anm_no )
{
  if( inPatternNo < mPatternNum )
  { 
    ActAnmData::ACTION_DATA* act_anm_data = &mActionDataAry[ mActionTopIdxAry[ inPatternNo ] ];
    return &act_anm_data[ anm_no ];
  }
  GFL_ASSERT_STOP(0);
  return NULL;
}

//----------------------------------------------------------------------------
/**
 *	@brief  AjCfbNX擾
 *  @param  inPatternNo     p^[io[
 *  @param  anm_no          Ajio[
 *  @return int
 */
//-----------------------------------------------------------------------------
int ActAnmData::GetAnmIdx( const int inPatternNo, const int anm_no )
{ 
  return mAnmTopIdx + GetActionDataPtr( inPatternNo, anm_no )->DataOfs;
}

//----------------------------------------------------------------------------
/**
 *	@brief  AjCfbNXf[^擾
 *  @param  inPatternNo     p^[io[
 *  @return ANM_IDXS*
 */
//-----------------------------------------------------------------------------
ActAnmData::ANM_IDXS* ActAnmData::GetFirstAnmIdxs( const int inPatternNo )
{
  if( inPatternNo < mPatternNum )
  {
    return &mAnmFirstIdxAry[inPatternNo];
  }
  GFL_ASSERT_STOP(0);
  return NULL;
}

//----------------------------------------------------------------------------
/**
 *	@brief  AjCfbNXf[^擾
 *  @param  inPatternNo     p^[io[
 *  @return ANM_IDXS*
 */
//-----------------------------------------------------------------------------
ActAnmData::ANM_DATA_COUNT* ActAnmData::GetAnmDataCount( const int inPatternNo )
{ 
  if( inPatternNo < mPatternNum )
  {
    return &mAnmDataCountAry[inPatternNo];
  }
  GFL_ASSERT_STOP(0);
  return NULL;
}

//----------------------------------------------------------------------------
/**
 *	@brief  G3dUtilɓnAjf[^\̂𐶐
 *
 *  @param[in]  heap          anm_data쐬邽߂̃q[v
 *  @param[in]  inPatternNo   p^[io[
 *
 *  @retval anm_data          Ajf[^\̂̃|C^iĂяoŉĂj@todo AbNȂ`ɂ
 */
//-----------------------------------------------------------------------------
app::util::G3DUtil::ANIME_DATA* ActAnmData::CreateAnimeData( gfl::heap::HeapBase* heap, const int inPatternNo )
{ 
  int num = GetActionNum( inPatternNo );
  app::util::G3DUtil::ANIME_DATA* anm_data = ( app::util::G3DUtil::ANIME_DATA* )GflHeapAllocMemory( heap, sizeof( app::util::G3DUtil::ANIME_DATA ) * num );

  for( s32 i = 0 ; i < num ; i++ )
  { 
    ACTION_DATA* action_data = GetActionDataPtr( inPatternNo, i );
    anm_data[ i ].skl = action_data->SklaIdx;
    anm_data[ i ].mts = action_data->MataIdx;
  }

  return anm_data;
}

} //namespace ttq_system


