//===================================================================
/**
 * @file    ActorBase.h
 * @brief   AN^[x[X
 * @author  soga
 * @date    12.05.14
*/
//===================================================================

#ifndef __ACTOR_BASE_H__
#define __ACTOR_BASE_H__

#include  "gflib.h"
#include  "ActorModelBase.h"

namespace actor {

  typedef enum
  { 
    ACT_MOVE_RESULT_CONTINUE = 0,
    ACT_MOVE_RESULT_FINISH,
  }ACT_MOVE_RESULT;

  class ActorBase
  { 
    GFL_FORBID_COPY_AND_ASSIGN( ActorBase );

    protected:
    s32               mSeqNo;             //V[PXio[
    u32               mActNo;
    ActorModelBase*   mModel;             //Ǘ郂f
    gfl::math::VEC3   mTranslate;         //|WV
    gfl::math::VEC3   mOfs;               //|WVItZbg
    gfl::math::VEC3   mRotate;            //Ӗ]px
    gfl::math::VEC3   mScale;             //XP[
    bool              mRotateMatrixFlag;  //Updateɉ]͍sgp邩ǂtO
    bool              mCollision;         //ڐGtO
    f32               mCollisionRadius;   //ڐG苅̔a
    s32               mCollisionIndex;    //ڐGe[uCfbNX
    gfl::math::MTX34  mRotateMatrix;      //Ӗ]s

    private:

    public:
    //----------------------------------------------------------------------------
    /**
     *	@brief    RXgN^
     */
    //-----------------------------------------------------------------------------
    ActorBase() :
    mSeqNo( 0 ),
    mActNo( 0 ),
    mModel( NULL ),
    mTranslate( 0.0f, 0.0f, 0.0f ),
    mOfs( 0.0f, 0.0f, 0.0f ),
    mRotate( 0.0f, 0.0f, 0.0f ),
    mScale( 1.0f, 1.0f, 1.0f ),
    mRotateMatrixFlag( false ),
    mCollision( false ),
    mCollisionRadius( 5.0f ),
    mCollisionIndex( 0 )
    {
      mRotateMatrix = gfl::math::MTX34::Identity();
    }

    //-----------------------------------------------------------------------------
    /**
     * @brief fXgN^
     */
    //-----------------------------------------------------------------------------
    virtual ~ActorBase()
    {
      if( mModel )
      { 
        GFL_DELETE  mModel;
      }
    }

    //-----------------------------------------------------------------------------
    /**
     * @brief ֐
     *
     * @retval ACT_MOVE_RESULT_CONTINUE p@ACT_MOVE_RESULT_FINISH I
     */
    //-----------------------------------------------------------------------------
    virtual ACT_MOVE_RESULT Move( void* act_move_param )
    { 
      GFL_UNUSED( act_move_param );
      //Ȃ
      return ACT_MOVE_RESULT_CONTINUE;
    }

    //-----------------------------------------------------------------------------
    /**
     * @brief AN^[io[Zbg
     *
     * @param[in] act_no ZbgAN^[io[
     */
    //-----------------------------------------------------------------------------
    virtual void  SetActNo( const u32 act_no )
    { 
      mActNo = act_no;
    }

    //-----------------------------------------------------------------------------
    /**
     * @brief fZbg
     *
     * @param[in] model Zbg郂f
     */
    //-----------------------------------------------------------------------------
    virtual void  SetModel( ActorModelBase* model )
    { 
      mModel = model;
    }

    //-----------------------------------------------------------------------------
    /**
     * @brief Update֐
     */
    //-----------------------------------------------------------------------------
    virtual void  Update( void )
    { 
      if( mModel )
      { 
        gfl::math::VEC3 pos = mTranslate + mOfs;
        if( mRotateMatrixFlag )
        { 
          mModel->Update( pos, mRotateMatrix, mScale );
        }
        else
        { 
          mModel->Update( pos, mRotate, mScale );
        }
      }
    }

    //-----------------------------------------------------------------------------
    /**
     * @brief Aj[VZbg
     *
     * @param[in] anm_no ZbgAj[VNo
     */
    //-----------------------------------------------------------------------------
    virtual void  SetAnime( const int anm_no )
    {
      GFL_ASSERT( mModel );
      if( mModel )
      { 
        mModel->SetAnime( anm_no );
      }
    }

    //-----------------------------------------------------------------------------
    /**
     * @brief Aj[VI`FbN
     *
     * @param[in] none
     *
     * @retval  true:I false:p
     */
    //-----------------------------------------------------------------------------
    virtual bool  IsFinishAnime( void )
    { 
      GFL_ASSERT( mModel );
      bool  result = true;
      if( mModel )
      { 
        result = mModel->IsFinishAnime();
      }
      return result;
    }

    //-----------------------------------------------------------------------------
    /**
     * @brief WZbg
     *
     * @param[in] pos ZbgW
     */
    //-----------------------------------------------------------------------------
    virtual void  SetTranslate( const gfl::math::VEC3& trans )
    {
      mTranslate = trans;
    }

    //-----------------------------------------------------------------------------
    /**
     * @brief WQbg
     *
     * @param none
     */
    //-----------------------------------------------------------------------------
    virtual gfl::math::VEC3  GetTranslate( void ) const
    {
      return mTranslate;
    }

    //-----------------------------------------------------------------------------
    /**
     * @brief WQbg(ItZbglvŹj
     *
     * @param none
     */
    //-----------------------------------------------------------------------------
    virtual gfl::math::VEC3  GetCalcTranslate( void ) const
    {
      return mTranslate + mOfs;
    }

    //-----------------------------------------------------------------------------
    /**
     * @brief WItZbgZbg
     *
     * @param[in] pos ZbgW
     */
    //-----------------------------------------------------------------------------
    virtual void  SetOfs( const gfl::math::VEC3& ofs )
    {
      mOfs = ofs;
    }

    //-----------------------------------------------------------------------------
    /**
     * @brief WItZbgQbg
     *
     * @param none
     */
    //-----------------------------------------------------------------------------
    virtual gfl::math::VEC3  GetOfs( void ) const
    {
      return mOfs;
    }

    //-----------------------------------------------------------------------------
    /**
     * @brief p]pxZbg
     *
     * @param[in] rotate Zbg]px
     */
    //-----------------------------------------------------------------------------
    virtual void  SetRotate( const gfl::math::VEC3& rotate )
    {
      mRotate = rotate;
      mRotateMatrixFlag = false;
    }

    //-----------------------------------------------------------------------------
    /**
     * @brief p]pxQbg
     *
     * @param none
     */
    //-----------------------------------------------------------------------------
    virtual gfl::math::VEC3  GetRotate( void ) const
    {
      return mRotate;
    }

    //-----------------------------------------------------------------------------
    /**
     * @brief p]sZbg
     *
     * @param[in] mtx Zbg]s
     */
    //-----------------------------------------------------------------------------
    virtual void  SetRotateMatrix( const gfl::math::MTX34& mtx )
    {
      mRotateMatrix = mtx;
      mRotateMatrixFlag = true;
    }

    //-----------------------------------------------------------------------------
    /**
     * @brief p]sQbg
     *
     * @param none
     */
    //-----------------------------------------------------------------------------
    virtual gfl::math::MTX34  GetRotateMatrix( void ) const
    {
      return mRotateMatrix;
    }

    //-----------------------------------------------------------------------------
    /**
     * @brief XP[Zbg
     *
     * @param[in] rotate Zbg]px
     */
    //-----------------------------------------------------------------------------
    virtual void  SetScale( const gfl::math::VEC3& scale )
    {
      mScale = scale;
    }

    //-----------------------------------------------------------------------------
    /**
     * @brief XP[Qbg
     *
     * @param none
     */
    //-----------------------------------------------------------------------------
    virtual gfl::math::VEC3  GetScale( void ) const
    {
      return mScale;
    }

    //-----------------------------------------------------------------------------
    /**
     * @brief RWtOZbg
     *
     * @param[in] flag ZbgtO
     */
    //-----------------------------------------------------------------------------
    virtual void  SetCollision( const bool  flag )
    {
      mCollision = flag;
    }

    //-----------------------------------------------------------------------------
    /**
     * @brief RWtOQbg
     *
     * @param none
     */
    //-----------------------------------------------------------------------------
    virtual bool  GetCollision( void ) const
    {
      return mCollision;
    }

    //-----------------------------------------------------------------------------
    /**
     * @brief RWaZbg
     *
     * @param[in] radius Zbg锼a
     */
    //-----------------------------------------------------------------------------
    virtual void  SetCollisionRadius( const f32 radius )
    {
      mCollisionRadius = radius;
    }

    //-----------------------------------------------------------------------------
    /**
     * @brief RWaQbg
     *
     * @param none
     */
    //-----------------------------------------------------------------------------
    virtual f32  GetCollisionRadius( void ) const
    {
      return mCollisionRadius;
    }

    //-----------------------------------------------------------------------------
    /**
     * @brief RWe[uCfbNXZbg
     *
     * @param[in] index ZbgCfbNX
     */
    //-----------------------------------------------------------------------------
    virtual void  SetCollisionIndex( const s32 index )
    {
      mCollisionIndex = index;
    }

    //-----------------------------------------------------------------------------
    /**
     * @brief RWCfbNXQbg
     *
     * @param none
     */
    //-----------------------------------------------------------------------------
    virtual s32  GetCollisionIndex( void ) const
    {
      return mCollisionIndex;
    }

    //-----------------------------------------------------------------------------
    /**
     * @brief AddScene
     */
    //-----------------------------------------------------------------------------
    virtual void  AddSceneModel( void )
    { 
      GFL_ASSERT( mModel );
      if( mModel )
      { 
        mModel->AddSceneModel();
      }
    }

    //-----------------------------------------------------------------------------
    /**
     * @brief RemoveScene
     */
    //-----------------------------------------------------------------------------
    virtual void  RemoveSceneModel( void )
    { 
      GFL_ASSERT( mModel );
      if( mModel )
      { 
        mModel->RemoveSceneModel();
      }
    }

    //-----------------------------------------------------------------------------
    /**
     * @brief SetVisible
     *
     * @param[in] flag  true:\ false:\
     */
    //-----------------------------------------------------------------------------
    virtual void  SetVisible( bool flag )
    { 
      GFL_ASSERT( mModel );
      if( mModel )
      { 
        mModel->SetVisible( flag );
      }
    }

    //-----------------------------------------------------------------------------
    /**
     * @brief GetVisible
     *
     * @retval  true:\ false:\
     */
    //-----------------------------------------------------------------------------
    virtual bool  GetVisible( void ) const
    { 
      GFL_ASSERT( mModel );
      bool result = false;
      if( mModel )
      { 
        result = mModel->GetVisible();
      }
      return result;
    }

    //-----------------------------------------------------------------------------
    /**
     * @brief SetConstantColor
     *
     * @param[in] col ZbgJ[
     * @param[in] no  ZbgRX^gJ[io[
     */
    //-----------------------------------------------------------------------------
    virtual void  SetConstantColor( gfl::grp::ColorF32 col, const int col_no = 0 )
    { 
      GFL_ASSERT( mModel );
      if( mModel )
      { 
        mModel->SetConstantColor( col, col_no );
      }
    }

    //-----------------------------------------------------------------------------
    /**
     * @brief GetNodePosition
     *
     * @param[in]   node  擾m[hCfbNX
     * @param[out]  pos   擾|WV̊i[
     */
    //-----------------------------------------------------------------------------
    virtual void  GetNodePosition( int node, gfl::math::VEC3* pos )
    { 
      GFL_ASSERT( mModel );
      if( mModel )
      { 
        mModel->GetNodePosition( node, pos );
      }
    }

  };

} // namespace actor

#endif //__ACTOR_BASE_H__
