//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *
 *	@file		poke_number.cpp
 *	@brief  |PԍNXiS}Ӕԍn}Ӕԍj
 *	@author	Toru=Nagihashi
 *	@date		2012.05.24
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]

#include <poke_tool/poke_number.h>

GFL_NAMESPACE_BEGIN(poke_tool)


//--------------------------------------------------------------------
// RXgN^
//--------------------------------------------------------------------
/**
 * @brief RXgN^
 *
 * @param heap  q[v
 */
PokeNumber::PokeNumber( gfl::heap::HeapBase *heap )
{
  m_zenkoku_to_local_table = pml::personal::PersonalData::CreateZenkokuToChihouTable( heap, &m_table_size );
}

/**
 * @brief fXgN^
 */
PokeNumber::~PokeNumber()
{
  GflHeapFreeMemory( m_zenkoku_to_local_table );
}

//--------------------------------------------------------------------
// 擾
//--------------------------------------------------------------------
/**
 * @brief n}ӂɂ邩ǂ
 *
 * @param monsno X^[ԍ
 *
 * @return truen}ӂɂ falseȂ
 */
bool PokeNumber::IsLocalZukan( MonsNo monsno ) const
{
  return this->GetLocalNumber( monsno ) != pml::personal::CHIHOU_NO_NONE;
}

/**
 * @brief n}Ӕԍ擾
 *
 * @param monsno X^[ԍiS}Ӕԍj
 *
 * @return n}Ӕԍ Ȃꍇpml::personal::CHIHOU_NO_NONE
 */
u32 PokeNumber::GetLocalNumber( MonsNo monsno ) const
{
  GFL_ASSERT( monsno < m_table_size/2 );
  return m_zenkoku_to_local_table[ monsno ];
}

/**
 * @brief S}Ӕԍ擾
 *
 * @param u32 n}Ӕԍ
 *
 * @return S}Ӕԍ
 */
MonsNo PokeNumber::GetZenkokuNumber( u32 local_num ) const
{
  for(int i=0; i < m_table_size/2; ++i)
  {
    if( m_zenkoku_to_local_table[i] == local_num )
    {
      return static_cast<MonsNo>(i);
    }
  }
  GFL_ASSERT(0);
  return MONSNO_NULL;
}

GFL_NAMESPACE_END(poke_tool)
