//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *
 *	@file		app_zukan_ListData.h
 *	@brief  }ӃXgf[^
 *	@author	Toru=Nagihashi
 *	@date		2012.05.23
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]
#pragma once
#if !defined( __APP_ZUKAN_LISTDATA_H__)
#define __APP_ZUKAN_LISTDATA_H__

#include <gflib.h>
#include <app/util/app_util_heap.h>
#include <savedata/sv_zukan.h>

GFL_NAMESPACE_BEGIN(app)
GFL_NAMESPACE_BEGIN(zukan)

//========================================================================
//
//  Xgf[^͌orߊl|P݂̂A
//  }Ӄ[hяAɂĕׂ̂łB
//
//========================================================================
class ListData
{
  GFL_FORBID_COPY_AND_ASSIGN(ListData);
public:
  //-----------------------------------------------------------------------
  // RXgN^EfXgN^
  //-----------------------------------------------------------------------
  /**
   * @brief RXgN^
   *
   * @param heap  q[v
   * @param zukan_save  }ӃZ[uf[^
   */
  ListData( app::util::Heap *heap, savedata::ZukanData *zukan_save );
  /**
   * @brief fXgN^
   */
  virtual ~ListData();
  //-----------------------------------------------------------------------
  // ʒuEJg|P
  //-----------------------------------------------------------------------
  /**
   * @brief ݂̃XgԂ݈̌ʒu擾
   *
   * @return ݈ʒu iO`GetMaxj
   */
  u32 GetCurrentIndex( void ) const;
  /**
   * @brief ݂̃XgԂ̓o^擾i{ߊlj
   *        i}Ӄ[hAɂĒlقȂ܂j
   *
   * @return o^
   */
  u32 GetMax( void ) const;
  /**
   * @brief ݂̈ʒũ|PԂ
   *
   * @param monsno  |Pԍ󂯎
   * @param sex ʎ󂯎
   * @param is_rare A󂯎
   * @param form  tH󂯎
   */
  void GetCurrentPokemon( MonsNo * monsno, pml::Sex * sex, bool * is_rare, FormNo * form ) const;
  /**
   * @brief ݂̈ʒũ|PԍԂ
   *
   * @return |Pԍ
   */
  MonsNo GetCurrentPokemon( void ) const;
  /**
   * @brief ݂̈ʒu̐ʂԂ
   *
   * @return 
   */
  pml::Sex GetCurrentSex( void ) const;
  /**
   * @brief ݂̈ʒũAԂ
   *
   * @return Aǂ
   */
  bool GetCurrentRare( void ) const;
  /**
   * @brief ݂̈ʒũtHԂ
   *
   * @return tHǂ
   */
  FormNo GetCurrentForm( void ) const;
  /**
   * @brief ݂̈ʒu̕ߊlԂԂ
   *
   * @return trueȂΕߊl falseȂΌ
   */
  bool GetCurrentCaptureFlag( void ) const;
  /**
   * @brief ݂̈ʒũ|Pݒ肷
   *
   * @param monsno |Pԍ
   * @param sex 
   * @param is_rare A
   * @param form tH
   */
  void SetCurrentPokemon( MonsNo monsno, pml::Sex sex, bool is_rare, FormNo form );
  /**
   * @brief ݂̈ʒũ|Pݒ肷
   *
   * @param monsno |Pԍ
   */
  void SetCurrentPokemon( MonsNo monsno );
  /**
   * @brief ݂̈ʒũ|Pݒ肷
   *
   * @param sex 
   */
  void SetCurrentSex( pml::Sex sex );
  /**
   * @brief ݂̈ʒũ|Pݒ肷
   *
   * @param is_rare A
   */
  void SetCurrentRare( bool is_rare );
  /**
   * @brief ݂̈ʒũ|Pݒ肷
   *
   * @param form tH
   */
  void SetCurrentFrom( FormNo form );
  /**
   * @brief Xg̎֍si{Pj
   * @note  ől𒴂O։荞݂܂B
   */
  void GoToNextPokemon( void );
  /**
   * @brief Xg̑O֍si|Pj
   * @note  ŏlGetMax-1։荞݂܂
   */
  void GoToPrevPokemon( void );

  //-----------------------------------------------------------------------
  // Xgёւ
  //-----------------------------------------------------------------------
  /**
   * @brief }Ӄ[hݒ{XgXV
   *
   * @param mode  }Ӄ[h
   */
  void SetMode( savedata::ZukanData::Mode mode );
  /**
   * @brief }Ӄ[h擾
   *
   * @return }Ӄ[h
   */
  savedata::ZukanData::Mode GetMode( void ) const;
  
  enum SortType
  {
    SORT_TYPE_NUMBER, ///<ԍ
    SORT_TYPE_NAME,   ///<O
  };
  /**
   * @brief ёւނݒ{XgXV
   *
   * @param sort ёւ
   */
  void Sort( SortType sort );
  /**
   * @brief ёւނ擾
   *
   * @return ёւ
   */
  SortType GetSortType( void ) const;

  //-----------------------------------------------------------------------
  // 
  //-----------------------------------------------------------------------
  enum ConditionShapeType
  {
    ConditionShapeType_none,
  };
  struct SearchData
  {
    print::STRCODE  name;   ///<
    pml::PokeType   type1;  ///<^CvP
    pml::PokeType   type2;  ///<^CvQ
    pml::personal::Color  color; ///<F
    ConditionShapeType    shape; ///<`
    SearchData() : name(L' '), type1(POKETYPE_NULL),type2(POKETYPE_NULL),color(pml::personal::COLOR_MAX),shape(ConditionShapeType_none) { }
  };
  /**
   * @brief ݒ{XgXV
   *
   * @param search_data \
   *
   */
  void StartSearch( const SearchData & search_data );
  
  /**
   * @brief ɂČ`FbN
   *
   * @return trueI false 
   */
  bool WaitSearch( void );

  /**
   * @brief 擾
   *
   * @return search_data \
   */
  const SearchData & GetSearchData( void ) const;
private:
  void CreateListData( void );
  void DeleteListData( void );
  void ReLoadListData( void );
  void CalcListIndex( MonsNo monsno );

private:
  app::util::Heap *m_heap;
  savedata::ZukanData *m_zukan_save;
  MonsNo      *m_list_data;
  s32         m_list_num;
  s32         m_list_current;
  SortType    m_sort_type;
  SearchData  m_search_data;
};

GFL_NAMESPACE_END(zukan)
GFL_NAMESPACE_END(app)
  
#endif		// __APP_ZUKAN_LISTDATA_H__
