//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *
 *	@file		app_zukan_ListData.cpp
 *	@brief  }ӃXgf[^
 *	@author	Toru=Nagihashi
 *	@date		2012.05.23
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]

#include "app_zukan_ListData.h"

GFL_NAMESPACE_BEGIN(app)
GFL_NAMESPACE_BEGIN(zukan)

  
//-----------------------------------------------------------------------
// RXgN^EfXgN^
//-----------------------------------------------------------------------
/**
 * @brief RXgN^
 *
 * @param heap  q[v
 * @param zukan_save  }ӃZ[uf[^
 */
ListData::ListData( app::util::Heap *heap, savedata::ZukanData *zukan_save ) :
  m_heap( heap ),
  m_zukan_save( zukan_save ),
  m_sort_type( SORT_TYPE_NUMBER ),
  m_search_data()
{
  this->CreateListData();
  this->CalcListIndex( m_zukan_save->GetDefaultMons() );
}
/**
 * @brief fXgN^
 */
ListData::~ListData()
{
  this->DeleteListData();
}

//-----------------------------------------------------------------------
// ʒu
//-----------------------------------------------------------------------
/**
 * @brief ݂̃XgԂ݈̌ʒu擾
 *
 * @return ݈ʒu iO`GetMaxj
 */
u32 ListData::GetCurrentIndex( void ) const
{
  return m_list_current;
}
/**
 * @brief ݂̃XgԂ̓o^擾i{ߊlj
 *        i}Ӄ[hAɂĒlقȂ܂j
 *
 * @return o^
 */
u32 ListData::GetMax( void ) const
{
  return m_list_num;
}
/**
 * @brief ݂̈ʒũ|PԂ
 *
 * @param monsno  |Pԍ󂯎
 * @param sex ʎ󂯎
 * @param is_rare A󂯎
 * @param form  tH󂯎
 */
void ListData::GetCurrentPokemon( MonsNo * monsno, pml::Sex * sex, bool * is_rare, FormNo * form ) const
{
  MonsNo monsno_ret = this->GetCurrentPokemon();
  pml::Sex sex_ret;
  bool rare_ret; 
  FormNo form_ret;
  m_zukan_save->GetDrawData( monsno_ret, &sex_ret, &rare_ret, &form_ret );
  
  if( monsno )
  {
    *monsno  = monsno_ret;
  }
  if( sex )
  {
    *sex = sex_ret;
  }
  if( is_rare )
  {
    *is_rare = rare_ret;
  }
  if( form )
  {
    *form = form_ret;
  }
}
/**
 * @brief ݂̈ʒũ|PԍԂ
 *
 * @return |Pԍ
 */
MonsNo ListData::GetCurrentPokemon( void ) const
{
  return m_list_data[ m_list_current ];
}

/**
 * @brief ݂̈ʒu̐ʂԂ
 *
 * @return 
 */
pml::Sex ListData::GetCurrentSex( void ) const
{
  pml::Sex sex;
  this->GetCurrentPokemon( NULL, &sex, NULL, NULL );
  return sex;
}
/**
 * @brief ݂̈ʒũAԂ
 *
 * @return Aǂ
 */
bool ListData::GetCurrentRare( void ) const
{
  bool rare;
  this->GetCurrentPokemon( NULL, NULL, &rare, NULL );
  return rare;
}
/**
 * @brief ݂̈ʒũtHԂ
 *
 * @return tHǂ
 */
FormNo ListData::GetCurrentForm( void ) const
{
  FormNo form;
  this->GetCurrentPokemon( NULL, NULL, NULL, &form );
  return form;
}
/**
 * @brief ݂̈ʒu̕ߊlԂԂ
 *
 * @return trueȂΕߊl falseȂΌ
 */
bool ListData::GetCurrentCaptureFlag( void ) const
{
  return m_zukan_save->GetPokeGetFlag( this->GetCurrentPokemon() );
}

/**
 * @brief ݂̈ʒũ|Pݒ肷
 *
 * @param monsno |Pԍ
 * @param sex 
 * @param is_rare A
 * @param form tH
 */
void ListData::SetCurrentPokemon( MonsNo monsno, pml::Sex sex, bool is_rare, FormNo form )
{
  m_zukan_save->SetDrawData( monsno, sex, is_rare, form );
  this->CalcListIndex( monsno );
}
/**
 * @brief ݂̈ʒũ|Pݒ肷
 *
 * @param monsno |Pԍ
 */
void ListData::SetCurrentPokemon( MonsNo monsno )
{
  pml::Sex sex;
  bool is_rare;
  FormNo form;
  this->GetCurrentPokemon( NULL, &sex, &is_rare, &form );
  this->SetCurrentPokemon( monsno, sex, is_rare, form );
}
/**
 * @brief ݂̈ʒũ|Pݒ肷
 *
 * @param sex 
 */
void ListData::SetCurrentSex( pml::Sex sex )
{
  MonsNo monsno;
  bool is_rare;
  FormNo form;
  this->GetCurrentPokemon( &monsno, NULL, &is_rare, &form );
  this->SetCurrentPokemon( monsno, sex, is_rare, form );
}
/**
 * @brief ݂̈ʒũ|Pݒ肷
 *
 * @param is_rare A
 */
void ListData::SetCurrentRare( bool is_rare )
{
  MonsNo monsno;
  pml::Sex sex;
  FormNo form;
  this->GetCurrentPokemon( &monsno, &sex, NULL, &form );
  this->SetCurrentPokemon( monsno, sex, is_rare, form );
}
/**
 * @brief ݂̈ʒũ|Pݒ肷
 *
 * @param form tH
 */
void ListData::SetCurrentFrom( FormNo form )
{
  MonsNo monsno;
  pml::Sex sex;
  bool is_rare;
  this->GetCurrentPokemon( &monsno, &sex, &is_rare, NULL );
  this->SetCurrentPokemon( monsno, sex, is_rare, form );
}
/**
 * @brief Xg̎֍si{Pj
 * @note  ől𒴂O։荞݂܂B
 */
void ListData::GoToNextPokemon( void )
{
  if( m_list_current + 1 < m_list_num )
  {
    ++m_list_current;
  }
  else
  {
    m_list_current  = 0;
  }
  this->SetCurrentPokemon( m_list_data[ m_list_current ] );
}

/**
 * @brief Xg̑O֍si|Pj
 * @note  ŏlGetMax-1։荞݂܂
 */
void ListData::GoToPrevPokemon( void )
{
  if( m_list_current - 1 < 0 )
  {
    m_list_current  = m_list_num-1;
  }
  else
  {
    --m_list_current;
  }
  this->SetCurrentPokemon( m_list_data[ m_list_current ] );
}

//-----------------------------------------------------------------------
// Xgёւ
//-----------------------------------------------------------------------
/**
 * @brief }Ӄ[hݒ{XgXV
 *
 * @param mode  }Ӄ[h
 */
void ListData::SetMode( savedata::ZukanData::Mode mode )
{
  m_zukan_save->SetZukanMode( mode );
  
  //@todo
  this->ReLoadListData();
}

/**
 * @brief }Ӄ[h擾
 *
 * @return }Ӄ[h
 */
savedata::ZukanData::Mode ListData::GetMode( void ) const
{
  return m_zukan_save->GetZukanMode();
}

/**
 * @brief ёւނݒ{XgXV
 *
 * @param sort ёւ
 */
void ListData::Sort( SortType sort )
{
  m_sort_type = sort;
  //@todo
}

/**
 * @brief ёւނ擾
 *
 * @return ёւ
 */
ListData::SortType ListData::GetSortType( void ) const
{
  return m_sort_type;
}

//-----------------------------------------------------------------------
// 
//-----------------------------------------------------------------------
/**
 * @brief ݒ{XgXV
 *
 * @param search_data \
 *
 */
void ListData::StartSearch( const ListData::SearchData & search_data )
{
  //@todo
}


/**
 * @brief ɂČ`FbN
 *
 * @return trueI false 
 */
bool ListData::WaitSearch( void )
{
  //@todo
  return true;
}

/**
 * @brief 擾
 *
 * @param search_data \̎󂯎
 */
const ListData::SearchData & ListData::GetSearchData( void ) const
{
  return m_search_data;
}

//-----------------------------------------------------------------------
// private
//-----------------------------------------------------------------------
/**
 * @brief Xgf[^쐬
 */
void ListData::CreateListData( void )
{
  GFL_ASSERT( m_list_data == NULL );
  m_list_num  = 3;
  m_list_data = reinterpret_cast<MonsNo*>(GflHeapAllocMemory( m_heap->GetSystemHeap(), sizeof(MonsNo)* m_list_num ));
  
  m_list_data[0]  = MONSNO_HUSIGIDANE;
  m_list_data[1]  = MONSNO_HITOKAGE;
  m_list_data[2]  = MONSNO_ZENIGAME;

  //@todo
}
/**
 * @brief Xgf[^j
 */
void ListData::DeleteListData( void )
{
  GflHeapFreeMemory( m_list_data );
  m_list_data = NULL;
}
/**
 * @brief Xgf[^č\
 */
void ListData::ReLoadListData( void )
{
  this->DeleteListData();
  this->CreateListData();
}
/**
 * @brief |PԍCfbNXvZ
 *
 * @param monsno |Pԍ
 */
void ListData::CalcListIndex( MonsNo monsno )
{
  if( monsno == MONSNO_NULL )
  {
    m_list_current  = 0;
    this->SetCurrentPokemon( m_list_data[ m_list_current ] );
  }
  else
  {
    for( m_list_current = 0; m_list_current < m_list_num; ++m_list_current )
    {
      if( m_list_data[ m_list_current ] == monsno )
      {
        return;
      }
    }
    GFL_ASSERT_MSG( 0, "Y|P͂̃Xgɑ݂Ȃ %d\n", monsno );
  }
}

GFL_NAMESPACE_END(zukan)
GFL_NAMESPACE_END(app)

