//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *	GAME FREAK inc.
 *
 *	@file		FieldKusaModel.cpp
 *	@brief  VF[_[f
 *	@author	Masateru Ishiguro
 *	@date		2012.05.24
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]

#define BUILD_XY

#if defined BUILD_XY
  #include <field/FieldKusaModel.h>
#else
  #include "FieldKusaModel.h"
#endif


namespace field {
  
//-----------------------------------------------------------------------------
/// @brief
//-----------------------------------------------------------------------------  
FieldKusaModel::FieldKusaModel(void) : Model()
{
  for( s32 i = 0; i < MaterialMax; ++i )
  {
    m_Materials[ i ] = NULL;
  }
}
  
//-----------------------------------------------------------------------------
/// @brief
//-----------------------------------------------------------------------------
FieldKusaModel::~FieldKusaModel()
{
  FieldKusaModel::Destroy();
}


//-----------------------------------------------------------------------------
/// @brief
//-----------------------------------------------------------------------------
void FieldKusaModel::Create(
    gfl::heap::NwAllocator*           allocator,
    gfl::heap::NwAllocator*           device_allocator,
    gfl::grp::g3d::Resource*          resource,
    s32                               index_in_resource,
    Description*                      description
)
{
  Model::Create( allocator, device_allocator, resource, index_in_resource, description );
  readShaderParam(allocator);
}

//-----------------------------------------------------------------------------
/// @brief
//-----------------------------------------------------------------------------
void FieldKusaModel::Destroy(void)
{
  
}

//-----------------------------------------------------------------------------
/// @brief
//-----------------------------------------------------------------------------
void FieldKusaModel::readShaderParam(gfl::heap::NwAllocator* allocator)
{
  m_MaterialCount = this->GetNwModel()->GetMaterialCount();
  
  for( int i = 0; i < m_MaterialCount; ++i )
  {
    nw::gfx::Material               *material = this->GetNwModel()->GetMaterial( i );
    const char*                     materialName = material->GetName();
    s32                             index = materialName[3] - '0';//SڂCfbNXB̓GNX|[^[ł閼OB
    
    m_Materials[index] = material;
  }
}

//-----------------------------------------------------------------------------
/// @brief
//-----------------------------------------------------------------------------
void FieldKusaModel::setVertexShaderParam( nw::gfx::Material *material, s32 id, s32 elementNo, f32 param )
{
  nw::gfx::ResMaterial&           res_material = material->GetShaderParameterResMaterial();  // GetShadingParameterResMaterial

  for ( int i2 = 0; i2 < res_material.GetShaderParametersCount(); ++i2  )
  {
    nw::gfx::res::ResShaderParameter      res_param = res_material.GetShaderParameters( i2 );

    if( id == res_param.GetSymbolIndex() )
    {
      f32     *pData = res_param.GetParameter().GetValueF32();
      pData[elementNo] = param;
      material->GetShaderParameterResMaterial().SetMaterialColorHash(0);
      break;
    }
  }
}

//-----------------------------------------------------------------------------
/// @brief
//-----------------------------------------------------------------------------
f32 FieldKusaModel::getVertexShaderParam( nw::gfx::Material *material, int id, s32 elementNo )
{
  nw::gfx::ResMaterial&           res_material = material->GetShaderParameterResMaterial();  // GetShadingParameterResMaterial

  for ( int i2 = 0; i2 < res_material.GetShaderParametersCount(); ++i2  )
  {
    nw::gfx::res::ResShaderParameter      res_param = res_material.GetShaderParameters( i2 );

    if( id == res_param.GetSymbolIndex() )
    {
      const f32     *pData = res_param.GetParameter().GetValueF32();
      return pData[elementNo];
    }
  }
  
  return 0.0f;
}

//-----------------------------------------------------------------------------
/// @brief
//-----------------------------------------------------------------------------
void FieldKusaModel::SetShapeDrawFlag( s32 grid_x, s32 grid_y, b32 flag )
{
  s32                 gridID = grid_y * GridXMax + grid_x;
  s32                 materialIndex = gridID / GridIncludeMax;
  s32                 localID = gridID % GridIncludeMax;
  s32                 paramNo = (localID / 4) + 1;
  s32                 elementNo = localID % 4;
  
  if ( m_Materials[materialIndex] == NULL )
    return;
  
  setVertexShaderParam( m_Materials[materialIndex], paramNo, elementNo, flag ? 1.0f : 0.0f );
  
  //value.Set( param.m_OwnPos.x, param.m_OwnPos.y, param.m_OwnPos.z, 0.0f );
  //setVertexShaderParam( CustomParam::ShaderSymbol_1, value );
  
  /*value.Set( param.m_LeftPos.x, param.m_LeftPos.y, param.m_LeftPos.z, param.m_LeftKusaAlpha );
  setVertexShaderParam( CustomParam::ShaderSymbol_2, value );
  
  value.Set( param.m_LeftPipeCurve, 1.0f, param.m_LeftPipeWidth, param.m_LeftAnimTime );
  setVertexShaderParam( CustomParam::ShaderSymbol_3, value );
  
  value.Set( param.m_RightPos.x, param.m_RightPos.y, param.m_RightPos.z, param.m_RightKusaAlpha );
  setVertexShaderParam( CustomParam::ShaderSymbol_4, value );
  
  value.Set( param.m_RightPipeCurve, 1.0f, param.m_RightPipeWidth, param.m_RightAnimTime );
  setVertexShaderParam( CustomParam::ShaderSymbol_5, value );
  
  value.Set( param.m_RightCurveWaight.x, param.m_RightCurveWaight.y, param.m_LeftCurveWaight.x, param.m_LeftCurveWaight.y );
  setVertexShaderParam( CustomParam::ShaderSymbol_6, value );
  
  value.Set( param.m_MyRadius, param.m_LeftRadius, param.m_RightRadius, param.m_MerikomiScale );
  setVertexShaderParam( CustomParam::ShaderSymbol_7, value );*/
  
}

}  // namespace xy_system

