//======================================================================
/**
 *  GAME FREAK inc.
 *
 *  @file   Player.cpp
 *  @brief  V[PXGfB^ō쐬ft@CĐ@\
 *  @date   2012.05.21
 *  @author ito_isao
 *
 */
//====================================================================== 

#include "Player.h"


GFL_NAMESPACE_BEGIN(xy_system)
GFL_NAMESPACE_BEGIN(sequence)

//------------------------------------------------------------------------------
// con, des
//------------------------------------------------------------------------------
Player::Player(gfl::heap::HeapBase* heap, gfl::fs::ArcFile::ARCDATID arc_id, ICommandFactory* factory) : m_heap(heap), m_factory(factory)
{
  tool::seqeditor::InitParam param = 
  {
    heap,
    factory->GetCommandSizeTable()
  };
  m_sys = GFL_NEW(heap) tool::seqeditor::SeqSystem(param);
  m_arc = GFL_NEW(heap) gfl::fs::ArcFile(heap, arc_id, gfl::fs::ArcFile::OPEN);
}

Player::~Player()
{
  this->UnLoad();
  GFL_DELETE(m_sys);
  GFL_DELETE(m_arc);
}

//------------------------------------------------------------------------------
// Loadn
//------------------------------------------------------------------------------
void Player::LoadRequest(int id)
{
  tool::seqeditor::SeqFile* file = m_sys->LoadFile(m_arc, id, this);
  // ǂݍ݌At@C̏I[܂r߂邱ƂŁAKvȃ\[Xt@Cǂ
  file->SkipFrame(-1);
}

bool Player::IsReady()
{
  return true;
}
void Player::Play()
{
  m_playing = true;
  m_frame = 0;
}
bool Player::IsPlaying()
{
  return m_playing;
}

void Player::UnLoad(bool force_unload)
{
  if(!force_unload)
  {
    GFL_ASSERT(m_playing != true);
  }
  m_playing = false;
  
  m_sys->UnLoadAll();
  for(CommandList::Iterator it = m_list.begin(); it != m_list.end(); ++it)
  {
    it->Finalize();
    GFL_DELETE(&*it);
  }
  m_list.clear();
}

//------------------------------------------------------------------------------
void Player::Update()
{
  if(!m_playing){return;}
  
  int finished = 0;
  for(CommandList::Iterator it = m_list.begin(); it != m_list.end(); ++it)
  {
    int start = it->GetStartFrame();
    int end = it->GetEndFrame();
    if(start > m_frame){break;}
    if(end < m_frame){++finished; continue;}
    if(start == m_frame){it->Enter();}
    it->Exec();
    if(end == m_frame){it->Exit();}
  }
  ++m_frame;
  
  if(finished == m_list.size()){m_playing = false;}
}

//------------------------------------------------------------------------------
void Player::CommnadCallback( tool::seqeditor::SeqFile *seqFile , const tool::seqeditor::CommandParam &param )
{
  // eR}hŐ
  ICommand* command = m_factory->CreateCommand(param.commandNo);
  m_list.push_back(command);
  command->SetStartFrame(param.startFrame);
  command->SetEndFrame(param.endFrame);
  command->Initialize(seqFile);
}

GFL_NAMESPACE_END(sequence)
GFL_NAMESPACE_END(xy_system)
