//======================================================================
/**
 *  GAME FREAK inc.
 *
 *  @file   Command.h
 *  @brief  V[PXGfB^ō쐬ft@CĐ@\́AR}hǗ
 *  @date   2012.05.21
 *  @author ito_isao
 *
 */
//====================================================================== 

#ifndef __SYSTEM_SEQUENCE_COMMAND_H__
#define __SYSTEM_SEQUENCE_COMMAND_H__

#include <gflib.h>
#include "tool\seqeditor\seq_editor.h"

GFL_NAMESPACE_BEGIN(xy_system)
GFL_NAMESPACE_BEGIN(sequence)

class ICommand
{
public:
  virtual void Initialize(tool::seqeditor::SeqFile* file){}
  virtual void Finalize(){}
  
  virtual void Enter(){}
  virtual void Exec() = 0;
  virtual void Exit(){}
  
public:
  void SetStartFrame(int start){m_start = start;}
  void SetEndFrame(int end){m_end = end;}
  int GetStartFrame(){return m_start;}
  int GetEndFrame(){return m_end;}
  
  nw::ut::LinkListNode m_node;
private:
  int m_start;
  int m_end;
};

typedef nw::ut::LinkList<ICommand, offsetof(ICommand, m_node)> CommandList;

class ICommandFactory
{
public:
  virtual ICommand* CreateCommand(int command_no) = 0;
  virtual const int* GetCommandSizeTable() = 0;
};



GFL_NAMESPACE_END(sequence)
GFL_NAMESPACE_END(xy_system)


#endif //__SYSTEM_SEQUENCE_PLAYER_H__
