
#ifndef __BTLV_ENCOUNT_EFFECT_SEQUENCE_H__
#define __BTLV_ENCOUNT_EFFECT_SEQUENCE_H__

#include <gflib.h>
#include "system/sequence/Command.h"

GFL_NAMESPACE_BEGIN(btl)

// O錾
class BtlvEncountEffect;

class SequenceFactory : public xy_system::sequence::ICommandFactory
{
public:
  SequenceFactory(BtlvEncountEffect* owner, gfl::heap::HeapBase* heap);
  ~SequenceFactory();
  
  // override
  virtual xy_system::sequence::ICommand* CreateCommand(int id);
  virtual const int* GetCommandSizeTable();
  
private:
  BtlvEncountEffect* m_owner;
  gfl::heap::HeapBase* m_heap;
};

class IEncountCommand : public xy_system::sequence::ICommand
{
public:
  void SetOwner(BtlvEncountEffect* owner){m_owner = owner;}
  virtual void Exec() = 0;
protected:
  BtlvEncountEffect* m_owner;
};

//------------------------------------------------------------------------------
class CommandTest : public IEncountCommand
{
public:
  virtual void Enter();
  virtual void Exec();
};
//------------------------------------------------------------------------------
/*
class CommandBreakEffectPlay : public IEncountCommand
{
public:
  virtual void Initialize();
  virtual void Finalize();
  virtual void Enter();
  virtual void Exec();
};
class CommandBreakEffectPrepare : public IEncountCommand
{
public:
  virtual void Exec();
};
*/

GFL_NAMESPACE_END(btl)

#endif //__BTLV_ENCOUNT_EFFECT_SEQUENCE_H__
