
#include "btlv_encount_effect_sequence.h"
#include "btlv_encount_effect.h"


#include "btlv_encount_command_define.cdat"
#include "btlv_encount_command_define.h"

GFL_NAMESPACE_BEGIN(btl)

SequenceFactory::SequenceFactory(BtlvEncountEffect* owner, gfl::heap::HeapBase* heap) : m_owner(owner), m_heap(heap)
{
}
SequenceFactory::~SequenceFactory()
{
}

xy_system::sequence::ICommand* SequenceFactory::CreateCommand(int id)
{
  IEncountCommand* ret = NULL;
  switch(id)
  {
  case COMMAND_TEST:
    ret = GFL_NEW(m_heap) CommandTest();
    break;
/*
  case COMMAND_BREAK_EFFECT_PLAY:
    ret = GFL_NEW(m_heap) CommandBreakEffectPlay();
    break;
  case COMMAND_BREAK_EFFECT_PREPARE:
    ret = GFL_NEW(m_heap) CommandBreakEffectPrepare();
    break;
*/
  default:
    GFL_ASSERT(0);
    break;
  }
  ret->SetOwner(m_owner);
  return ret;
}

const int* SequenceFactory::GetCommandSizeTable()
{
  return define_size_table;
}
//------------------------------------------------------------------------------
void CommandTest::Enter()
{
  m_owner->Start();
}
void CommandTest::Exec()
{
}

//------------------------------------------------------------------------------
GFL_NAMESPACE_END(btl)

