//============================================================================================
/**
 * @file		pss_invite_window_main.h
 * @brief		C
 * @author  Hisanao Suzuki
 *
 * namespace	app::pss::pss_invite_window::
 *
 * 5279-6982		Avpev[gt@C쐬ꂽƂp^O
 */
//============================================================================================
#ifndef __PSS_INVITE_WINDOW_MAIN_H__
#define __PSS_INVITE_WINDOW_MAIN_H__

#include <app/util/app_util_heap.h>
#include <app/ui/UIInputListener.h>
#include <app/pss/pss_invite_window/pss_invite_window.h>
#include "PssInviteWindowUIListener.h"
#include "pss_invite_window_graphic.h"


namespace app {
namespace pss {
namespace pss_invite_window {


class MainSystem : public PssInviteWindowUIListener
{
private:
  // CV[PX`
  typedef enum {
    MAINSEQ_INIT = 0,
    MAINSEQ_MAIN,
    MAINSEQ_FADE_OUT,
    MAINSEQ_RELEASE,
    MAINSEQ_END
  }MAIN_SEQUENCE;

public:
	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		RXgN^
	 *
	 * @param		prm		Oݒp[^
	 */
	//--------------------------------------------------------------------------------------------
	MainSystem( APP_PARAM * prm );

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		fXgN^
	 */
	//--------------------------------------------------------------------------------------------
	~MainSystem(void);

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		Abvf[g
	 *
	 * @param		none
	 *
	 * @retval true: p
	 * @retval false:I
	 */
	//--------------------------------------------------------------------------------------------
	bool Update(void);

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		`揈
	 *
	 * @param		none
	 *
	 * @return	none
	 */
	//--------------------------------------------------------------------------------------------
	void Draw(void);

public:
  //------------------------------------------------------------------
  /**
   * @brief  LZIʒm
   */
  //------------------------------------------------------------------
   virtual void OnSelectedCancel( void );

private:
	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		Tu[N쐬
	 *
	 * @param		none
	 *
	 * @return	none
	 */
	//--------------------------------------------------------------------------------------------
	void CreateSubWork(void);

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		Tu[N폜
	 *
	 * @param		none
	 *
   * @return  none
	 */
	//--------------------------------------------------------------------------------------------
	void DeleteSubWork(void);

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		tF[hCZbg
	 *
	 * @param		none
	 *
	 * @return	none
	 */
	//--------------------------------------------------------------------------------------------
	void SetFadeIn( void );

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		tF[hAEgZbg
	 *
	 * @param		none
	 *
	 * @return	none
	 */
	//--------------------------------------------------------------------------------------------
	void SetFadeOut( void );

  //------------------------------------------------------------------
  /**
   * @brief CV[PXݒ
   *
   * @param  seq   ؂ւΏۂƂȂV[PX
   */
  //------------------------------------------------------------------
  void SetMainSequence( MAIN_SEQUENCE seq );

  //------------------------------------------------------------------
  /**
   * @brief   V[PXʃvZX
   *
   * @param   none
   *
   * @retval  "true  = "
   * @retval  "false = ȊO"
   */
  //------------------------------------------------------------------
  bool DoSequenceProcess( void );

  // CV[PX
	void MainSeq_Init(void);
	bool MainSeq_Release(void);
	void MainSeq_Fade( MAIN_SEQUENCE seq );
	void MainSeq_Main(void);
	void MainSeq_AnimeWait( void );

private:
	static const u32 APP_HEAP_SIZE    = 0x1000;  // Avp[Jq[vTCY
	static const u32 DEVICE_HEAP_SIZE = 0x20000;  // Avp[JfoCXq[vTCY

private:
	//
  GraphicWork*            m_view;         // `Ǘ
  app::util::Heap         m_heap;         // q[vǗ
  APP_PARAM*              m_appParam;     // Np[^
  MAIN_SEQUENCE           m_sequence;     // JgV[PX
  bool                    m_isFinish;     // fItO
};

}		// pss_invite_window
}		// pss
}		// app


#endif // __PSS_INVITE_WINDOW_MAIN_H__
