//============================================================================================
/**
 * @file		pss_invite_window_main.cpp
 * @brief		C
 * @author  Hisanao Suzuki
 *
 * namespace	app::pss::pss_invite_window::
 *
 * 5279-6982		Avpev[gt@C쐬ꂽƂp^O
 */
//============================================================================================
#include "pss_invite_window_main.h"
#include "gamesystem/ForcedReturnManager.h"
#include "field/subscreen/fieldmenu_snd_def.h"
#include "field/subscreen/pss/fieldmenu_pss.h"


namespace app {
namespace pss {
namespace pss_invite_window {


//--------------------------------------------------------------------------------------------
/**
 * @brief		RXgN^
 *
 * @param		prm		Oݒp[^
 */
//--------------------------------------------------------------------------------------------
MainSystem::MainSystem( APP_PARAM * prm )
{
  m_view       = NULL;
  m_isFinish   = false;

  m_appParam             = prm;
  m_appParam->m_isCancel = false;

  SetMainSequence( MAINSEQ_INIT );
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		fXgN^
 */
//--------------------------------------------------------------------------------------------
MainSystem::~MainSystem(void)
{
  DeleteSubWork();
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		Abvf[g
 *
 * @param		none
 *
 * @retval	"true = "
 * @retval	"false = ȊO"
 */
//--------------------------------------------------------------------------------------------
bool MainSystem::Update(void)
{
  bool isRunning = DoSequenceProcess();

  if( m_view != NULL ){
    m_view->Update();
  }
  m_appParam->m_playerIconMgr->Update();

	return isRunning;
}


//--------------------------------------------------------------------------------------------
/**
 * @brief   V[PXʃvZX
 *
 * @param   none
 *
 * @retval  "true  = "
 * @retval  "false = ȊO"
 */
//--------------------------------------------------------------------------------------------
bool MainSystem::DoSequenceProcess( void )
{
  switch( m_sequence )
  {
    case  MAINSEQ_INIT:
      MainSeq_Init();
      break;

    case  MAINSEQ_MAIN:
      MainSeq_Main();
      break;

    case  MAINSEQ_FADE_OUT:
      MainSeq_Fade( MAINSEQ_RELEASE );
      break;

    case  MAINSEQ_RELEASE:
      if( !MainSeq_Release() ){
        break;
      }
    case  MAINSEQ_END:
      return false;
  }
  return true;
}


//--------------------------------------------------------------------------------------------
/**
 * @brief		`揈
 *
 * @param		none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void MainSystem::Draw(void)
{
  if( m_view != NULL ){
    m_view->Draw();
  }
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		Tu[N쐬
 *
 * @param		none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void MainSystem::CreateSubWork(void)
{
  netapp::pss::PssPersonalDataManager* pssPersonalMgr = GFL_SINGLETON_INSTANCE( gamesystem::GameManager )->GetPssPersonalDataManager();
  netapp::pss::PssPersonalData*        personal[3];

  u32 personalNum = m_appParam->m_targetPlayerNum;
  for( u32 i = 0; i < personalNum; i++ )
  {
    personal[i] = pssPersonalMgr->GetPersonalData( m_appParam->m_targetPlayer[i] );
  }

	m_heap.Create( gfl::heap::Manager::GetHeapByHeapId( HEAPID_FIELDMENU_02 ),
	               gfl::heap::Manager::GetHeapByHeapId( HEAPID_FIELDMENU_DEV_02 ),
	               HEAPID_PSS_INVITE_WINDOW_APP, APP_HEAP_SIZE, HEAPID_PSS_INVITE_WINDOW_DEVICE, DEVICE_HEAP_SIZE );

	m_view = GFL_NEW( m_heap.pHeap ) GraphicWork( &m_heap, m_appParam->m_layout,
                                                 m_appParam->m_messageData, m_appParam->m_wordset,
                                                 m_appParam->m_execMode,
                                                 m_appParam->m_playerIconMgr,
                                                 personal, personalNum
                                              );

	m_view->SetPssInviteWindowUIListener( this );
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		Tu[N폜
 *
 * @param		none
 *
 * @return  none
 */
//--------------------------------------------------------------------------------------------
void MainSystem::DeleteSubWork(void)
{
  if( m_view )
  {
    GFL_DELETE	m_view;
    m_view = NULL;
  }

	m_heap.Delete();
}


//--------------------------------------------------------------------------------------------
/**
 * @brief		tF[hCZbg
 *
 * @param		none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void MainSystem::SetFadeIn( void )
{
  gfl::grp::Fade_Reset( gfl::grp::Fade::DISP_LOWER );
}


//--------------------------------------------------------------------------------------------
/**
 * @brief		tF[hAEgZbg
 *
 * @param		none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void MainSystem::SetFadeOut( void )
{
  gfl::grp::Fade_RequestOut( gfl::grp::Fade::DISP_LOWER, gfl::grp::Fade::OUTTYPE_CAPTURE, 1, false );
}



//--------------------------------------------------------------------------------------------
/**
 * @brief		CV[PXF
 *
 * @param		none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void MainSystem::MainSeq_Init(void)
{
  CreateSubWork();
  m_view->Update();

	SetFadeIn();
  SetMainSequence( MAINSEQ_MAIN );
}


//--------------------------------------------------------------------------------------------
/**
 * @brief		CV[PXF
 *
 * @param		none
 *
 * @return  IȂtrueAIpȂfalseԋp
 *
 *	`FMAINSEQ_RELEASE
 */
//--------------------------------------------------------------------------------------------
bool MainSystem::MainSeq_Release(void)
{
  if( !m_appParam->m_playerIconMgr->IsAbleToDestroy() )
  {
    // vC[ACR[_[쒆
    return false;
  }
	DeleteSubWork();
  SetMainSequence( MAINSEQ_END );

  return true;
}


//--------------------------------------------------------------------------------------------
/**
 * @brief		CV[PXFtF[h҂
 *
 * @param		none
 *
 * @return	̃V[PX
 *
 *	`FMAINSEQ_FADE
 */
//--------------------------------------------------------------------------------------------
void MainSystem::MainSeq_Fade( MAIN_SEQUENCE seq )
{
  if( gfl::grp::Fade_IsEnd() )
  {
    SetMainSequence( seq );
  }
}


//--------------------------------------------------------------------------------------------
/**
 * @brief		CV[PXFC
 *
 * @param		none
 *
 * @return	̃V[PX
 *
 *	`FMAINSEQ_MAIN
 */
//--------------------------------------------------------------------------------------------
void MainSystem::MainSeq_Main(void)
{
  if( m_isFinish ||
      GFL_SINGLETON_INSTANCE(gamesystem::ForcedReturnManager)->IsReturn(gamesystem::ForcedReturnManager::FORCERETURN_APP) )
  {
    m_view->SetInputEnabled( false );
    SetFadeOut();
    SetMainSequence( MAINSEQ_FADE_OUT );
  }
}


//------------------------------------------------------------------
/**
 * @brief CV[PXݒ
 *
 * @param  seq   ؂ւΏۂƂȂV[PX
 */
//------------------------------------------------------------------
void MainSystem::SetMainSequence( MAIN_SEQUENCE seq )
{
  m_sequence = seq;
}


//--------------------------------------------------------------------------------------------
/**
 * @brief  LZIʒm
 */
//--------------------------------------------------------------------------------------------
// @overwride
void MainSystem::OnSelectedCancel( void )
{
  xy_snd::PlaySE( FM_SE_PSS_DECIDE );
  m_appParam->m_isCancel = true;
  m_isFinish = true;
}


}		// pss_invite_window
}		// pss
}		// app

