//============================================================================================
/**
 * @file		pss_invite_window_graphic.h
 * @brief		OtBbN֘A
 * @author	Hisanao Suzuki
 *
 * namespace	app::pss::pss_invite_window::
 *
 * 5279-6982		Avpev[gt@C쐬ꂽƂp^O
 */
//============================================================================================
#ifndef __PSS_INVITE_WINDOW_GRAPHIC_H__
#define __PSS_INVITE_WINDOW_GRAPHIC_H__


#include <app/util/app_util_heap.h>
#include <app/util/app_util_2d.h>
#include <app/ui/UIInputListener.h>
#include <app/ui/UIView.h>
#include <app/ui/UIPlayerIcon.h>

namespace app {
namespace pss {
namespace pss_invite_window {


class GraphicWork : public app::ui::UIView, public app::ui::UIInputListener
{
private:
  // AjID
  typedef enum {
    E_ANMID_CHILE_WINDOW = 0,  // q@pEChE
    E_ANMID_PARENT_WINDOW,     // e@pEChE
    //
    E_ANMID_MAX,
  }E_ANIME_ID;

  typedef enum {
    PSS_INVITE_WINDOW_LAYOUT_ID_LOWER,
    PSS_INVITE_WINDOW_LAYOUT_ID_MAX,
  }LAYOUT_ID;

public:
  //--------------------------------------------------------------------------------------------
  /**
   * @brief		RXgN^
   *
   * @param   heap          q[v
   * @param   layout        pCAEgVXeBNULLȂVK쐬
   * @param   messageData   p郁bZ[Wf[^BNULLȂVK쐬
   * @param   wordset       p郏[hZbgBNULLȂVK쐬
   * @param   mode          샂[h
   * @param   playerIconMgr vC[ACR}l[W
   * @param   personal      ^[QbgL
   * @param   personalNum   ^[QbgL
   */
  //--------------------------------------------------------------------------------------------
  GraphicWork( app::util::Heap * heap, gfl::grp::g2d::LytSys *layout,
               gfl::str::MsgData *messageData, WordSet *wordset, E_EXEC_MODE mode,
               xy_system::player_icon::PlayerIconManager* playerIconMgr,
               netapp::pss::PssPersonalData** personal, u32 personalNum );

  //--------------------------------------------------------------------------------------------
  /**
   * @brief		fXgN^
   */
  //--------------------------------------------------------------------------------------------
  ~GraphicWork(void);

public:
  //--------------------------------------------------------------------------------------------
  /**
   * @brief		Abvf[g
   *
   * @param		none
   *
   * @return	none
   */
  //--------------------------------------------------------------------------------------------
  virtual void Update(void);

  //--------------------------------------------------------------------------------------------
  /**
   * @brief		`
   *
   * @param		none
   *
   * @return	none
   */
  //--------------------------------------------------------------------------------------------
  virtual void Draw(void);

public:
  //--------------------------------------------------------------------------------------------
  /**
   * @brief		UICxgXi̓o^
   *
   * @param		listener UICxgXi
   *
   * @return	none
   */
  //--------------------------------------------------------------------------------------------
  void  SetPssInviteWindowUIListener( PssInviteWindowUIListener* listener );

public:
  // yCANVʒmpXi
  virtual bool OnLayoutPaneEvent( const u32 painId );
  // L[͒ʒmpXi
  virtual bool OnKeyAction( gfl::ui::Button* pKey, gfl::ui::VectorDevice* pStick);

private:

  //--------------------------------------------------------------------------------------------
  /**
   * @brief		2D֘A쐬
   *
   * @param		heap        q[v
   * @param   layout      pCAEgVXeBNULLȂVK쐬
   * @param   messageData p郁bZ[Wf[^BNULLȂVK쐬
   * @param   wordset;    p郏[hZbgBNULLȂVK쐬
   *
   * @return	none
   */
  //--------------------------------------------------------------------------------------------
  void Initialize2D( app::util::Heap * heap, gfl::grp::g2d::LytSys *layout, gfl::str::MsgData *messageData, WordSet *wordset );

  //--------------------------------------------------------------------------------------------
  /**
   * @brief   yCeLXg̐ݒ
   *
   * @param   mode     샂[h
   * @param   personal p[\i
   *
   * @return  none
   */
  //--------------------------------------------------------------------------------------------
  void SetTextMessage( E_EXEC_MODE mode, netapp::pss::PssPersonalData** personal );

  //--------------------------------------------------------------------------------------------
  /**
   * @brief   LN^[ACReNX`̐ݒ
   *
   * @param   layout        pCAEgVXeBNULLȂVK쐬
   * @param   playerIconMgr vC[ACR}l[W
   * @param   iconId        ւvC[ACR̂hc
   *
   * @return  none
   */
  //--------------------------------------------------------------------------------------------
  void SetCharaIcon( app::util::Heap * heap, xy_system::player_icon::PlayerIconManager* playerIconMgr, u32 iconId );

  //--------------------------------------------------------------------------------------------
  /**
   * @brief   lL[[hݒ肷
   *
   * @param   name    O
   * @param   sex     
   *
   * @return  none
   */
  //--------------------------------------------------------------------------------------------
  void SetTextWordWithPersonal( const gfl::str::STRCODE* name, u32 sex );

  //--------------------------------------------------------------------------------------------
  /**
   * @brief   Aj[V̊Jn
   *
   * @param animeId Aj[VID
   */
  //--------------------------------------------------------------------------------------------
  void StartAnime( u32 animeId );

private:
  app::util::Heap*               m_heap;
  PssInviteWindowUIListener*     m_uiListener;
  u32                            m_personalNum;
  app::ui::UIPlayerIcon*         m_playerIcon;   // vC[ACR

  // og[ʃbZ[W
  static const u32 BattleRuleMessage[app::pss::pss_rule_select::BATTLE_TYPE_MAX][app::pss::pss_rule_select::BATTLE_RULE_MAX];

  // CAEgAj
  static const gfl::grp::g2d::LytArcIndex LowerAnmIndex[E_ANMID_MAX];
  // {^j[pyC
  static const u32 BUTTON_PANE_LIST[1];
};


}	// pss_invite_window
}	// pss
}	// app


#endif // __PSS_INVITE_WINDOW_GRAPHIC_H__
