//============================================================================================
/**
 * @file		pss_invite_window_graphic.cpp
 * @brief		OtBbN֘A
 * @author  Hisanao Suzuki
 *
 * namespace	app::pss::pss_invite_window::
 *
 * 5279-6982		Avpev[gt@C쐬ꂽƂp^O
 */
//============================================================================================

#include "pss_invite_window_main.h"
#include "pss_invite_window_res.h"
#include "pss_invite_window_res_pane.h"
#include "arc/arc_def.h"
#include <message/msg_pss_message.h>
#include <message/message.gaix>

namespace app {
namespace pss {
namespace pss_invite_window {



//{^j[pyC
const u32 GraphicWork::BUTTON_PANE_LIST[1] =
{
  PANENAME_TEAM_LOWER_PANE_RETURN_BOUND,
};

// Ajf[^iʁj
const gfl::grp::g2d::LytArcIndex GraphicWork::LowerAnmIndex[E_ANMID_MAX] =
{
    LYTRES_PSS_INVITE_WINDOW_RES_TEAM_LOWER_TEAM_KOKI_BCLAN,
    LYTRES_PSS_INVITE_WINDOW_RES_TEAM_LOWER_TEAM_OYAKI_BCLAN,
};

// og[ʃbZ[W
const u32 GraphicWork::BattleRuleMessage[app::pss::pss_rule_select::BATTLE_TYPE_MAX][app::pss::pss_rule_select::BATTLE_RULE_MAX] =
{
    { msg_pss_05_10_01, msg_pss_05_10_02, msg_pss_05_10_03 },   // VOog
    { msg_pss_05_10_04, msg_pss_05_10_05, msg_pss_05_10_06 },   // _uog
    { msg_pss_05_10_07, msg_pss_05_10_08, msg_pss_05_10_09 },   // gvog
    { msg_pss_05_10_10, msg_pss_05_10_11, msg_pss_05_10_12 },   // [e[Vog
    { msg_pss_05_10_13, msg_pss_05_10_14, msg_pss_05_10_15 },   // }`og
};


//--------------------------------------------------------------------------------------------
/**
 * @brief   RXgN^
 *
 * @param   heap          q[v
 * @param   layout        pCAEgVXeBNULLȂVK쐬
 * @param   messageData   p郁bZ[Wf[^BNULLȂVK쐬
 * @param   wordset       p郏[hZbgBNULLȂVK쐬
 * @param   mode          샂[h
 * @param   playerIconMgr vC[ACR}l[W
 * @param   personal      ^[QbgLz
 * @param   personalNum   ^[QbgL
 */
//--------------------------------------------------------------------------------------------
GraphicWork::GraphicWork( app::util::Heap * heap, gfl::grp::g2d::LytSys *layout,
                          gfl::str::MsgData *messageData, WordSet *wordset, E_EXEC_MODE mode,
                          xy_system::player_icon::PlayerIconManager* playerIconMgr,
                          netapp::pss::PssPersonalData** personal, u32 personalNum ) :
    app::ui::UIView(heap)
{
  m_heap        = heap;
  m_personalNum = personalNum;

  CreateGraphicsSystem( heap );
  Initialize2D( heap, layout, messageData, wordset );

  // {^}l[W
  u32 paneNum = sizeof(BUTTON_PANE_LIST) / sizeof(BUTTON_PANE_LIST[0]);
  CreateButtonManager( heap, GetLayoutWork(PSS_INVITE_WINDOW_LAYOUT_ID_LOWER), BUTTON_PANE_LIST, paneNum );

  SetTextMessage( mode, personal );

  SetInputListener( this );
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		fXgN^
 */
//--------------------------------------------------------------------------------------------
GraphicWork::~GraphicWork(void)
{
  //if( m_playerIcon != NULL )
  //{
  //  GFL_DELETE(m_playerIcon);
  //  m_playerIcon = NULL;
  //}
	Delete2D();
	DeleteGraphicsSystem();
}


//--------------------------------------------------------------------------------------------
/**
 * @brief		UICxgXi̓o^
 *
 * @param		listener UICxgXi
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void  GraphicWork::SetPssInviteWindowUIListener( PssInviteWindowUIListener* listener )
{
  m_uiListener = listener;
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		Abvf[g
 *
 * @param		none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void GraphicWork::Update(void)
{
  app::ui::UIView::Update();
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		`
 *
 * @param		none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void GraphicWork::Draw(void)
{
	m_g2dUtil->Draw2D( m_graphicSystem, PSS_INVITE_WINDOW_LAYOUT_ID_LOWER );
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		2D֘A쐬
 *
 * @param		heap        q[v
 * @param   layout      pCAEgVXeBNULLȂVK쐬
 * @param   messageData p郁bZ[Wf[^BNULLȂVK쐬
 * @param   wordset;    p郏[hZbgBNULLȂVK쐬
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void GraphicWork::Initialize2D( app::util::Heap * heap, gfl::grp::g2d::LytSys *layout, gfl::str::MsgData *messageData, WordSet *wordset )
{
  // A[JCuIDe[u
  static const app::util::G2DUtil::LYT_RES_DATA resTbl[] = {
    { ARCID_PSS_INVITE_WINDOW_GRA, 0, 0 }
  };

  static const app::util::G2DUtil::LYTWK_DATA layoutData[] =
  {
    {	// 
      0,
      LYTRES_PSS_INVITE_WINDOW_RES_TEAM_LOWER_BCLYT,
      LowerAnmIndex,
      GFL_NELEMS(LowerAnmIndex),
      GFL_NELEMS(LowerAnmIndex),
      false,
      app::util::G2DUtil::SETUP_LOWER,
      true,
    },
  };

  if( (messageData == NULL) || (wordset == NULL) )
  {
    Create2D( heap, layout, PSS_INVITE_WINDOW_LAYOUT_ID_MAX,
              resTbl, GFL_NELEMS(resTbl),
              layoutData, GFL_NELEMS(layoutData),
              GARC_message_pss_message_DAT );
  }
  else
  {
    Create2D( heap, layout, PSS_INVITE_WINDOW_LAYOUT_ID_MAX,
              resTbl, GFL_NELEMS(resTbl),
              layoutData, GFL_NELEMS(layoutData),
              messageData, wordset );
  }
}


//--------------------------------------------------------------------------------------------
/**
 * @brief   lL[[hݒ肷
 *
 * @param   name    O
 * @param   sex     
 *
 * @return  none
 */
//--------------------------------------------------------------------------------------------
void GraphicWork::SetTextWordWithPersonal( const gfl::str::STRCODE* name, u32 sex )
{
  gfl::str::StrBuf buf1( name,    m_heap->pHeap );

  WordSet::Grammer grm;
  if( sex == PM_MALE ){
    grm = WordSet::GRAMMER_MALE;
  }
  else if( sex == PM_FEMALE ){
    grm = WordSet::GRAMMER_FEMALE;
  }
  else{
    grm = WordSet::GRAMMER_NEUTRAL;
  }

  m_g2dUtil->SetRegisterWord( 0, buf1, grm, WordSet::FORM_NONE, LANG_NULL );
}


//--------------------------------------------------------------------------------------------
/**
 * @brief   yCeLXg̐ݒ
 *
 * @param   mode     샂[h
 * @param   personal p[\i
 *
 * @return  none
 */
//--------------------------------------------------------------------------------------------
void GraphicWork::SetTextMessage( E_EXEC_MODE mode, netapp::pss::PssPersonalData** personal )
{
  // q
  if( E_MODE_CHILD == mode )
  {
    // }`ogW
    SetTextboxPaneMessage( PSS_INVITE_WINDOW_LAYOUT_ID_LOWER, PANENAME_TEAM_LOWER_PANE_TEAM_TOP_TEXT, msg_pss_05_13_01 );

    // Qo[W߂Ă܂
    SetTextboxPaneMessage( PSS_INVITE_WINDOW_LAYOUT_ID_LOWER, PANENAME_TEAM_LOWER_PANE_TEAM_TEXT_00, msg_pss_05_11_02 );
  }
  // e
  else if( E_MODE_PARENT == mode )
  {
    // }`ogW
    SetTextboxPaneMessage( PSS_INVITE_WINDOW_LAYOUT_ID_LOWER, PANENAME_TEAM_LOWER_PANE_TEAM_TOP_TEXT, msg_pss_05_13_00 );
  }

  // Qo[
  u32 paneID[4][2] =
  {
    { PANENAME_TEAM_LOWER_PANE_TEAM_TEXT_1_01, PANENAME_TEAM_LOWER_PANE_TEAM_TEXT_1_02 },
    { PANENAME_TEAM_LOWER_PANE_TEAM_TEXT_2_01, PANENAME_TEAM_LOWER_PANE_TEAM_TEXT_2_02 },
    { PANENAME_TEAM_LOWER_PANE_TEAM_TEXT_3_01, PANENAME_TEAM_LOWER_PANE_TEAM_TEXT_3_02 },
    { PANENAME_TEAM_LOWER_PANE_TEAM_TEXT_4_01, PANENAME_TEAM_LOWER_PANE_TEAM_TEXT_4_02 },
  };
  for( u32 i = 0; i < 4; i++ )
  {
    if( m_personalNum > i )
    {
      SetTextWordWithPersonal( personal[i]->GetName(), personal[i]->GetSex() );
      SetTextboxPaneMessage( PSS_INVITE_WINDOW_LAYOUT_ID_LOWER, paneID[i][0], msg_pss_05_14_01 );    // 
      SetTextboxPaneMessage( PSS_INVITE_WINDOW_LAYOUT_ID_LOWER, paneID[i][1], msg_pss_05_14_03 );    //
    }
    else{
      SetTextboxPaneString( PSS_INVITE_WINDOW_LAYOUT_ID_LOWER, paneID[i][0], L"" );                  // 
      SetTextboxPaneString( PSS_INVITE_WINDOW_LAYOUT_ID_LOWER, paneID[i][1], L"" );                  // 
    }
  }
}


//--------------------------------------------------------------------------------------------
/**
 * @brief   LN^[ACReNX`̐ݒ
 *
 * @param   layout        pCAEgVXeBNULLȂVK쐬
 * @param   playerIconMgr vC[ACR}l[W
 * @param   iconId        ւvC[ACR̂hc
 *
 * @return  none
 */
//--------------------------------------------------------------------------------------------
void GraphicWork::SetCharaIcon( app::util::Heap * heap, xy_system::player_icon::PlayerIconManager* playerIconMgr, u32 iconId )
{
//  m_playerIcon = GFL_NEW( heap->pHeap ) app::ui::UIPlayerIcon( heap->pHeap, heap->pDevHeap,
//                                          this, playerIconMgr,
//                                          PSS_INVITE_WINDOW_LAYOUT_ID_LOWER,
//                                          PANENAME_YESNO_02_LOWER_PANE_HERO_OBJ,
//                                          LYTRES_PSS_INVITE_WINDOW_RES_FACE1_BCLIM  );
//
//  m_playerIcon->ReplacePlayerIconTexture( iconId );
}

//--------------------------------------------------------------------------------------------
/**
 * @brief   Aj[V̊Jn
 *
 * @param animeId Aj[VID
 */
//--------------------------------------------------------------------------------------------
void GraphicWork::StartAnime( u32 animeId )
{
  m_g2dUtil->StopAnime( PSS_INVITE_WINDOW_LAYOUT_ID_LOWER, animeId, false);
  m_g2dUtil->StartAnime( PSS_INVITE_WINDOW_LAYOUT_ID_LOWER, animeId );
}


//------------------------------------------------------------------
/**
* @brief   yCCxǧm
*
* @param  layoutId ʒm󂯂郌CAEghc
* @param  painId   ʒm󂯂yChc
*
* @return t[ł̑̓CxgȂtrueA
*         ̃CxgrȂfalseԋp邱ƁB
*/
//------------------------------------------------------------------
// @overwride
bool GraphicWork::OnLayoutPaneEvent( const u32 painId )
{
  if( m_uiListener != NULL )
  {
    if( PANENAME_TEAM_LOWER_PANE_RETURN_BOUND == painId )
    {
      m_uiListener->OnSelectedCancel();
    }
  }
  return true;
}

//------------------------------------------------------------------
/**
 * @brief   L[͂̌m
 *
 * @param  pKey    \L[
 * @param  pStick  AiOXeBbN
 */
//------------------------------------------------------------------
// @overwride
bool GraphicWork::OnKeyAction( gfl::ui::Button* pKey, gfl::ui::VectorDevice* pStick)
{
  return true;
}

}	// pss_invite_window
}	// pss
}	// app


