//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *
 *	@file		FieldMsgWinUnit.cpp
 *	@brief  bZ[WEBhEjbg
 *	@author	Masayuki Onoue
 *	@date		2012.05.17
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]

#include "FieldMsgWinUnit.h"

namespace field
{
  
//----------------------------------------------------------------------------
/**
 *	@brief  RXgN^
 */
//-----------------------------------------------------------------------------
MsgWinUnit::MsgWinUnit( void ) :
  mp_device_allocator( NULL ),
  m_win(),
  m_res_id(0),
  mp_lytsys( NULL ),
  m_lyt_wk( NULL ),
  m_lytwk_win_setup(),
  m_status( WIN_STATUS_SETUP_WAIT ),
  mp_str_win( NULL )
{
}

//----------------------------------------------------------------------------
/**
 *	@brief  fXgN^
 */
//-----------------------------------------------------------------------------
MsgWinUnit::~MsgWinUnit( void )
{
}

//----------------------------------------------------------------------------
/**
 *	@brief  p[^ݒ肷
 *
 *	@param	init_param  p[^
 */
//-----------------------------------------------------------------------------
void MsgWinUnit::Initialize( const UnitInitParam &init_param )
{
  // p[^ۑ
  mp_device_manager   = init_param.p_device_manager;
  mp_heap             = init_param.p_heap;
  mp_device_allocator = init_param.p_device_allocator;
  mp_lytsys           = init_param.p_lytsys;
  m_is_auto_draw      = init_param.is_auto_draw;
}

//----------------------------------------------------------------------------
/**
 *	@brief  ZbgAbv
 *
 *	@param	res_id     \[XID
 */
//-----------------------------------------------------------------------------
void MsgWinUnit::Setup( gfl::grp::g2d::LytResID res_id )
{
  // gp郊\[XID̐ݒ
  m_res_id = res_id;
  
  // ZbgAbvf[^쐬iEBhEj
  m_lytwk_win_setup.pos       = gfl::math::VEC3(0,0,0);
  m_lytwk_win_setup.scale     = gfl::math::VEC2(1,1);
  m_lytwk_win_setup.rotate    = gfl::math::VEC3(0,0,0);
  m_lytwk_win_setup.priority  = 0;

  // [N
  m_lyt_wk = m_win.CreateLayoutWork( mp_lytsys,&m_lytwk_win_setup,m_res_id,0 ,mp_device_allocator);
	m_lyt_wk->SetAutoDrawFlag( m_is_auto_draw );


  // CAEgłǂ̘g̕\ɂ̃yC悤ɐݒ肷
  mp_str_win = GFL_NEW( mp_heap ) print::MsgWin( mp_device_manager, m_lyt_wk, 2, 0, mp_heap );
  GFL_ASSERT( mp_str_win );
  mp_str_win->AddLinePaneIdx( m_win.GetTextBoxPaneIdx( true ) );
  mp_str_win->AddLinePaneIdx( m_win.GetTextBoxPaneIdx( false ) );
  
  // ҋ@ԂɈڍs
  SetStatus( WIN_STATUS_SUSPEND );
}

//----------------------------------------------------------------------------
/**
 *	@brief  Is
 */
//-----------------------------------------------------------------------------
void MsgWinUnit::End( void )
{
  mp_lytsys->RemoveLytWk( m_lyt_wk );
  GFL_SAFE_DELETE( mp_str_win );
}

//----------------------------------------------------------------------------
/**
 *	@brief  EBhEĂяo
 */
//-----------------------------------------------------------------------------
void MsgWinUnit::CallMsgWin( MsgWinUnit::WindowCallParam& call_param )
{
  
  mp_str_win->Clear();
  mp_str_win->SetString( *call_param.p_msgbuf );

  m_win.SetWindowPos( call_param.win_pos );
  m_win.SetTailOff();

  // \
  m_win.SetVisible( true );
  
  // Xe[^Xt[INɕύX
  SetStatus( WIN_STATUS_WIN_FRAME_IN );

}

//----------------------------------------------------------------------------
/**
 *	@brief  EBhE
 */
//-----------------------------------------------------------------------------
void MsgWinUnit::CloseMsgWin( void )
{
  // \ɂ
  m_win.SetVisible( false );
}

//----------------------------------------------------------------------------
/**
 *	@brief  EBhȄԂ\
 */
//-----------------------------------------------------------------------------
MsgWinUnit::WIN_STATUS MsgWinUnit::GetStatus( void ) const
{
  return m_status;
}

//----------------------------------------------------------------------------
/**
 *	@brief  Xe[^Xݒ肷
 *
 *	@param	status  ݒ肷Xe[^X
 */
//-----------------------------------------------------------------------------
void MsgWinUnit::SetStatus( MsgWinUnit::WIN_STATUS status )
{
  m_status = status;
}

//----------------------------------------------------------------------------
/**
 *	@brief  Abvf[g
 */
//-----------------------------------------------------------------------------
MsgWinUnit::WIN_STATUS MsgWinUnit::Update( void )
{
  // EBhẼAbvf[g
  m_win.Update();
  
  // V[PX
  switch( GetStatus() )
  {
  case WIN_STATUS_WIN_FRAME_IN:
    {
      // t[CAj[Vs
      bool is_frame_in = m_win.SetFrameInOutAnm( true );
      // t[INAj[V݂邩`FbÑV[PX߂
      if( is_frame_in == true )
      {
        // Aj[V҂s
        SetStatus( WIN_STATUS_WIN_FRAME_IN_WAIT );
        ONOUE_PRINT("Aj[VL\n");
      }else{
        // t[INAj݂Ȃ
        ONOUE_PRINT("Aj[V\n");
        SetStatus( WIN_STATUS_WIN_UPDATE );
      }
    }
    // through break

  case WIN_STATUS_WIN_FRAME_IN_WAIT:
    {
      // Aj[V҂
      if( m_win.IsPlayAnime() == false )
      {
        SetStatus( WIN_STATUS_WIN_UPDATE );
      }
    }
    break;

  case WIN_STATUS_WIN_UPDATE:
    {
      // ̍XV
      const gfl::str::StrWin::Result ret = mp_str_win->Proc();
      

      // IEJ[\̏Ԕ
      if( ret == gfl::str::StrWin::RES_DONE )
      {
        // ҋ@ԂɈڍs
        bool is_frame_out = m_win.SetFrameInOutAnm( false );
        if( is_frame_out == true )
        {
          // IAj[V҂
          SetStatus( WIN_STATUS_WIN_FRAME_OUT_WAIT );
        }
        else
        {
          // IAj[VȂ
          SetStatus( WIN_STATUS_SUSPEND );
        }
      }
    }
    break;

  case WIN_STATUS_WIN_FRAME_OUT_WAIT:
    {
      // Aj[V҂
      if( m_win.IsPlayAnime() == false )
      {
        SetStatus( WIN_STATUS_SUSPEND );
      }
    }
    break;

  case WIN_STATUS_SUSPEND:
    // ҋ@
    break;
    
  case WIN_STATUS_SETUP_WAIT:
    GFL_ASSERT_MSG(0,"MSGWIN:ZbgAbvIĂȂ\n");
    break;

  default:
    GFL_ASSERT_MSG(0,"MSGWIN:m̃V[PX\n");
    break;

  }

  return m_status;
}

} // namespace field

